/*
 * Decompiled with CFR 0.152.
 */
package propagation.order1.weak;

import propagation.order1.StrongConsistency;
import search.Solver;
import search.backtrack.SolverBacktrack;
import utility.Kit;
import utility.interfaces.TagExperimental;
import variables.Variable;
import variables.domains.Domain;

public class Weak1
extends StrongConsistency
implements TagExperimental {
    protected boolean initializeWeights = false;
    protected int[] cumulWeights;
    protected Variable[] selectedVariables;
    private Variable[] priorityVariable = new Variable[1];

    public Weak1(Solver solver) {
        super(solver);
        Kit.control(solver.pb.priorityVars.length == 0);
        if (this.initializeWeights) {
            this.cumulWeights = new int[solver.pb.variables.length];
        }
    }

    protected boolean tryToRefute(Variable x, int a) {
        this.performingProperSearch = true;
        ++this.nSingletonTests;
        this.solver.resetNoSolutions();
        this.solver.setDomainsMarks();
        this.solver.assign(x, a);
        this.solver.restarter.currCutoff = this.solver.restarter.measureSupplier.get() + (long)this.cp().propagating.weakCutoff;
        boolean inconsistent = !this.enforceArcConsistencyAfterAssignment(x) || this.solver.doRun().solManager.nSolutionsFound == 0L && this.solver.isFullExploration();
        this.solver.backtrack(x);
        this.solver.restoreDomainsAtMarks();
        if (inconsistent) {
            ++this.nEffectiveSingletonTests;
        }
        this.solver.resetNoSolutions();
        this.performingProperSearch = false;
        return !inconsistent;
    }

    protected int performInferencesFrom(Variable x) {
        Domain dom = x.dom;
        int sizeBefore = dom.size();
        if (this.onlyBounds) {
            while (dom.size() > 0 && !this.tryToRefute(x, dom.first())) {
                x.dom.removeElementary(dom.first());
            }
            while (dom.size() > 1 && !this.tryToRefute(x, dom.last())) {
                x.dom.removeElementary(dom.last());
            }
        } else {
            int a = dom.first();
            while (a != -1) {
                int b = dom.next(a);
                if (this.cp().verbose > 2) {
                    Kit.log.finest("try " + x + " " + a);
                }
                if (this.initializeWeights) {
                    this.pb().resetWdeg();
                }
                if (!this.tryToRefute(x, a)) {
                    x.dom.removeElementary(a);
                } else if (this.initializeWeights) {
                    for (Variable y : this.solver.pb.variables) {
                        int n = y.num;
                        this.cumulWeights[n] = (int)((double)this.cumulWeights[n] + (y.wdeg - (double)y.ctrs.length));
                    }
                }
                a = b;
            }
        }
        return sizeBefore - dom.size();
    }

    @Override
    protected boolean enforceStrongConsistency() {
        for (int cnt = 0; cnt < this.nPassesLimit; ++cnt) {
            int nbTotalRemovals = 0;
            Variable x = this.solver.futVars.first();
            while (x != null) {
                this.priorityVariable[0] = x;
                ((SolverBacktrack)this.solver).heuristicVars.setPriorityVars(this.priorityVariable, 1);
                int nbRemovals = this.performInferencesFrom(x);
                ((SolverBacktrack)this.solver).heuristicVars.resetPriorityVars();
                if (this.cp().verbose > 2) {
                    Kit.log.info("   check of " + x + " give " + nbRemovals + " removals");
                }
                if (nbRemovals > 0) {
                    nbTotalRemovals += nbRemovals;
                    if (x.dom.size() == 0) {
                        return false;
                    }
                    if (!this.enforceArcConsistencyAfterRefutation(x)) {
                        return false;
                    }
                }
                if (this.solver.hasFinished()) {
                    return true;
                }
                x = this.solver.futVars.next(x);
            }
            if (this.cp().verbose > 1) {
                Kit.log.info("Weak1 Pass " + cnt + " nbTotalRemovals=" + nbTotalRemovals + " nbValuesRemoved=" + Variable.nRemovedValuesFor(this.solver.pb.variables) + (nbTotalRemovals == 0 ? "\n" : ""));
            }
            if (nbTotalRemovals == 0) break;
        }
        this.cp().restarting.n = 1;
        if (this.initializeWeights) {
            for (Variable x : this.solver.pb.variables) {
                x.wdeg = this.cumulWeights[x.num] + x.ctrs.length;
            }
        }
        return true;
    }

    @Override
    protected boolean enforceMore() {
        long c = this.solver.restarter.currCutoff;
        boolean consistent = super.enforceMore();
        this.solver.restarter.currCutoff = c;
        return consistent;
    }
}

