/*
 * Decompiled with CFR 0.152.
 */
package propagation.order1.singleton;

import propagation.order1.StrongConsistency;
import search.Solver;
import search.backtrack.SolverBacktrack;
import utility.Kit;
import variables.Variable;

public abstract class SingletonConsistency
extends StrongConsistency {
    public int nFoundSingletons;

    public SingletonConsistency(Solver solver) {
        super(solver);
    }

    protected abstract int makeSingletonTestsOn(Variable var1);

    @Override
    protected boolean enforceStrongConsistency() {
        for (int cnt = 0; cnt < this.nPassesLimit; ++cnt) {
            long nBefore = this.nEffectiveSingletonTests;
            Variable x = this.solver.futVars.first();
            while (x != null) {
                if (!this.onlyNeighbours || x.isNeighbourOf(((SolverBacktrack)this.solver).dr.varOfLastDecisionIf(true))) {
                    if (x.dom.size() == 1) {
                        ++this.nFoundSingletons;
                    } else {
                        int nRemovals = this.makeSingletonTestsOn(x);
                        if (!(nRemovals <= 0 || x.dom.size() != 0 && this.enforceArcConsistencyAfterRefutation(x))) {
                            return false;
                        }
                        if (this.solver.hasFinished()) {
                            return true;
                        }
                    }
                }
                x = this.solver.futVars.next(x);
            }
            if (this.cp().verbose > 1) {
                this.displayPassInfo(cnt, this.nEffectiveSingletonTests - nBefore, this.nEffectiveSingletonTests - nBefore == 0L);
            }
            if (nBefore == this.nEffectiveSingletonTests) break;
        }
        assert (this.controlArcConsistency());
        return true;
    }

    protected final void displayPassInfo(int cnt, long nEffective, boolean lastMessage) {
        Kit.log.info("Singleton Pass " + cnt + " nEfectiveTests=" + nEffective + " nbValuesRemoved=" + Variable.nRemovedValuesFor(this.solver.pb.variables) + (lastMessage ? "\n" : ""));
    }
}

