/*
 * Decompiled with CFR 0.152.
 */
package propagation.order1.singleton;

import propagation.order1.singleton.SAC;
import search.Solver;
import utility.Kit;
import variables.Variable;

public abstract class SACGreedy
extends SAC {
    public int nBranchesBuilt;
    public int sumBranchSizes;
    protected boolean maximumBranchExtension = false;
    protected boolean stopSACWhenFoundSolution = false;
    protected int nodeDepth;
    protected ShavingEvaluator shavingEvaluator;

    public SACGreedy(Solver solver) {
        super(solver);
    }

    protected boolean canFindAnotherExtensionInsteadOf(Variable x, int a) {
        if (this.solver.depth() == this.nodeDepth) {
            return false;
        }
        x.dom.removeElementary(a);
        return x.dom.size() == 0 ? false : this.enforceArcConsistencyAfterRefutation(x);
    }

    protected boolean manageInconsistentValue(Variable x, int a) {
        ++this.nEffectiveSingletonTests;
        x.dom.removeElementary(a);
        if (this.shavingEvaluator != null) {
            this.shavingEvaluator.updateRatioAfterShavingSuccess(x);
        }
        if (x.dom.size() == 0) {
            return false;
        }
        assert (this.queue.isEmpty());
        return this.enforceArcConsistencyAfterRefutation(x);
    }

    protected void eraseLastBuiltBranch(int branchSize) {
        ++this.nBranchesBuilt;
        this.sumBranchSizes += branchSize;
        for (int i = 0; i < branchSize; ++i) {
            Variable lastPast = this.solver.futVars.lastPast();
            this.solver.backtrack(lastPast);
            if (this.shavingEvaluator == null) continue;
            this.shavingEvaluator.updateRatioAfterShavingFailure(lastPast);
        }
    }

    class ShavingEvaluator {
        private static final double INCREMENT = 0.05;
        private double ratiosThreshold;
        private double[] sucessRatios;
        private int[] nFailuresSinceLastSuccess;
        private double alpha;
        private double beta;

        public double getSucessRatio(Variable x) {
            return this.sucessRatios[x.num];
        }

        public ShavingEvaluator(int nVariables, double alpha, double ratiosThreshold) {
            this.sucessRatios = Kit.repeat(1.0, nVariables);
            this.nFailuresSinceLastSuccess = new int[nVariables];
            this.ratiosThreshold = ratiosThreshold;
            this.alpha = alpha;
            this.beta = 1.0 - alpha;
            assert (ratiosThreshold > 0.0 && ratiosThreshold < 1.0 && alpha > 0.0 && alpha < 1.0);
        }

        public boolean isEligible(Variable x) {
            return this.sucessRatios[x.num] >= this.ratiosThreshold;
        }

        public void updateRatioAfterShavingSuccess(Variable x) {
            this.sucessRatios[x.num] = this.sucessRatios[x.num] * this.alpha + this.beta;
            this.nFailuresSinceLastSuccess[x.num] = 0;
        }

        public void updateRatioAfterShavingFailure(Variable x) {
            this.sucessRatios[x.num] = this.sucessRatios[x.num] * this.alpha;
            int n = x.num;
            this.nFailuresSinceLastSuccess[n] = this.nFailuresSinceLastSuccess[n] + 1;
        }

        public void updateRatioAfterUntest(Variable x) {
            int n = x.num;
            this.sucessRatios[n] = this.sucessRatios[n] + 0.05 / (double)this.nFailuresSinceLastSuccess[x.num];
        }
    }
}

