/*
 * Decompiled with CFR 0.152.
 */
package propagation.order1.partial;

import propagation.order1.singleton.SAC;
import search.Solver;
import search.backtrack.SolverBacktrack;
import utility.interfaces.TagExperimental;
import variables.Variable;
import variables.domains.Domain;

public class SACLastConflict
extends SAC
implements TagExperimental {
    public SACLastConflict(Solver solver) {
        super(solver);
    }

    @Override
    protected boolean enforceStrongConsistency() {
        assert (this.solver.futVars.size() != 0);
        Variable x = ((SolverBacktrack)this.solver).lcReasoner.lastConflictPriorityVar();
        Domain dom = x.dom;
        if (dom.size() == 1) {
            return true;
        }
        int sizeBefore = dom.size();
        while (dom.size() > 0 && !this.checkSAC(x, dom.first())) {
            x.dom.removeElementary(dom.first());
        }
        int nRemovals = sizeBefore - dom.size();
        if (nRemovals > 0) {
            if (dom.size() == 0) {
                return false;
            }
            if (!super.enforceArcConsistencyAfterRefutation(x)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean runInitially() {
        return this.enforceArcConsistency();
    }

    @Override
    public boolean runAfterAssignment(Variable x) {
        return this.enforceArcConsistencyAfterAssignment(x);
    }

    @Override
    public boolean runAfterRefutation(Variable x) {
        if (!super.enforceArcConsistencyAfterRefutation(x)) {
            return false;
        }
        return this.enforceStrongConsistency();
    }
}

