/*
 * Decompiled with CFR 0.152.
 */
package propagation.order1.isomorphism;

import constraints.Constraint;
import constraints.CtrHard;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import propagation.order1.AC;
import search.Solver;
import utility.Kit;
import utility.operations.GraphSimpleUndirected;
import variables.Variable;
import variables.domains.Domain;

public class PropagationIsomorphism2
extends AC {
    private final int NB_MAX_STORED_MATRICES = 50;
    private GraphSimpleUndirected initialPatternGraph;
    private GraphSimpleUndirected initialTargetGraph;
    private long[][][] storedPatternMatrices;
    private long[][][] storedTargetMatrices;
    private boolean useNeighbors1 = true;
    private boolean useNeighbors2 = true;
    private boolean useNeighbors1And2 = true;
    private boolean useMultiset = false;
    private NeighborhoodReasoning neighbors1;
    private NeighborhoodReasoning neighbors2;
    private NeighborhoodReasoning neighbors1And2;
    private long[] patternMultiset;
    private long[][] targetsMultiset;
    private int[] first;
    private int[] last;
    private int[] fixed;
    private int[] nLasts;
    private int[] fixedPatternNeighbors;
    private boolean trace = true;
    private boolean mustCompute = true;
    private Domain[] domains;

    private boolean isDominated(long[] t1, long[] t2) {
        Kit.control(t1.length == t2.length);
        for (int i = t1.length - 1; i >= 0; --i) {
            if (t1[i] <= t2[i]) continue;
            return false;
        }
        return true;
    }

    private List<int[]> computePatternEdges() {
        ArrayList<int[]> edges = new ArrayList<int[]>();
        for (Constraint ctr : this.solver.pb.constraints) {
            if (ctr.scp.length != 2) continue;
            edges.add(new int[]{ctr.scp[0].num, ctr.scp[1].num});
        }
        return edges;
    }

    private List<int[]> computeTargetEdges() {
        ArrayList<int[]> edges = new ArrayList<int[]>();
        for (CtrHard c : this.hards) {
            if (c.scp.length != 2) continue;
            c.tupleManager.firstValidTuple();
            c.tupleManager.overValidTuples(t -> {
                if (c.checkIndexes((int[])t)) {
                    edges.add((int[])t.clone());
                }
            });
            break;
        }
        return edges;
    }

    private void buildGraphs() {
        this.domains = Variable.buildDomainsArrayFor(this.solver.pb.variables);
        this.initialPatternGraph = new GraphSimpleUndirected(this.solver.pb.variables.length, this.computePatternEdges());
        this.initialTargetGraph = new GraphSimpleUndirected(this.domains[0].initSize(), this.computeTargetEdges());
        this.initialPatternGraph.computeNodesAtDistance1();
        this.initialTargetGraph.computeNodesAtDistance1();
        if (this.useNeighbors1) {
            this.neighbors1 = new NeighborhoodReasoning(this.initialPatternGraph.nodesAtDistance1, this.initialTargetGraph.nodesAtDistance1);
        }
        if (this.useNeighbors2) {
            this.neighbors2 = new NeighborhoodReasoning(this.initialPatternGraph.computeNodesAtDistance2(), this.initialTargetGraph.computeNodesAtDistance2());
        }
        if (this.useNeighbors1And2) {
            this.neighbors1And2 = new NeighborhoodReasoning(this.initialPatternGraph.computeNodesAtDistance1And2(), this.initialTargetGraph.computeNodesAtDistance1And2());
        }
        if (this.useMultiset) {
            this.patternMultiset = new long[this.initialPatternGraph.nNodes - 1];
            this.targetsMultiset = new long[this.initialTargetGraph.nNodes][this.initialTargetGraph.nNodes - 1];
        }
        this.storedPatternMatrices = new long[50][][];
        this.storedTargetMatrices = new long[50][][];
        this.first = new int[this.initialPatternGraph.nNodes];
        this.last = new int[this.initialPatternGraph.nNodes];
        this.fixed = new int[this.initialTargetGraph.nNodes];
        this.nLasts = new int[this.initialTargetGraph.nNodes];
        this.fixedPatternNeighbors = new int[this.initialPatternGraph.nNodes];
    }

    private int modifyAdjacence() {
        Kit.control(this.solver.depth() == 0);
        int nbModifications = 0;
        long[][] m = this.initialTargetGraph.adjacency;
        for (int i = 0; i < m.length; ++i) {
            for (int j = i + 1; j < m[i].length; ++j) {
                if (m[i][j] == 0L) continue;
                boolean foundSupport = false;
                for (Constraint ctr : this.solver.pb.constraints) {
                    if (ctr.scp.length != 2 || (!ctr.scp[0].dom.isPresent(i) || !ctr.scp[1].dom.isPresent(j)) && (!ctr.scp[0].dom.isPresent(j) || !ctr.scp[1].dom.isPresent(i))) continue;
                    foundSupport = true;
                    break;
                }
                if (foundSupport) continue;
                ++nbModifications;
                m[i][j] = 0L;
                m[i][j] = 0L;
            }
        }
        if (nbModifications > 0) {
            this.mustCompute = true;
            this.initialTargetGraph.computeNodesAtDistance1();
            if (this.neighbors1 != null) {
                this.neighbors1.reconsiderTargetNodes(this.initialTargetGraph.nodesAtDistance1);
            }
            if (this.neighbors2 != null) {
                this.neighbors2.reconsiderTargetNodes(this.initialTargetGraph.computeNodesAtDistance2());
            }
            if (this.neighbors1And2 != null) {
                this.neighbors1And2.reconsiderTargetNodes(this.initialTargetGraph.computeNodesAtDistance1And2());
            }
            Kit.log.info("nbRemovedEdges=" + nbModifications);
        }
        return nbModifications;
    }

    private boolean isMultisetDominated(long[] t1, long[] t2) {
        if (!this.useMultiset) {
            return true;
        }
        int d = t2.length - t1.length;
        for (int i = t1.length - 1; i >= 0; --i) {
            if (t1[i] <= t2[i + d]) continue;
            return false;
        }
        return true;
    }

    private long[] copyAdjacenceAtRow(long[] src, long[] dst, int exceptValuePosition) {
        Kit.control(dst.length == src.length - (exceptValuePosition != -1 ? 1 : 0));
        if (exceptValuePosition != -1) {
            int cnt = 0;
            for (int i = 0; i < src.length; ++i) {
                if (exceptValuePosition == i) continue;
                dst[cnt++] = src[i];
            }
        } else {
            System.arraycopy(src, 0, dst, 0, src.length);
        }
        return dst;
    }

    private long[][] copyAdjacence(long[][] src, long[][] dst) {
        Kit.control(dst.length == src.length);
        for (int i = 0; i < dst.length; ++i) {
            this.copyAdjacenceAtRow(src[i], dst[i], i);
        }
        return dst;
    }

    private long[][] times(GraphSimpleUndirected initialGraph, long[][] m2) {
        long[][] adjacence = new long[initialGraph.nNodes][initialGraph.nNodes];
        long[][] m1 = initialGraph.adjacency;
        for (int i = 0; i < initialGraph.nNodes; ++i) {
            for (int j = 0; j <= i; ++j) {
                int sum = 0;
                for (int k : initialGraph.nodesAtDistance1[i]) {
                    sum = (int)((long)sum + m1[i][k] * m2[k][j]);
                }
                long l = sum;
                adjacence[j][i] = l;
                adjacence[i][j] = l;
            }
        }
        return adjacence;
    }

    private boolean isPivotDominated(int i, int j, int limit) {
        for (int k = 0; k <= limit; ++k) {
            if (this.storedPatternMatrices[k][i][i] <= this.storedTargetMatrices[k][j][j]) continue;
            return false;
        }
        return true;
    }

    private int filter(int limit) {
        int nbValuesBefore = this.solver.pb.nValuesRemoved;
        if (this.neighbors1 != null) {
            this.neighbors1.recordScores(limit);
        }
        if (this.neighbors2 != null) {
            this.neighbors2.recordScores(limit);
        }
        if (this.neighbors1And2 != null) {
            this.neighbors1And2.recordScores(limit);
        }
        Variable x = this.solver.futVars.first();
        while (x != null) {
            int num = x.num;
            Domain dom = x.dom;
            int sizeBefore = dom.size();
            int idx = dom.first();
            while (idx != -1) {
                if (!this.isPivotDominated(num, idx, limit) || this.neighbors1 != null && !this.neighbors1.isNeighborDominated(num, idx) || this.neighbors2 != null && !this.neighbors2.isNeighborDominated(num, idx) || this.neighbors1And2 != null && !this.neighbors1And2.isNeighborDominated(num, idx) || this.useMultiset && !this.isMultisetDominated(this.patternMultiset, this.targetsMultiset[idx])) {
                    dom.removeElementary(idx);
                }
                idx = dom.next(idx);
            }
            if (sizeBefore > dom.size()) {
                this.queue.add(x);
            }
            x = this.solver.futVars.next(x);
        }
        return this.solver.pb.nValuesRemoved - nbValuesBefore;
    }

    private boolean filterFromAdjacences() {
        this.storedPatternMatrices[0] = this.mustCompute || this.storedPatternMatrices[0] == null ? Kit.cloneDeeply(this.initialPatternGraph.adjacency) : this.storedPatternMatrices[0];
        this.storedTargetMatrices[0] = this.mustCompute || this.storedTargetMatrices[0] == null ? Kit.cloneDeeply(this.initialTargetGraph.adjacency) : this.storedTargetMatrices[0];
        int i = 0;
        while (true) {
            this.storedPatternMatrices[i + 1] = this.mustCompute || this.storedPatternMatrices[i + 1] == null ? this.times(this.initialPatternGraph, this.storedPatternMatrices[i]) : this.storedPatternMatrices[i + 1];
            long[][] lArray = this.storedTargetMatrices[i + 1] = this.mustCompute || this.storedTargetMatrices[i + 1] == null ? this.times(this.initialTargetGraph, this.storedTargetMatrices[i]) : this.storedTargetMatrices[i + 1];
            if (!Kit.withNoNegativeValues(this.storedPatternMatrices[i + 1]) || !Kit.withNoNegativeValues(this.storedTargetMatrices[i + 1])) break;
            ++i;
        }
        int nbRemovals = this.filter(i);
        if (nbRemovals > 0 && this.trace) {
            Kit.log.info("At " + i + " NbRems= " + nbRemovals + " sum=" + this.solver.pb.nValuesRemoved);
        }
        return nbRemovals > 0;
    }

    public PropagationIsomorphism2(Solver solver) {
        super(solver);
        this.buildGraphs();
    }

    @Override
    public boolean runInitially() {
        Boolean consistent = null;
        while (consistent == null) {
            boolean removals = this.filterFromAdjacences();
            if (Variable.firstWipeoutVariableIn(this.solver.pb.variables) != null) {
                consistent = Boolean.FALSE;
                continue;
            }
            if (!super.runInitially()) {
                consistent = Boolean.FALSE;
                continue;
            }
            int nbModifications = this.modifyAdjacence();
            if (removals || nbModifications != 0) continue;
            consistent = Boolean.TRUE;
        }
        assert (this.queue.size() == 0);
        this.mustCompute = false;
        this.useMultiset = false;
        return consistent;
    }

    @Override
    public boolean runAfterAssignment(Variable x) {
        return super.runAfterAssignment(x);
    }

    @Override
    public boolean runAfterRefutation(Variable x) {
        return super.runAfterRefutation(x);
    }

    private class NeighborhoodReasoning {
        private Nodes[] patterns;
        private Nodes[] targets;
        private int nFixedPatternNeighbors;

        private NeighborhoodReasoning(int[][] patternNeighbours, int[][] targetNeighbours) {
            int i;
            Kit.control(patternNeighbours.length == ((PropagationIsomorphism2)PropagationIsomorphism2.this).initialPatternGraph.nNodes && targetNeighbours.length == ((PropagationIsomorphism2)PropagationIsomorphism2.this).initialTargetGraph.nNodes);
            this.patterns = new Nodes[patternNeighbours.length];
            for (i = 0; i < this.patterns.length; ++i) {
                this.patterns[i] = new Nodes(i, patternNeighbours[i]);
            }
            this.targets = new Nodes[targetNeighbours.length];
            for (i = 0; i < this.targets.length; ++i) {
                this.targets[i] = new Nodes(i, targetNeighbours[i]);
            }
        }

        private void reconsiderTargetNodes(int[][] targetNeighbours) {
            for (int i = 0; i < this.targets.length; ++i) {
                this.targets[i] = new Nodes(i, targetNeighbours[i]);
            }
        }

        private void recordScores(int limit) {
            int i;
            for (i = 0; i < this.patterns.length; ++i) {
                this.patterns[i].recordAndSort(limit, PropagationIsomorphism2.this.storedPatternMatrices);
            }
            for (i = 0; i < this.targets.length; ++i) {
                this.targets[i].recordAndSort(limit, PropagationIsomorphism2.this.storedTargetMatrices);
            }
        }

        private boolean fix(int k, int v) {
            int n = v;
            ((PropagationIsomorphism2)PropagationIsomorphism2.this).last[k] = n;
            ((PropagationIsomorphism2)PropagationIsomorphism2.this).first[k] = n;
            ((PropagationIsomorphism2)PropagationIsomorphism2.this).fixed[v] = k;
            ((PropagationIsomorphism2)PropagationIsomorphism2.this).fixedPatternNeighbors[this.nFixedPatternNeighbors++] = k;
            return true;
        }

        private boolean isNeighborDominated(int i, int j) {
            int k;
            boolean newFixed;
            int nbTargetNeighbors;
            Kit.IntWithLongArrayScoreReverse[] patternScores = this.patterns[i].pairs;
            Kit.IntWithLongArrayScoreReverse[] targetScores = this.targets[j].pairs;
            int nPatternNeighbors = this.patterns[i].pairs.length;
            if (nPatternNeighbors > (nbTargetNeighbors = this.targets[j].pairs.length)) {
                return false;
            }
            Arrays.fill(PropagationIsomorphism2.this.fixed, 0, nbTargetNeighbors, -1);
            Arrays.fill(PropagationIsomorphism2.this.nLasts, 0, nbTargetNeighbors, 0);
            this.nFixedPatternNeighbors = 0;
            for (int k2 = 0; k2 < nPatternNeighbors; ++k2) {
                ((PropagationIsomorphism2)PropagationIsomorphism2.this).first[k2] = this.targets[j].findDominanceSupportFor(patternScores[k2], 0, nbTargetNeighbors, true);
                if (PropagationIsomorphism2.this.first[k2] == -1) {
                    return false;
                }
                ((PropagationIsomorphism2)PropagationIsomorphism2.this).last[k2] = this.targets[j].findDominanceSupportFor(patternScores[k2], nbTargetNeighbors - 1, PropagationIsomorphism2.this.first[k2], false);
                if (PropagationIsomorphism2.this.last[k2] == -1) {
                    this.fix(k2, PropagationIsomorphism2.this.first[k2]);
                }
                int[] nArray = PropagationIsomorphism2.this.nLasts;
                int n = PropagationIsomorphism2.this.last[k2];
                nArray[n] = nArray[n] + 1;
            }
            do {
                newFixed = false;
                for (k = 0; k < nPatternNeighbors; ++k) {
                    if (PropagationIsomorphism2.this.first[k] == PropagationIsomorphism2.this.last[k]) continue;
                    int fixedLast = PropagationIsomorphism2.this.fixed[PropagationIsomorphism2.this.last[k]];
                    if (PropagationIsomorphism2.this.fixed[PropagationIsomorphism2.this.first[k]] != -1) {
                        ((PropagationIsomorphism2)PropagationIsomorphism2.this).first[k] = this.targets[j].findDominanceSupportFor(patternScores[k], PropagationIsomorphism2.this.first[k] + 1, PropagationIsomorphism2.this.last[k], true);
                        if (PropagationIsomorphism2.this.first[k] == -1) {
                            if (fixedLast != -1) {
                                return false;
                            }
                            newFixed = this.fix(k, PropagationIsomorphism2.this.last[k]);
                        }
                    }
                    if (fixedLast == -1) continue;
                    int[] nArray = PropagationIsomorphism2.this.nLasts;
                    int n = PropagationIsomorphism2.this.last[k];
                    nArray[n] = nArray[n] - 1;
                    ((PropagationIsomorphism2)PropagationIsomorphism2.this).last[k] = this.targets[j].findDominanceSupportFor(patternScores[k], PropagationIsomorphism2.this.last[k] - 1, PropagationIsomorphism2.this.first[k], false);
                    if (PropagationIsomorphism2.this.last[k] == -1) {
                        newFixed = this.fix(k, PropagationIsomorphism2.this.first[k]);
                    }
                    int[] nArray2 = PropagationIsomorphism2.this.nLasts;
                    int n2 = PropagationIsomorphism2.this.last[k];
                    nArray2[n2] = nArray2[n2] + 1;
                }
            } while (newFixed);
            int sum = 0;
            for (k = 0; k < nPatternNeighbors; ++k) {
                if ((sum += PropagationIsomorphism2.this.nLasts[k]) <= k + 1) continue;
                return false;
            }
            boolean test = true;
            if (test) {
                for (int cnt1 = 0; cnt1 < this.nFixedPatternNeighbors; ++cnt1) {
                    for (int cnt2 = cnt1 + 1; cnt2 < this.nFixedPatternNeighbors; ++cnt2) {
                        int jjj;
                        int jj;
                        int k1 = PropagationIsomorphism2.this.fixedPatternNeighbors[cnt1];
                        int k2 = PropagationIsomorphism2.this.fixedPatternNeighbors[cnt2];
                        int ii = patternScores[k1].index;
                        int iii = patternScores[k2].index;
                        if (((PropagationIsomorphism2)PropagationIsomorphism2.this).initialPatternGraph.adjacency[ii][iii] == 0L || ((PropagationIsomorphism2)PropagationIsomorphism2.this).initialTargetGraph.adjacency[jj = targetScores[((PropagationIsomorphism2)PropagationIsomorphism2.this).last[k1]].index][jjj = targetScores[((PropagationIsomorphism2)PropagationIsomorphism2.this).last[k2]].index] != 0L) continue;
                        return false;
                    }
                }
            }
            return true;
        }

        private class Nodes {
            private int i;
            private Kit.IntWithLongArrayScoreReverse[] pairs;

            private Nodes(int i, int[] indices) {
                this.i = i;
                this.pairs = new Kit.IntWithLongArrayScoreReverse[indices.length];
                for (int j = 0; j < this.pairs.length; ++j) {
                    this.pairs[j] = new Kit.IntWithLongArrayScoreReverse(indices[j]);
                }
            }

            private void recordAndSort(int limit, long[][][] storedMatrices) {
                if (this.pairs.length == 0) {
                    return;
                }
                if (this.pairs[0].score == null) {
                    for (Kit.IntWithLongArrayScoreReverse pair : this.pairs) {
                        pair.score = new long[limit + 1];
                    }
                } else {
                    Kit.control(this.pairs[0].score.length == limit + 1);
                }
                for (Kit.IntWithLongArrayScoreReverse pair : this.pairs) {
                    int j = pair.index;
                    for (int k = 0; k <= limit; ++k) {
                        pair.score[k] = storedMatrices[k][this.i][j];
                    }
                }
            }

            private int findDominanceSupportFor(Kit.IntWithLongArrayScoreReverse pair, int from, int to, boolean first) {
                if (first) {
                    for (int i = from; i < to; ++i) {
                        if (!PropagationIsomorphism2.this.isDominated(pair.score, this.pairs[i].score) || PropagationIsomorphism2.this.fixed[i] != -1 || !PropagationIsomorphism2.this.domains[pair.index].isPresent(this.pairs[i].index)) continue;
                        return i;
                    }
                } else {
                    for (int i = from; i > to; --i) {
                        if (!PropagationIsomorphism2.this.isDominated(pair.score, this.pairs[i].score) || PropagationIsomorphism2.this.fixed[i] != -1 || !PropagationIsomorphism2.this.domains[pair.index].isPresent(this.pairs[i].index)) continue;
                        return i;
                    }
                }
                return -1;
            }
        }
    }
}

