/*
 * Decompiled with CFR 0.152.
 */
package propagation.order1.isomorphism;

import constraints.Constraint;
import constraints.CtrHard;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import propagation.order1.AC;
import search.Solver;
import utility.Kit;
import utility.operations.GraphSimpleUndirected;
import variables.Variable;
import variables.domains.Domain;

public class PropagationIsomorphism
extends AC {
    private final int NB_MIN_TURNS = 3;
    private final int NB_MAX_STORED_MATRICES = 50;
    private GraphSimpleUndirected initialPatternGraph;
    private GraphSimpleUndirected initialTargetGraph;
    private long[][][] patternMatrices;
    private long[][][] targetMatrices;
    private boolean useNeighbors1 = true;
    private boolean useNeighbors2 = false;
    private boolean useNeighbors1And2 = false;
    private boolean useMultiset = true;
    private NeighborhoodReasoning neighbors1;
    private NeighborhoodReasoning neighbors2;
    private NeighborhoodReasoning neighbors1And2;
    private long[] patternMultiset;
    private long[][] targetsMultiset;
    private int[] first;
    private int[] last;
    private int[] fixed;
    private int[] nbLasts;
    private int[] fixedPatternNeighbors;
    private boolean trace = false;
    private boolean mustComputePattern = true;
    private boolean mustComputeTarget = true;
    private Domain[] domains;

    private List<int[]> computePatternEdges() {
        ArrayList<int[]> edges = new ArrayList<int[]>();
        for (Constraint ctr : this.solver.pb.constraints) {
            if (ctr.scp.length != 2) continue;
            edges.add(new int[]{ctr.scp[0].num, ctr.scp[1].num});
        }
        return edges;
    }

    private List<int[]> computeTargetEdges() {
        ArrayList<int[]> edges = new ArrayList<int[]>();
        for (CtrHard c : this.hards) {
            if (c.scp.length != 2) continue;
            c.tupleManager.firstValidTuple();
            c.tupleManager.overValidTuples(t -> {
                if (c.checkIndexes((int[])t)) {
                    edges.add((int[])t.clone());
                }
            });
            break;
        }
        return edges;
    }

    private void buildGraphs() {
        this.domains = Variable.buildDomainsArrayFor(this.solver.pb.variables);
        this.initialPatternGraph = new GraphSimpleUndirected(this.solver.pb.variables.length, this.computePatternEdges());
        this.initialTargetGraph = new GraphSimpleUndirected(this.domains[0].initSize(), this.computeTargetEdges());
        this.initialPatternGraph.computeNodesAtDistance1();
        this.initialTargetGraph.computeNodesAtDistance1();
        if (this.useNeighbors1) {
            this.neighbors1 = new NeighborhoodReasoning(this.initialPatternGraph.nodesAtDistance1, this.initialTargetGraph.nodesAtDistance1);
        }
        if (this.useNeighbors2) {
            this.neighbors2 = new NeighborhoodReasoning(this.initialPatternGraph.computeNodesAtDistance2(), this.initialTargetGraph.computeNodesAtDistance2());
        }
        if (this.useNeighbors1And2) {
            this.neighbors1And2 = new NeighborhoodReasoning(this.initialPatternGraph.computeNodesAtDistance1And2(), this.initialTargetGraph.computeNodesAtDistance1And2());
        }
        if (this.useMultiset) {
            this.patternMultiset = new long[this.initialPatternGraph.nNodes - 1];
            this.targetsMultiset = new long[this.initialTargetGraph.nNodes][this.initialTargetGraph.nNodes - 1];
        }
        this.patternMatrices = new long[50][][];
        this.targetMatrices = new long[50][][];
        this.first = new int[this.initialPatternGraph.nNodes];
        this.last = new int[this.initialPatternGraph.nNodes];
        this.fixed = new int[this.initialTargetGraph.nNodes];
        this.nbLasts = new int[this.initialTargetGraph.nNodes];
        this.fixedPatternNeighbors = new int[this.initialPatternGraph.nNodes];
    }

    private int modifyAdjacence() {
        Kit.control(this.solver.depth() == 0);
        int nbModifications = 0;
        long[][] m = this.initialTargetGraph.adjacency;
        for (int i = 0; i < m.length; ++i) {
            for (int j = i + 1; j < m[i].length; ++j) {
                if (m[i][j] == 0L) continue;
                boolean foundSupport = false;
                for (Constraint ctr : this.solver.pb.constraints) {
                    if (ctr.scp.length != 2 || (!ctr.scp[0].dom.isPresent(i) || !ctr.scp[1].dom.isPresent(j)) && (!ctr.scp[0].dom.isPresent(j) || !ctr.scp[1].dom.isPresent(i))) continue;
                    foundSupport = true;
                    break;
                }
                if (foundSupport) continue;
                ++nbModifications;
                m[i][j] = 0L;
                m[i][j] = 0L;
            }
        }
        if (nbModifications > 0) {
            this.mustComputeTarget = true;
            this.initialTargetGraph.computeNodesAtDistance1();
            if (this.neighbors1 != null) {
                this.neighbors1.reconsiderTargetNodes(this.initialTargetGraph.nodesAtDistance1);
            }
            if (this.neighbors2 != null) {
                this.neighbors2.reconsiderTargetNodes(this.initialTargetGraph.computeNodesAtDistance2());
            }
            if (this.neighbors1And2 != null) {
                this.neighbors1And2.reconsiderTargetNodes(this.initialTargetGraph.computeNodesAtDistance1And2());
            }
            Kit.log.info("nbRemovedEdges=" + nbModifications);
        } else {
            this.mustComputeTarget = false;
        }
        return nbModifications;
    }

    private boolean isMultisetDominated(long[] t1, long[] t2) {
        if (!this.useMultiset) {
            return true;
        }
        int d = t2.length - t1.length;
        for (int i = t1.length - 1; i >= 0; --i) {
            if (t1[i] <= t2[i + d]) continue;
            return false;
        }
        return true;
    }

    private long[] copyAdjacenceAtRow(long[] src, long[] dst, int exceptValuePosition) {
        Kit.control(dst.length == src.length - (exceptValuePosition != -1 ? 1 : 0));
        if (exceptValuePosition != -1) {
            int cnt = 0;
            for (int i = 0; i < src.length; ++i) {
                if (exceptValuePosition == i) continue;
                dst[cnt++] = src[i];
            }
        } else {
            System.arraycopy(src, 0, dst, 0, src.length);
        }
        return dst;
    }

    private long[][] copyAdjacence(long[][] src, long[][] dst) {
        Kit.control(dst.length == src.length);
        for (int i = 0; i < dst.length; ++i) {
            this.copyAdjacenceAtRow(src[i], dst[i], i);
        }
        return dst;
    }

    private long[][] times(GraphSimpleUndirected initialGraph, long[][] m2) {
        long[][] adjacence = new long[initialGraph.nNodes][initialGraph.nNodes];
        long[][] m1 = initialGraph.adjacency;
        for (int i = 0; i < initialGraph.nNodes; ++i) {
            for (int j = 0; j <= i; ++j) {
                int sum = 0;
                for (int k : initialGraph.nodesAtDistance1[i]) {
                    sum = (int)((long)sum + m1[i][k] * m2[k][j]);
                }
                long l = sum;
                adjacence[j][i] = l;
                adjacence[i][j] = l;
            }
        }
        return adjacence;
    }

    private int filter(long[][] patternAdjacence, long[][] targetAdjacence) {
        int nbValuesBefore = this.solver.pb.nValuesRemoved;
        if (this.neighbors1 != null) {
            this.neighbors1.recordScores(patternAdjacence, targetAdjacence);
        }
        if (this.neighbors2 != null) {
            this.neighbors2.recordScores(patternAdjacence, targetAdjacence);
        }
        if (this.neighbors1And2 != null) {
            this.neighbors1And2.recordScores(patternAdjacence, targetAdjacence);
        }
        if (this.useMultiset) {
            for (long[] t : this.copyAdjacence(targetAdjacence, this.targetsMultiset)) {
                Kit.sort(t);
            }
        }
        Variable x = this.solver.futVars.first();
        while (x != null) {
            int num = x.num;
            if (this.useMultiset) {
                Kit.sort(this.copyAdjacenceAtRow(patternAdjacence[num], this.patternMultiset, num));
            }
            Domain dom = x.dom;
            int sizeBefore = dom.size();
            int idx = dom.first();
            while (idx != -1) {
                if (patternAdjacence[num][num] > targetAdjacence[idx][idx] || this.neighbors1 != null && !this.neighbors1.isNeighborDominated(num, idx) || this.useMultiset && !this.isMultisetDominated(this.patternMultiset, this.targetsMultiset[idx])) {
                    dom.removeElementary(idx);
                }
                idx = dom.next(idx);
            }
            if (dom.size() == 0) {
                return Integer.MAX_VALUE;
            }
            if (sizeBefore > dom.size()) {
                this.queue.add(x);
            }
            x = this.solver.futVars.next(x);
        }
        return this.solver.pb.nValuesRemoved - nbValuesBefore;
    }

    private Boolean filterFromAdjacences() {
        this.patternMatrices[0] = this.mustComputePattern || this.patternMatrices[0] == null ? Kit.cloneDeeply(this.initialPatternGraph.adjacency) : this.patternMatrices[0];
        this.targetMatrices[0] = this.mustComputeTarget || this.targetMatrices[0] == null ? Kit.cloneDeeply(this.initialTargetGraph.adjacency) : this.targetMatrices[0];
        int i = 0;
        while (true) {
            int nbRemovals = 0;
            nbRemovals = this.filter(this.patternMatrices[i], this.targetMatrices[i]);
            if (nbRemovals > 0 || i < 3) {
                if (this.trace) {
                    Kit.log.info("At " + i + " NbRems= " + nbRemovals + " sum=" + this.solver.pb.nValuesRemoved);
                }
                if (nbRemovals == Integer.MAX_VALUE) {
                    return Boolean.FALSE;
                }
            } else {
                return null;
            }
            this.patternMatrices[i + 1] = this.mustComputePattern || this.patternMatrices[i + 1] == null ? this.times(this.initialPatternGraph, this.patternMatrices[i]) : this.patternMatrices[i + 1];
            long[][] lArray = this.targetMatrices[i + 1] = this.mustComputeTarget || this.targetMatrices[i + 1] == null ? this.times(this.initialTargetGraph, this.targetMatrices[i]) : this.targetMatrices[i + 1];
            if (!Kit.withNoNegativeValues(this.patternMatrices[i + 1]) || !Kit.withNoNegativeValues(this.targetMatrices[i + 1])) {
                if (this.trace) {
                    Kit.log.info("stop due to overflow at " + i);
                }
                return Boolean.TRUE;
            }
            ++i;
        }
    }

    public PropagationIsomorphism(Solver solver) {
        super(solver);
        this.buildGraphs();
    }

    @Override
    public boolean runInitially() {
        Boolean consistent = null;
        while (consistent == null) {
            Boolean result = this.filterFromAdjacences();
            if (result == Boolean.FALSE) {
                consistent = Boolean.FALSE;
                continue;
            }
            if (!super.runInitially()) {
                consistent = Boolean.FALSE;
                continue;
            }
            int nbModifications = this.modifyAdjacence();
            if (result != null || nbModifications != 0) continue;
            consistent = Boolean.TRUE;
        }
        assert (this.queue.size() == 0);
        this.mustComputeTarget = false;
        this.useMultiset = false;
        return consistent;
    }

    @Override
    public boolean runAfterAssignment(Variable x) {
        if (!this.cp().propagating.strongOnlyAtPreprocessing) {
            Boolean result = this.filterFromAdjacences();
            if (result == Boolean.FALSE) {
                return false;
            }
            return super.runAfterAssignment(x);
        }
        return super.runAfterAssignment(x);
    }

    @Override
    public boolean runAfterRefutation(Variable x) {
        return super.runAfterRefutation(x);
    }

    private class NeighborhoodReasoning {
        private Neighbors[] patternsNeighbors;
        private Neighbors[] targetsNeighbors;
        private int nFixedPatternNeighbors;

        private NeighborhoodReasoning(int[][] patternNeighborSelection, int[][] targetNeighborSelection) {
            int i;
            Kit.control(patternNeighborSelection.length == ((PropagationIsomorphism)PropagationIsomorphism.this).initialPatternGraph.nNodes && targetNeighborSelection.length == ((PropagationIsomorphism)PropagationIsomorphism.this).initialTargetGraph.nNodes);
            this.patternsNeighbors = new Neighbors[patternNeighborSelection.length];
            for (i = 0; i < this.patternsNeighbors.length; ++i) {
                this.patternsNeighbors[i] = new Neighbors(patternNeighborSelection[i]);
            }
            this.targetsNeighbors = new Neighbors[targetNeighborSelection.length];
            for (i = 0; i < this.targetsNeighbors.length; ++i) {
                this.targetsNeighbors[i] = new Neighbors(targetNeighborSelection[i]);
            }
        }

        private void reconsiderTargetNodes(int[][] targetNeighborSelection) {
            for (int i = 0; i < this.targetsNeighbors.length; ++i) {
                this.targetsNeighbors[i] = new Neighbors(targetNeighborSelection[i]);
            }
        }

        private void recordScores(long[][] patternAdjacence, long[][] targetAdjacence) {
            int i;
            for (i = 0; i < this.patternsNeighbors.length; ++i) {
                this.patternsNeighbors[i].recordAndSort(patternAdjacence[i]);
            }
            for (i = 0; i < this.targetsNeighbors.length; ++i) {
                this.targetsNeighbors[i].recordAndSort(targetAdjacence[i]);
            }
        }

        private boolean fix(int k, int v) {
            int n = v;
            ((PropagationIsomorphism)PropagationIsomorphism.this).last[k] = n;
            ((PropagationIsomorphism)PropagationIsomorphism.this).first[k] = n;
            ((PropagationIsomorphism)PropagationIsomorphism.this).fixed[v] = k;
            ((PropagationIsomorphism)PropagationIsomorphism.this).fixedPatternNeighbors[this.nFixedPatternNeighbors++] = k;
            return true;
        }

        private boolean isNeighborDominated(int i, int j) {
            int k;
            boolean newFixed;
            int k2;
            int nbTargetNeighbors;
            Kit.IntLongPairReverse[] patternScores = this.patternsNeighbors[i].nodes;
            Kit.IntLongPairReverse[] targetScores = this.targetsNeighbors[j].nodes;
            int nPatternNeighbors = this.patternsNeighbors[i].nodes.length;
            if (nPatternNeighbors > (nbTargetNeighbors = this.targetsNeighbors[j].nodes.length)) {
                return false;
            }
            for (k2 = 0; k2 < nPatternNeighbors; ++k2) {
                if (patternScores[k2].value <= targetScores[k2].value) continue;
                return false;
            }
            Arrays.fill(PropagationIsomorphism.this.fixed, 0, nbTargetNeighbors, -1);
            Arrays.fill(PropagationIsomorphism.this.nbLasts, 0, nbTargetNeighbors, 0);
            this.nFixedPatternNeighbors = 0;
            for (k2 = 0; k2 < nPatternNeighbors; ++k2) {
                ((PropagationIsomorphism)PropagationIsomorphism.this).first[k2] = this.targetsNeighbors[j].findDominanceSupportFor(patternScores[k2], 0, nbTargetNeighbors, true);
                if (PropagationIsomorphism.this.first[k2] == -1) {
                    return false;
                }
                ((PropagationIsomorphism)PropagationIsomorphism.this).last[k2] = this.targetsNeighbors[j].findDominanceSupportFor(patternScores[k2], nbTargetNeighbors - 1, PropagationIsomorphism.this.first[k2], false);
                if (PropagationIsomorphism.this.last[k2] == -1) {
                    this.fix(k2, PropagationIsomorphism.this.first[k2]);
                }
                int[] nArray = PropagationIsomorphism.this.nbLasts;
                int n = PropagationIsomorphism.this.last[k2];
                nArray[n] = nArray[n] + 1;
            }
            do {
                newFixed = false;
                for (k = 0; k < nPatternNeighbors; ++k) {
                    if (PropagationIsomorphism.this.first[k] == PropagationIsomorphism.this.last[k]) continue;
                    int fixedLast = PropagationIsomorphism.this.fixed[PropagationIsomorphism.this.last[k]];
                    if (PropagationIsomorphism.this.fixed[PropagationIsomorphism.this.first[k]] != -1) {
                        ((PropagationIsomorphism)PropagationIsomorphism.this).first[k] = this.targetsNeighbors[j].findDominanceSupportFor(patternScores[k], PropagationIsomorphism.this.first[k] + 1, PropagationIsomorphism.this.last[k], true);
                        if (PropagationIsomorphism.this.first[k] == -1) {
                            if (fixedLast != -1) {
                                return false;
                            }
                            newFixed = this.fix(k, PropagationIsomorphism.this.last[k]);
                        }
                    }
                    if (fixedLast == -1) continue;
                    int[] nArray = PropagationIsomorphism.this.nbLasts;
                    int n = PropagationIsomorphism.this.last[k];
                    nArray[n] = nArray[n] - 1;
                    ((PropagationIsomorphism)PropagationIsomorphism.this).last[k] = this.targetsNeighbors[j].findDominanceSupportFor(patternScores[k], PropagationIsomorphism.this.last[k] - 1, PropagationIsomorphism.this.first[k], false);
                    if (PropagationIsomorphism.this.last[k] == -1) {
                        newFixed = this.fix(k, PropagationIsomorphism.this.first[k]);
                    }
                    int[] nArray2 = PropagationIsomorphism.this.nbLasts;
                    int n2 = PropagationIsomorphism.this.last[k];
                    nArray2[n2] = nArray2[n2] + 1;
                }
            } while (newFixed);
            int sum = 0;
            for (k = 0; k < nPatternNeighbors; ++k) {
                if ((sum += PropagationIsomorphism.this.nbLasts[k]) <= k + 1) continue;
                return false;
            }
            boolean test = true;
            if (test) {
                for (int cnt1 = 0; cnt1 < this.nFixedPatternNeighbors; ++cnt1) {
                    for (int cnt2 = cnt1 + 1; cnt2 < this.nFixedPatternNeighbors; ++cnt2) {
                        int jjj;
                        int jj;
                        int k1 = PropagationIsomorphism.this.fixedPatternNeighbors[cnt1];
                        int k22 = PropagationIsomorphism.this.fixedPatternNeighbors[cnt2];
                        int ii = patternScores[k1].index;
                        int iii = patternScores[k22].index;
                        if (((PropagationIsomorphism)PropagationIsomorphism.this).initialPatternGraph.adjacency[ii][iii] == 0L || ((PropagationIsomorphism)PropagationIsomorphism.this).initialTargetGraph.adjacency[jj = targetScores[((PropagationIsomorphism)PropagationIsomorphism.this).last[k1]].index][jjj = targetScores[((PropagationIsomorphism)PropagationIsomorphism.this).last[k22]].index] != 0L) continue;
                        return false;
                    }
                }
            }
            return true;
        }

        private class Neighbors {
            private Kit.IntLongPairReverse[] nodes;

            private Neighbors(int[] indices) {
                this.nodes = (Kit.IntLongPairReverse[])IntStream.range(0, indices.length).mapToObj(i -> new Kit.IntLongPairReverse(indices[i])).toArray(Kit.IntLongPairReverse[]::new);
            }

            private void recordAndSort(long[] adjacentScores) {
                for (Kit.IntLongPairReverse node : this.nodes) {
                    node.value = adjacentScores[node.index];
                }
                Arrays.sort(this.nodes);
            }

            private int findDominanceSupportFor(Kit.IntLongPairReverse node, int from, int to, boolean first) {
                if (first) {
                    for (int i = from; i < to; ++i) {
                        if (node.value > this.nodes[i].value) {
                            return -1;
                        }
                        if (PropagationIsomorphism.this.fixed[i] != -1 || !PropagationIsomorphism.this.domains[node.index].isPresent(this.nodes[i].index)) continue;
                        return i;
                    }
                } else {
                    for (int i = from; i > to; --i) {
                        if (node.value > this.nodes[i].value || PropagationIsomorphism.this.fixed[i] != -1 || !PropagationIsomorphism.this.domains[node.index].isPresent(this.nodes[i].index)) continue;
                        return i;
                    }
                }
                return -1;
            }
        }
    }
}

