/*
 * Decompiled with CFR 0.152.
 */
package propagation.order1.inverse;

import constraints.Constraint;
import constraints.hard.extension.CtrExtensionSTR1;
import constraints.hard.extension.CtrExtensionSTR2;
import constraints.hard.extension.structures.Table;
import java.util.stream.Stream;
import org.xcsp.common.enumerations.EnumerationCartesian;
import propagation.order1.inverse.GIC1;
import search.Solver;
import utility.Enums;
import utility.Kit;
import utility.sets.SetDenseReversible;
import variables.Variable;

public class TIC1
extends GIC1 {
    public TIC1(Solver solver) {
        super(solver);
        Kit.control(solver.rs.cp.experimental.testI1 > 0 || Stream.of(solver.pb.constraints).allMatch(c -> c.getClass().isAssignableFrom(CtrExtensionSTR2.class)));
    }

    protected boolean isInverse(Variable[] scope, int[] tuple) {
        this.solver.resetNoSolutions();
        boolean consistent = true;
        Kit.control(this.solver.futVars.nDiscarded() == 0, () -> " BnbPast=" + this.solver.futVars.nDiscarded());
        int nVariablesAssignedBefore = this.solver.futVars.nDiscarded();
        for (int i = 0; consistent && i < scope.length; ++i) {
            if (scope[i].dom.isPresent(tuple[i])) {
                this.solver.assign(scope[i], tuple[i]);
                consistent = consistent && this.enforceArcConsistencyAfterAssignment(scope[i]);
                continue;
            }
            consistent = false;
        }
        boolean inverse = consistent && this.solver.doRun().stoppingType == Enums.EStopping.REACHED_GOAL;
        for (int j = this.solver.futVars.nDiscarded() - nVariablesAssignedBefore - 1; j >= 0; --j) {
            this.solver.backtrack(scope[j]);
        }
        Kit.control(this.solver.futVars.nDiscarded() == 0, () -> " AnbPast=" + this.solver.futVars.nDiscarded());
        return inverse;
    }

    private int filterConstraint(Constraint ctr) {
        int cnt = 0;
        Kit.log.info("Filter tuples from " + ctr);
        int[][] tuples = ((Table)ctr.extStructure()).tuples;
        SetDenseReversible denseSetOfTuples = ((CtrExtensionSTR1)ctr).set;
        int[] dense = denseSetOfTuples.dense;
        for (int i = denseSetOfTuples.limit; i >= 0; --i) {
            denseSetOfTuples.swapAtPositions(0, i);
            int prevLimit = denseSetOfTuples.limit;
            denseSetOfTuples.limit = 0;
            boolean inverse = this.isInverse(ctr.scp, tuples[dense[0]]);
            denseSetOfTuples.swapAtPositions(0, i);
            denseSetOfTuples.limit = prevLimit;
            if (inverse) continue;
            ++cnt;
            denseSetOfTuples.removeAtPosition(i, this.solver.depth());
        }
        if (cnt > 0) {
            Kit.log.info(cnt + " tuples removed from " + ctr);
        }
        Kit.control(denseSetOfTuples.size() > 0, () -> "Impossible because the CN is GIC");
        return cnt;
    }

    @Override
    public boolean enforceStrongConsistency() {
        if (this.solver.rs.cp.experimental.testI1 > 0) {
            this.performingProperSearch = true;
            Variable[] vars = new Variable[this.solver.rs.cp.experimental.testI1];
            int[] t = Kit.range(this.solver.pb.variables.length);
            for (int i = 0; i < vars.length; ++i) {
                int id = this.solver.rs.random.nextInt(t.length - i);
                vars[i] = this.solver.pb.variables[id];
                t[id] = t[t.length - 1 - i];
            }
            Kit.control(Variable.areAllDistinct(vars));
            EnumerationCartesian ec = new EnumerationCartesian(Variable.domSizeArrayOf(vars, true));
            ec.reset();
            int cnt = 0;
            while (ec.hasNext()) {
                if (this.isInverse(vars, ec.next())) continue;
                ++cnt;
            }
            Kit.log.info(cnt + " tuples removed from " + Kit.join((Object)vars, new String[0]));
            this.performingProperSearch = false;
            this.cp().solving.enableSearch = false;
            return true;
        }
        boolean consistent = super.enforceStrongConsistency();
        Kit.control(consistent);
        if (this.solver.depth() > 0) {
            return true;
        }
        this.performingProperSearch = true;
        int nbTuplesRemoved = 0;
        for (Constraint ctr : this.solver.pb.constraints) {
            nbTuplesRemoved += this.filterConstraint(ctr);
        }
        if (this.cp().verbose >= 1 && nbTuplesRemoved > 0) {
            Kit.log.info("nbTICInconsistentTuples=" + nbTuplesRemoved + " at depth=" + this.solver.depth() + "\n");
        }
        this.solver.resetNoSolutions();
        this.performingProperSearch = false;
        return true;
    }
}

