/*
 * Decompiled with CFR 0.152.
 */
package propagation.order1.inverse;

import constraints.Constraint;
import constraints.hard.extension.CtrExtensionSTR1;
import constraints.hard.extension.CtrExtensionSTR3;
import heuristics.variables.HeuristicVariables;
import heuristics.variables.dynamic.WDegOnDom;
import java.util.stream.Stream;
import propagation.order1.StrongConsistency;
import search.Solver;
import search.backtrack.SolverBacktrack;
import utility.Enums;
import utility.Kit;
import variables.Variable;
import variables.domains.Domain;

public class GIC1
extends StrongConsistency {
    protected HeuristicVariables variableHeuristicForInverse;
    public int[] nInverseTests;
    public int nITests;
    private long baseNbSolutionsLimit;

    public GIC1(Solver solver) {
        super(solver);
        Kit.control(this.cp().restarting.cutoff == Long.MAX_VALUE, () -> "With Inverse, there is currently no possibility of restarts.");
        Kit.control(!Stream.of(solver.pb.constraints).anyMatch(c -> c.getClass().isAssignableFrom(CtrExtensionSTR3.class)), () -> "Inverse currently not compatible with STR3");
        this.variableHeuristicForInverse = new WDegOnDom((SolverBacktrack)solver, false);
        this.nInverseTests = new int[solver.pb.variables.length + 1];
        this.baseNbSolutionsLimit = solver.solManager.nSolutionsLimit;
    }

    protected void handleNewSolution(Variable x, int a) {
    }

    protected boolean isInverse(Variable x, int a) {
        int n = this.solver.depth();
        this.nInverseTests[n] = this.nInverseTests[n] + 1;
        ++this.nITests;
        this.solver.resetNoSolutions();
        this.solver.assign(x, a);
        HeuristicVariables h = ((SolverBacktrack)this.solver).heuristicVars;
        ((SolverBacktrack)this.solver).heuristicVars = this.variableHeuristicForInverse;
        this.solver.solManager.nSolutionsLimit = 1L;
        boolean inverse = this.enforceArcConsistencyAfterAssignment(x) && this.solver.doRun().stoppingType == Enums.EStopping.REACHED_GOAL;
        this.solver.solManager.nSolutionsLimit = this.baseNbSolutionsLimit;
        ((SolverBacktrack)this.solver).heuristicVars = h;
        if (inverse) {
            this.handleNewSolution(x, a);
        } else {
            Kit.log.info(x + "=" + a + " is not inverse");
        }
        this.solver.backtrack(x);
        return inverse;
    }

    protected void updateSTRStructures() {
        for (Constraint c : this.solver.pb.constraints) {
            if (!(c instanceof CtrExtensionSTR1)) continue;
            int bef = this.solver.pb.nValuesRemoved;
            ((CtrExtensionSTR1)c).runPropagator(null);
            Kit.control(this.solver.pb.nValuesRemoved == bef);
        }
    }

    protected long before() {
        this.performingProperSearch = true;
        return this.solver.solManager.nSolutionsFound;
    }

    protected void after(long nSolutionsBefore, int nValuesRemoved) {
        if (this.cp().verbose >= 1) {
            Kit.log.info("nbGICInconsistentValues=" + nValuesRemoved + " at depth=" + this.solver.depth() + " for " + this.nInverseTests[this.solver.depth()] + " tests");
        }
        this.solver.resetNoSolutions();
        this.solver.solManager.nSolutionsFound = nSolutionsBefore;
        this.updateSTRStructures();
        this.performingProperSearch = false;
    }

    @Override
    public boolean enforceStrongConsistency() {
        long nSolutionsBefore = this.before();
        int nValuesRemoved = 0;
        Variable x = this.solver.futVars.first();
        while (x != null) {
            Domain dom = x.dom;
            int a = dom.first();
            while (a != -1) {
                if (!this.isInverse(x, a)) {
                    x.dom.removeElementary(a);
                    ++nValuesRemoved;
                }
                a = dom.next(a);
            }
            Kit.control(dom.size() != 0, () -> "Not possible to reach inconsistency with GIC (or your instance is unsat)");
            x = this.solver.futVars.next(x);
        }
        this.after(nSolutionsBefore, nValuesRemoved);
        return true;
    }
}

