/*
 * Decompiled with CFR 0.152.
 */
package propagation.order1;

import propagation.order1.AC;
import search.Solver;
import utility.observers.ObserverTwoPhases;
import variables.Variable;

public abstract class StrongConsistency
extends AC {
    protected int nPassesLimit = Integer.MAX_VALUE;
    protected boolean onlyBounds;
    protected boolean onlyNeighbours;

    public StrongConsistency(Solver solver) {
        super(solver);
    }

    protected abstract boolean enforceStrongConsistency();

    protected boolean enforceMore() {
        this.solver.stats.store();
        boolean consistent = this.enforceStrongConsistency();
        this.solver.stats.restore();
        return consistent;
    }

    @Override
    public boolean runInitially() {
        int nBefore = this.pb().nValuesRemoved;
        if (!this.enforceArcConsistency()) {
            return false;
        }
        for (ObserverTwoPhases observer : this.solver.observersTwoPhases) {
            observer.switchToSecondPhase();
        }
        return this.cp().propagating.strongOnlyWhenACEffective && this.pb().nValuesRemoved == nBefore ? true : this.enforceMore();
    }

    @Override
    public boolean runAfterAssignment(Variable x) {
        int nBefore = this.pb().nValuesRemoved;
        if (!this.enforceArcConsistencyAfterAssignment(x)) {
            return false;
        }
        return this.performingProperSearch || this.cp().propagating.strongOnlyAtPreprocessing || this.cp().propagating.strongOnlyWhenACEffective && this.pb().nValuesRemoved == nBefore || this.cp().propagating.strongOnlyWhenNotSingleton && !x.dom.isModifiedAtCurrentDepth() && this.hasSolverPropagatedAfterLastButOneDecision() ? true : this.enforceMore();
    }

    @Override
    public boolean runAfterRefutation(Variable x) {
        int nBefore = this.pb().nValuesRemoved;
        if (!this.enforceArcConsistencyAfterRefutation(x)) {
            return false;
        }
        return this.performingProperSearch || this.cp().propagating.strongOnlyAtPreprocessing || this.cp().propagating.strongOnlyWhenACEffective && this.pb().nValuesRemoved == nBefore ? true : this.enforceMore();
    }
}

