/*
 * Decompiled with CFR 0.152.
 */
package propagation;

import constraints.Constraint;
import constraints.CtrHard;
import java.util.ArrayList;
import java.util.List;
import problem.Problem;
import propagation.PropagationQueue;
import propagation.order1.PropagationForward;
import search.Solver;
import utility.Kit;
import variables.Variable;
import variables.domains.Domain;

public final class Substitutabiliter {
    protected Solver solver;
    private PropagationQueue queue;

    public Substitutabiliter(Solver solver) {
        this.solver = solver;
        this.queue = new PropagationQueue((PropagationForward)solver.propagation);
        Kit.control(solver.propagation.softs.length == 0);
    }

    public boolean isSubstitutableBy(CtrHard c, Variable x, int a, int b) {
        int p = c.positionOf(x);
        c.tupleManager.firstValidTupleWith(p, a);
        return !c.tupleManager.findValidTupleSuchThat(t -> {
            if (!c.checkIndexes((int[])t)) {
                return false;
            }
            t[p] = b;
            if (!c.checkIndexes((int[])t)) {
                return true;
            }
            t[p] = a;
            return false;
        });
    }

    public boolean isSubstitutableBy(Variable x, int a, int b) {
        for (Constraint c : x.ctrs) {
            if (this.isSubstitutableBy((CtrHard)c, x, a, b)) continue;
            return false;
        }
        return true;
    }

    public boolean isSubstitutable(Variable x, int a) {
        Domain dom = x.dom;
        int b = dom.first();
        while (b != -1) {
            if (b != a && this.isSubstitutableBy(x, a, b)) {
                return true;
            }
            b = dom.next(b);
        }
        return false;
    }

    public int removeSubstitutableValuesOf(Variable x) {
        Domain dom = x.dom;
        int sizeBefore = dom.size();
        int a = dom.first();
        while (a != -1) {
            if (this.isSubstitutable(x, a)) {
                x.dom.removeElementary(a);
            }
            a = dom.next(a);
        }
        int nbRemovals = sizeBefore - dom.size();
        if (nbRemovals > 0) {
            Kit.log.info(" => " + nbRemovals + " removals from " + x + " at level " + x.pb.solver.depth());
        }
        return nbRemovals;
    }

    private void addFutureVariablesThatAreNeighboursOf(Variable x) {
        Variable[] neighbours = x.getNeighbours();
        if (neighbours != null && neighbours.length <= this.solver.futVars.size()) {
            for (Variable y2 : neighbours) {
                if (y2.isAssigned()) continue;
                this.queue.add(y2);
            }
        } else {
            this.solver.futVars.execute(y -> {
                if (x != y && x.isNeighbourOf((Variable)y)) {
                    this.queue.add((Variable)y);
                }
            });
        }
    }

    public final void removeSubstitutableValues() {
        this.queue.clear();
        this.solver.futVars.execute(x -> {
            if (this.removeSubstitutableValuesOf((Variable)x) > 0) {
                this.addFutureVariablesThatAreNeighboursOf((Variable)x);
            }
        });
        while (this.queue.size() > 0) {
            Variable x2 = this.queue.pickAndDelete(0);
            if (this.removeSubstitutableValuesOf(x2) <= 0) continue;
            this.addFutureVariablesThatAreNeighboursOf(x2);
        }
    }

    public int computeNbSubstitutableValuesOf(Variable x) {
        Domain dom = x.dom;
        int cnt = 0;
        int a = dom.first();
        while (a != -1) {
            int b = dom.first();
            while (b != -1) {
                if (b != a && this.isSubstitutableBy(x, a, b)) {
                    ++cnt;
                }
                b = dom.next(b);
            }
            a = dom.next(a);
        }
        return cnt;
    }

    public double computeSubstitutabilityRatioOf(Problem problem) {
        double globalRatio = 0.0;
        for (Constraint c : problem.constraints) {
            double ratio = 0.0;
            for (Variable x : c.scp) {
                long size = this.computeNbSubstitutableValuesOf(x);
                ratio += (double)size / ((double)(x.dom.size() * x.dom.size()) - (double)x.dom.size());
            }
            globalRatio += ratio / (double)c.scp.length;
        }
        return globalRatio / (double)problem.constraints.length;
    }

    public List<int[]> computeSubstitutabilityRelationOf(Variable x) {
        ArrayList<int[]> list = new ArrayList<int[]>();
        Domain dom = x.dom;
        int a = dom.first();
        while (a != -1) {
            int b = dom.first();
            while (b != -1) {
                if (b != a && this.isSubstitutableBy(x, a, b)) {
                    list.add(new int[]{a, b});
                }
                b = dom.next(b);
            }
            a = dom.next(a);
        }
        return list;
    }
}

