/*
 * Decompiled with CFR 0.152.
 */
package problems.xcsp3;

import constraints.hard.global.BinPackingSimple;
import constraints.hard.primitive.CtrFalse;
import constraints.hard.primitive.EQ;
import constraints.hard.primitive.GE;
import constraints.hard.primitive.GT;
import constraints.hard.primitive.LE;
import constraints.hard.primitive.LT;
import constraints.hard.primitive.NE;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Condition;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.domains.Domains;
import org.xcsp.common.predicates.MatcherInterface;
import org.xcsp.common.predicates.XNode;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.common.structures.Automaton;
import org.xcsp.common.structures.Transition;
import org.xcsp.modeler.entities.CtrEntities;
import org.xcsp.modeler.entities.ModelingEntity;
import org.xcsp.parser.callbacks.XCallbacks;
import org.xcsp.parser.callbacks.XCallbacks2;
import org.xcsp.parser.entries.ParsingEntry;
import org.xcsp.parser.entries.XConstraints;
import org.xcsp.parser.entries.XObjectives;
import org.xcsp.parser.entries.XVariables;
import problem.Problem;
import problems.ProblemFile;
import utility.Kit;
import utility.exceptions.UnreachableCodeException;
import variables.Variable;
import variables.VariableInteger;
import variables.VariableSymbolic;

public class XCSP3
extends ProblemFile
implements XCallbacks2 {
    private XCallbacks.Implem implem = new XCallbacks.Implem((XCallbacks)this);
    private Map<XVariables.XVar, Variable> mapVar = new LinkedHashMap<XVariables.XVar, Variable>();
    private static final String TEXT_PRIMITIVES = "Primitive in class XCSP3 : ";

    public XCallbacks.Implem implem() {
        return this.implem;
    }

    @Override
    protected String[] defineSuffixFilters() {
        return (String[])Stream.of(".xml", ".bz2", ".lzma").toArray(String[]::new);
    }

    public void model() {
        try {
            if (this.imp().rs.cp.export) {
                this.implem.rawParameters();
            }
            Kit.log.info("Discarded classes " + this.imp().rs.cp.xml.discardedClasses);
            if (this.imp().rs.cp.xml.discardedClasses.indexOf(44) < 0) {
                this.loadInstance(this.currFileName(), new String[]{this.imp().rs.cp.xml.discardedClasses});
            } else {
                this.loadInstance(this.currFileName(), this.imp().rs.cp.xml.discardedClasses.split(","));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Problem when parsing the instance. Fix the problem.");
            System.exit(1);
        }
    }

    public Problem imp() {
        return (Problem)api2imp.get(this);
    }

    public void beginInstance(Types.TypeFramework type) {
        if (type == Types.TypeFramework.COP) {
            this.imp().rs.cp.framework = Types.TypeFramework.COP;
            this.imp().rs.cp.general.nSearchedSolutions = Long.MAX_VALUE;
            this.imp().framework = Types.TypeFramework.COP;
        }
    }

    private void copyBasicAttributes(ModelingEntity entity, ParsingEntry entry) {
        if (entry.id != null) {
            entity.id(entry.id);
        }
        if (entry.note != null) {
            entity.note(entry.note);
        }
        if (entry.classes != null) {
            entity.tag(entry.classes);
        }
    }

    private VariableInteger trVar(IVar x) {
        return (VariableInteger)this.mapVar.get(x);
    }

    private VariableInteger trVar(XVariables.XVarInteger x) {
        return (VariableInteger)this.mapVar.get(x);
    }

    private VariableSymbolic trVar(XVariables.XVarSymbolic x) {
        return (VariableSymbolic)this.mapVar.get(x);
    }

    private VariableInteger[] trVars(XVariables.XVarInteger[] t) {
        return (VariableInteger[])Arrays.stream(t).map(v -> this.mapVar.get(v)).toArray(VariableInteger[]::new);
    }

    private VariableInteger[][] trVars2D(XVariables.XVarInteger[][] m) {
        return (VariableInteger[][])Arrays.stream(m).map(t -> this.trVars((XVariables.XVarInteger[])t)).toArray(x$0 -> new VariableInteger[x$0][]);
    }

    private VariableSymbolic[] trVars(XVariables.XVarSymbolic[] t) {
        return (VariableSymbolic[])Arrays.stream(t).map(v -> this.mapVar.get(v)).toArray(VariableSymbolic[]::new);
    }

    public void loadVar(XVariables.XVar v) {
        this.implem().manageIdFor((ParsingEntry)v);
        if (v.degree > 0) {
            if (v.dom instanceof Domains.Dom) {
                this.mapVar.put(v, (VariableInteger)this.var(v.id, (Domains.Dom)v.dom, v.note, v.classes));
            } else if (v.dom instanceof Domains.DomSymbolic) {
                this.mapVar.put(v, (VariableSymbolic)this.var(v.id, (Domains.DomSymbolic)v.dom, v.note, v.classes));
            } else {
                Kit.exit("unimplemented case for loadVAr");
            }
        }
    }

    private void completeMapVar(XVariables.XArray va, Object a, int ... indexes) {
        if (a != null) {
            if (a.getClass().isArray()) {
                IntStream.range(0, Array.getLength(a)).forEach(i -> this.completeMapVar(va, Array.get(a, i), this.vals(new Object[]{indexes, i})));
            } else {
                this.mapVar.put(va.varAt(indexes), (Variable)a);
            }
        }
    }

    public void loadArray(XVariables.XArray va) {
        this.implem().manageIdFor((ParsingEntry)va);
        IVar.Var[] a = null;
        int[] sz = va.size;
        if (va.getType() == Types.TypeVar.integer) {
            if (sz.length == 1) {
                a = this.array(va.id, this.size(sz[0]), i -> va.domAt(new int[]{i}), va.note, va.classes);
            } else if (sz.length == 2) {
                a = this.array(va.id, this.size(sz[0], sz[1]), (i, j) -> va.domAt(new int[]{i, j}), va.note, va.classes);
            } else if (sz.length == 3) {
                a = this.array(va.id, this.size(sz[0], sz[1], sz[2]), (i, j, k) -> va.domAt(new int[]{i, j, k}), va.note, va.classes);
            } else if (sz.length == 4) {
                a = this.array(va.id, this.size(sz[0], sz[1], sz[2], sz[3]), (i, j, k, l) -> va.domAt(new int[]{i, j, k, l}), va.note, va.classes);
            } else if (sz.length == 5) {
                a = this.array(va.id, this.size(sz[0], sz[1], sz[2], sz[3], sz[4]), (i, j, k, l, m) -> va.domAt(new int[]{i, j, k, l, m}), va.note, va.classes);
            } else {
                Kit.exit("unimplemented case for array");
            }
        } else if (va.getType() == Types.TypeVar.symbolic) {
            if (sz.length == 1) {
                a = this.arraySymbolic(va.id, this.size(sz[0]), i -> va.varAt(new int[]{i}) != null && va.varAt((int[])new int[]{i}).degree > 0 ? (Domains.DomSymbolic)va.varAt((int[])new int[]{i}).dom : null, va.note, va.classes);
            } else {
                Kit.exit("unimplemented case for array");
            }
        } else {
            Kit.exit("unimplemented case for array");
        }
        this.completeMapVar(va, a, new int[0]);
    }

    public void buildVarInteger(XVariables.XVarInteger x, int minValue, int maxValue) {
        throw new UnreachableCodeException();
    }

    public void buildVarInteger(XVariables.XVarInteger x, int[] values) {
        throw new UnreachableCodeException();
    }

    public void buildVarSymbolic(XVariables.XVarSymbolic x, String[] values) {
        throw new UnreachableCodeException();
    }

    public void loadBlock(XConstraints.XBlock block) {
        CtrEntities.CtrArray entity = this.block(() -> this.loadConstraints(block.subentries));
        this.copyBasicAttributes((ModelingEntity)entity, (ParsingEntry)block);
    }

    public void loadGroup(XConstraints.XGroup group) {
        CtrEntities.CtrArray entity = this.imp().manageLoop(() -> {
            if (group.template instanceof XConstraints.XCtr) {
                this.loadCtrs((XConstraints.XCtr)group.template, group.argss, (ParsingEntry.CEntry)group);
            } else if (group.template instanceof XConstraints.XLogic && ((XConstraints.XLogic)group.template).getType() == Types.TypeCtr.not) {
                XConstraints.CEntryReifiable child = ((XConstraints.XLogic)group.template).components[0];
                if (child instanceof XConstraints.XCtr && ((XConstraints.XCtr)child).type == Types.TypeCtr.allEqual) {
                    Stream.of(group.argss).forEach(o -> this.notAllEqual(this.trVars((XVariables.XVarInteger[])o)));
                } else {
                    Kit.exit("unimplemented case");
                }
            } else {
                Kit.exit("unimplemented case");
            }
        });
        if (entity != null) {
            this.copyBasicAttributes((ModelingEntity)entity, (ParsingEntry)group);
        }
    }

    public void loadSlide(XConstraints.XSlide s) {
        CtrEntities.CtrArray entity = this.imp().manageLoop(() -> super.loadSlide(s));
        this.copyBasicAttributes((ModelingEntity)entity, (ParsingEntry)s);
    }

    public void beginLogic(XConstraints.XLogic l) {
        System.out.println("Begin : " + l);
    }

    public void endLogic(XConstraints.XLogic l) {
        System.out.println("End : " + l);
    }

    public void loadCtr(XConstraints.XCtr c) {
        if (this.imp().stuff.mustDiscard((IVar[])c.vars())) {
            return;
        }
        if (this.imp().rs.cp.constraints.ignoredCtrType == c.type) {
            ++this.imp().stuff.nDiscardedCtrs;
            return;
        }
        if (this.imp().rs.cp.constraints.ignoreCtrArity == c.vars().length) {
            ++this.imp().stuff.nDiscardedCtrs;
            return;
        }
        int sizeBefore = this.imp().ctrEntities.allEntities.size();
        super.loadCtr(c);
        if (sizeBefore == this.imp().ctrEntities.allEntities.size()) {
            return;
        }
        CtrEntities.CtrEntity entity = (CtrEntities.CtrEntity)this.imp().ctrEntities.allEntities.get(this.imp().ctrEntities.allEntities.size() - 1);
        this.copyBasicAttributes((ModelingEntity)entity, (ParsingEntry)c);
    }

    public void buildCtrFalse(String id, XVariables.XVar[] list) {
        if (this.imp().framework != Types.TypeFramework.MAXCSP) {
            throw new RuntimeException("Constraint with only conflicts");
        }
        this.imp().addCtr(new CtrFalse(this.imp(), this.trVars((XVariables.XVarInteger[])Stream.of(list).map(x -> (XVariables.XVarInteger)x).toArray(XVariables.XVarInteger[]::new))), new Types.TypeClass[0]);
    }

    public CtrEntities.CtrEntity intension(XNodeParent<IVar> tree) {
        XNodeParent validTree = (XNodeParent)tree.replaceLeafValues(v -> v instanceof XVariables.XVarInteger ? this.trVar((XVariables.XVarInteger)v) : (v instanceof XVariables.XVarSymbolic ? this.trVar((XVariables.XVarSymbolic)v) : v));
        return this.imp().intension((XNodeParent<IVar>)validTree);
    }

    public void buildCtrIntension(String id, XVariables.XVarInteger[] scope, XNodeParent<XVariables.XVarInteger> tree) {
        Utilities.control((boolean)tree.exactlyVars((IVar[])scope), (String)"Pb with scope");
        this.intension(tree);
    }

    public void buildCtrPrimitive(String id, XVariables.XVarInteger x, Types.TypeConditionOperatorRel op, int k) {
        if (this.imp().rs.cp.xml.displayPrimitives) {
            System.out.println(TEXT_PRIMITIVES + x + " " + op + " " + k);
        }
        this.intension((XNodeParent<IVar>)(op == LT ? this.lt(this.trVar(x), k) : (op == LE ? this.le(this.trVar(x), k) : (op == GE ? this.ge(this.trVar(x), k) : (op == GT ? this.gt(this.trVar(x), k) : (op == EQ ? this.eq(new Object[]{this.trVar(x), k}) : this.ne(new Object[]{this.trVar(x), k})))))));
    }

    public void buildCtrPrimitive(String id, XVariables.XVarInteger x, Types.TypeConditionOperatorSet op, int[] t) {
        if (this.imp().rs.cp.xml.displayPrimitives) {
            System.out.println(TEXT_PRIMITIVES + x + " " + op + " " + Kit.join((Object)t, new String[0]));
        }
        this.intension((XNodeParent<IVar>)(op == IN ? this.in(this.trVar(x), this.set(t)) : this.notin(this.trVar(x), this.set(t))));
    }

    public void buildCtrPrimitive(String id, XVariables.XVarInteger x, Types.TypeConditionOperatorSet op, int min, int max) {
        if (this.imp().rs.cp.xml.displayPrimitives) {
            System.out.println(TEXT_PRIMITIVES + x + " " + op + " " + min + ".." + max);
        }
        this.intension((XNodeParent<IVar>)(op == IN ? this.and(new Object[]{this.ge(this.trVar(x), min), this.le(this.trVar(x), max)}) : this.or(new Object[]{this.lt(this.trVar(x), min), this.gt(this.trVar(x), max)})));
    }

    public void buildCtrPrimitive(String id, XVariables.XVarInteger x, Types.TypeArithmeticOperator aop, int k1, Types.TypeConditionOperatorRel op, int k2) {
        if (this.imp().rs.cp.xml.displayPrimitives) {
            System.out.println("Primitive in class XCSP3 : (" + x + " " + aop + " " + k1 + ") " + op + " " + k2 + " (reposted)");
        }
        this.repost(id);
    }

    public void buildCtrPrimitive(String id, XVariables.XVarInteger x, Types.TypeUnaryArithmeticOperator aop, XVariables.XVarInteger y) {
        if (this.imp().rs.cp.xml.displayPrimitives) {
            System.out.println(TEXT_PRIMITIVES + x + " " + aop + " " + y + " (reposted)");
        }
        this.repost(id);
    }

    private CtrEntities.CtrAlone primitive(Variable x, Types.TypeConditionOperatorRel op, Variable y, int k) {
        return this.imp().addCtr(op == LT ? new LT(this.imp(), x, -k, y) : (op == LE ? new LE(this.imp(), x, -k, y) : (op == GE ? new GE(this.imp(), x, -k, y) : (op == GT ? new GT(this.imp(), x, -k, y) : (op == EQ ? new EQ(this.imp(), x, -k, y) : new NE(this.imp(), x, -k, y))))), new Types.TypeClass[0]);
    }

    public void buildCtrPrimitive(String id, XVariables.XVarInteger x, Types.TypeArithmeticOperator aop, XVariables.XVarInteger y, Types.TypeConditionOperatorRel op, int k) {
        if (aop == Types.TypeArithmeticOperator.SUB) {
            if (this.imp().rs.cp.xml.displayPrimitives) {
                System.out.println("Primitive in class XCSP3 : (" + x + " " + aop + " " + y + ") " + op + " " + k);
            }
            this.primitive(this.trVar(x), Types.TypeConditionOperatorRel.valueOf((String)op.name()), this.trVar(y), k);
        } else {
            if (this.imp().rs.cp.xml.displayPrimitives) {
                System.out.println("Primitive in class XCSP3 : (" + x + " " + aop + " " + y + ") " + op + " " + k + " (reposted)");
            }
            this.repost(id);
        }
    }

    public void buildCtrPrimitive(String id, XVariables.XVarInteger x, Types.TypeArithmeticOperator aop, int k, Types.TypeConditionOperatorRel op, XVariables.XVarInteger y) {
        if (this.imp().rs.cp.xml.displayPrimitives) {
            System.out.println("Primitive in class XCSP3 : (" + x + " " + aop + " " + k + ") " + op + " " + y + " (reposted)");
        }
        this.repost(id);
    }

    public void buildCtrPrimitive(String id, XVariables.XVarInteger x, Types.TypeArithmeticOperator aop, XVariables.XVarInteger y, Types.TypeConditionOperatorRel op, XVariables.XVarInteger z) {
        if (this.imp().rs.cp.xml.displayPrimitives) {
            System.out.println("Primitive in class XCSP3 : (" + x + " " + aop + " " + y + ") " + op + " " + z + " (reposted)");
        }
        this.repost(id);
    }

    public void buildCtrLogic(String id, Types.TypeLogicalOperator lop, XVariables.XVarInteger[] vars) {
        assert (Stream.of(vars).allMatch(x -> x.isZeroOne()));
        if (this.imp().rs.cp.xml.displayPrimitives) {
            System.out.println(TEXT_PRIMITIVES + lop + " " + Kit.join((Object)vars, new String[0]) + " (reposted)");
        }
        this.repost(id);
    }

    public void buildCtrLogic(String id, XVariables.XVarInteger x, Types.TypeEqNeOperator op, Types.TypeLogicalOperator lop, XVariables.XVarInteger[] vars) {
        assert (Stream.of(vars).allMatch(y -> y.isZeroOne()));
        if (this.imp().rs.cp.xml.displayPrimitives) {
            System.out.println(TEXT_PRIMITIVES + x + " " + op + " " + lop + " " + Kit.join((Object)vars, new String[0]) + " (reposted)");
        }
        this.repost(id);
    }

    public void buildCtrExtension(String id, XVariables.XVarInteger x, int[] values, boolean positive, Set<Types.TypeFlag> flags) {
        Kit.control(!flags.contains(Types.TypeFlag.STARRED_TUPLES));
        if (flags.contains(Types.TypeFlag.UNCLEAN_TUPLES)) {
            values = Variable.filterValues(this.trVar(x), values, false);
        }
        this.extension(this.trVar(x), values, positive);
    }

    public void buildCtrExtension(String id, XVariables.XVarInteger[] list, int[][] tuples, boolean positive, Set<Types.TypeFlag> flags) {
        if (flags.contains(Types.TypeFlag.UNCLEAN_TUPLES)) {
            tuples = Variable.filterTuples(this.trVars(list), tuples, false);
        }
        this.imp().extension(this.trVars(list), tuples, positive, flags.contains(Types.TypeFlag.STARRED_TUPLES));
    }

    public void buildCtrRegular(String id, XVariables.XVarInteger[] list, Object[][] transitions, String startState, String[] finalStates) {
        this.imp().regular(this.trVars(list), new Automaton(startState, (Transition[])Stream.of(transitions).map(t -> new Transition((String)t[0], t[1], (String)t[2])).toArray(Transition[]::new), finalStates));
    }

    public void buildCtrMDD(String id, XVariables.XVarInteger[] list, Object[][] transitions) {
        this.mdd(this.trVars(list), (Transition[])Stream.of(transitions).map(t -> new Transition((String)t[0], t[1], (String)t[2])).toArray(Transition[]::new));
    }

    public void buildCtrAllDifferent(String id, XVariables.XVarInteger[] list) {
        this.allDifferent(this.trVars(list));
    }

    public void buildCtrAllDifferentExcept(String id, XVariables.XVarInteger[] list, int[] except) {
        this.trVars(list);
        this.allDifferent(this.trVars(list), this.exceptValues(except));
    }

    public void buildCtrAllDifferentList(String id, XVariables.XVarInteger[][] lists) {
        this.allDifferentList(this.trVars2D(lists));
    }

    public void buildCtrAllDifferentMatrix(String id, XVariables.XVarInteger[][] matrix) {
        this.allDifferentMatrix(this.trVars2D(matrix));
    }

    public void buildCtrAllDifferent(String id, XNode<XVariables.XVarInteger>[] trees) {
        XNode[] validTrees = (XNode[])Stream.of(trees).map(t -> t.replaceLeafValues(v -> v instanceof XVariables.XVarInteger ? this.trVar((XVariables.XVarInteger)v) : v)).toArray(XNode[]::new);
        this.allDifferent(validTrees);
    }

    public void buildCtrAllEqual(String id, XVariables.XVarInteger[] list) {
        this.allEqual(this.trVars(list));
    }

    public void buildCtrOrdered(String id, XVariables.XVarInteger[] list, Types.TypeOperatorRel operator) {
        this.ordered(this.trVars(list), (Types.TypeOperatorRel)Types.valueOf(Types.TypeOperatorRel.class, (String)operator.name()));
    }

    public void buildCtrOrdered(String id, XVariables.XVarInteger[] list, int[] lengths, Types.TypeOperatorRel operator) {
        this.ordered(this.trVars(list), lengths, (Types.TypeOperatorRel)Types.valueOf(Types.TypeOperatorRel.class, (String)operator.name()));
    }

    public void buildCtrOrdered(String id, XVariables.XVarInteger[] list, XVariables.XVarInteger[] lengths, Types.TypeOperatorRel operator) {
        this.ordered(this.trVars(list), this.trVars(lengths), (Types.TypeOperatorRel)Types.valueOf(Types.TypeOperatorRel.class, (String)operator.name()));
    }

    public void buildCtrLex(String id, XVariables.XVarInteger[][] lists, Types.TypeOperatorRel operator) {
        this.lex(this.trVars2D(lists), (Types.TypeOperatorRel)Types.valueOf(Types.TypeOperatorRel.class, (String)operator.name()));
    }

    public void buildCtrLexMatrix(String id, XVariables.XVarInteger[][] matrix, Types.TypeOperatorRel operator) {
        this.lexMatrix(this.trVars2D(matrix), (Types.TypeOperatorRel)Types.valueOf(Types.TypeOperatorRel.class, (String)operator.name()));
    }

    public void buildCtrSum(String id, XVariables.XVarInteger[] list, Condition condition) {
        if (condition instanceof Condition.ConditionRel) {
            Types.TypeConditionOperatorRel op = ((Condition.ConditionRel)condition).operator;
            if (condition instanceof Condition.ConditionVar) {
                this.sum(this.trVars(list), op, this.trVar(((Condition.ConditionVar)condition).x));
            } else {
                this.sum(this.trVars(list), op, Utilities.safeLong2Int((long)((Condition.ConditionVal)condition).k, (boolean)true));
            }
        } else {
            Types.TypeConditionOperatorSet op = ((Condition.ConditionSet)condition).operator;
            if (condition instanceof Condition.ConditionIntset) {
                this.sum(this.trVars(list), op, ((Condition.ConditionIntset)condition).t);
            } else if (condition instanceof Condition.ConditionIntvl) {
                this.sum(this.trVars(list), op, this.rangeClosed(Utilities.safeLong2Int((long)((Condition.ConditionIntvl)condition).min, (boolean)true), Utilities.safeLong2Int((long)((Condition.ConditionIntvl)condition).max, (boolean)true)));
            } else {
                Kit.exit("unimplemented case for sum");
            }
        }
    }

    public void buildCtrSum(String id, XVariables.XVarInteger[] list, int[] coeffs, Condition condition) {
        if (coeffs == null || Kit.withOnly(1, coeffs)) {
            this.buildCtrSum(id, list, condition);
        } else if (condition instanceof Condition.ConditionRel) {
            Types.TypeConditionOperatorRel op = ((Condition.ConditionRel)condition).operator;
            if (condition instanceof Condition.ConditionVar) {
                this.sum(this.trVars(list), coeffs, op, this.trVar(((Condition.ConditionVar)condition).x));
            } else {
                this.sum(this.trVars(list), coeffs, op, Utilities.safeLong2Int((long)((Condition.ConditionVal)condition).k, (boolean)true));
            }
        } else if (condition instanceof Condition.ConditionIntvl) {
            this.sum(this.trVars(list), coeffs, IN, this.rangeClosed(Utilities.safeLong2Int((long)((Condition.ConditionIntvl)condition).min, (boolean)true), Utilities.safeLong2Int((long)((Condition.ConditionIntvl)condition).max, (boolean)true)));
        } else {
            Kit.exit("unimplemented case for sum " + condition.getClass());
        }
    }

    public void buildCtrSum(String id, XVariables.XVarInteger[] list, XVariables.XVarInteger[] coeffs, Condition condition) {
        if (condition instanceof Condition.ConditionVar) {
            this.sum(this.trVars(list), this.trVars(coeffs), ((Condition.ConditionRel)condition).operator, this.trVar(((Condition.ConditionVar)condition).x));
        } else if (condition instanceof Condition.ConditionVal) {
            this.sum(this.trVars(list), this.trVars(coeffs), ((Condition.ConditionRel)condition).operator, Utilities.safeLong2Int((long)((Condition.ConditionVal)condition).k, (boolean)true));
        } else if (condition instanceof Condition.ConditionIntvl) {
            this.sum(this.trVars(list), this.trVars(coeffs), condition);
        } else {
            Kit.exit("unimplemented case for sum " + condition);
        }
    }

    public void buildCtrSum(String id, XNode<XVariables.XVarInteger>[] trees, Condition condition) {
        if (condition instanceof Condition.ConditionRel) {
            XNode[] validTrees = (XNode[])Stream.of(trees).map(t -> t.replaceLeafValues(v -> v instanceof XVariables.XVarInteger ? this.trVar((XVariables.XVarInteger)v) : v)).toArray(XNode[]::new);
            Types.TypeConditionOperatorRel op = ((Condition.ConditionRel)condition).operator;
            if (condition instanceof Condition.ConditionVar) {
                this.sum(validTrees, op, this.trVar(((Condition.ConditionVar)condition).x));
            } else {
                this.sum(validTrees, op, Utilities.safeLong2Int((long)((Condition.ConditionVal)condition).k, (boolean)true));
            }
        } else {
            Kit.exit("unimplemented case for sum");
        }
    }

    public void buildCtrSum(String id, XNode<XVariables.XVarInteger>[] trees, int[] coeffs, Condition condition) {
        if (condition instanceof Condition.ConditionRel) {
            XNode[] validTrees = (XNode[])Stream.of(trees).map(t -> t.replaceLeafValues(v -> v instanceof XVariables.XVarInteger ? this.trVar((XVariables.XVarInteger)v) : v)).toArray(XNode[]::new);
            Types.TypeConditionOperatorRel op = ((Condition.ConditionRel)condition).operator;
            if (condition instanceof Condition.ConditionVar) {
                this.sum(validTrees, coeffs, op, this.trVar(((Condition.ConditionVar)condition).x));
            } else {
                this.sum(validTrees, coeffs, op, Utilities.safeLong2Int((long)((Condition.ConditionVal)condition).k, (boolean)true));
            }
        } else {
            Kit.exit("unimplemented case for sum");
        }
    }

    public void buildCtrSum(String id, XNode<XVariables.XVarInteger>[] trees, XVariables.XVarInteger[] coeffs, Condition condition) {
        Kit.exit("unimplemented case for sum");
    }

    public void buildCtrCount(String id, XVariables.XVarInteger[] list, int[] values, Condition condition) {
        if (condition instanceof Condition.ConditionVar) {
            this.count(this.trVars(list), values, ((Condition.ConditionRel)condition).operator, this.trVar(((Condition.ConditionVar)condition).x));
        } else if (condition instanceof Condition.ConditionVal) {
            this.count(this.trVars(list), values, ((Condition.ConditionRel)condition).operator, Utilities.safeLong2Int((long)((Condition.ConditionVal)condition).k, (boolean)true));
        } else {
            Kit.exit("unimplemented case for count");
        }
    }

    public void buildCtrCount(String id, XVariables.XVarInteger[] list, XVariables.XVarInteger[] values, Condition condition) {
        Kit.exit("unimplemented case for count");
    }

    public void buildCtrAtLeast(String id, XVariables.XVarInteger[] list, int value, int k) {
        this.atLeast(this.trVars(list), value, k);
    }

    public void buildCtrAtMost(String id, XVariables.XVarInteger[] list, int value, int k) {
        this.atMost(this.trVars(list), value, k);
    }

    public void buildCtrExactly(String id, XVariables.XVarInteger[] list, int value, int k) {
        this.exactly(this.trVars(list), value, k);
    }

    public void buildCtrExactly(String id, XVariables.XVarInteger[] list, int value, XVariables.XVarInteger k) {
        this.exactly(this.trVars(list), value, this.trVar(k));
    }

    public void buildCtrAmong(String id, XVariables.XVarInteger[] list, int[] values, int k) {
        this.among(this.trVars(list), values, k);
    }

    public void buildCtrAmong(String id, XVariables.XVarInteger[] list, int[] values, XVariables.XVarInteger k) {
        Kit.exit("unimplemented case for among");
    }

    public void buildCtrNValues(String id, XVariables.XVarInteger[] list, Condition condition) {
        if (condition instanceof Condition.ConditionVar) {
            this.nValues(this.trVars(list), ((Condition.ConditionRel)condition).operator, this.trVar(((Condition.ConditionVar)condition).x));
        } else if (condition instanceof Condition.ConditionVal) {
            this.nValues(this.trVars(list), ((Condition.ConditionRel)condition).operator, Utilities.safeLong2Int((long)((Condition.ConditionVal)condition).k, (boolean)true));
        } else {
            Kit.exit("unimplemented case for nValues");
        }
    }

    public void buildCtrNValuesExcept(String id, XVariables.XVarInteger[] list, int[] values, Condition condition) {
        Kit.exit("unimplemented case for nValuesExcept");
    }

    public void buildCtrNotAllEqual(String id, XVariables.XVarInteger[] list) {
        this.notAllEqual(this.trVars(list));
    }

    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, int[] values, XVariables.XVarInteger[] occurs) {
        this.cardinality(this.trVars(list), values, closed, this.occurExactly(this.trVars(occurs)));
    }

    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, int[] values, int[] occurs) {
        this.cardinality(this.trVars(list), values, closed, this.occurExactly(occurs));
    }

    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, int[] values, int[] occursMin, int[] occursMax) {
        this.cardinality(this.trVars(list), values, closed, this.occurBetween(occursMin, occursMax));
    }

    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, XVariables.XVarInteger[] values, XVariables.XVarInteger[] occurs) {
        Kit.exit("unimplemented case for cardinality");
    }

    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, XVariables.XVarInteger[] values, int[] occurs) {
        Kit.exit("unimplemented case for cardinlity");
    }

    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, XVariables.XVarInteger[] values, int[] occursMin, int[] occursMax) {
        Kit.exit("unimplemented case for cardinality");
    }

    public void buildCtrMaximum(String id, XVariables.XVarInteger[] list, Condition condition) {
        if (condition instanceof Condition.ConditionVar && ((Condition.ConditionVar)condition).operator == EQ) {
            this.maximum(this.trVars(list), this.trVar(((Condition.ConditionVar)condition).x));
        } else if (condition instanceof Condition.ConditionVal) {
            this.maximum(this.trVars(list), condition);
        } else {
            Kit.exit("unimplemented case for maximum");
        }
    }

    public void buildCtrMaximum(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, Condition condition) {
        Kit.exit("unimplemented case for maximum");
    }

    public void buildCtrMaximum(String id, XNode<XVariables.XVarInteger>[] trees, Condition condition) {
        XNode[] validTrees = (XNode[])Stream.of(trees).peek(t -> System.out.println(t + " " + t.getClass().getName())).map(t -> t.replaceLeafValues(v -> v instanceof XVariables.XVarInteger ? this.trVar((XVariables.XVarInteger)v) : v)).toArray(XNode[]::new);
        if (condition instanceof Condition.ConditionVar && ((Condition.ConditionVar)condition).operator == EQ) {
            ((Condition.ConditionVar)condition).x = this.trVar(((Condition.ConditionVar)condition).x);
            this.imp().maximum(validTrees, condition);
        } else {
            Kit.exit("unimplemented case for minimum");
        }
    }

    public void buildCtrMinimum(String id, XVariables.XVarInteger[] list, Condition condition) {
        if (condition instanceof Condition.ConditionVar && ((Condition.ConditionVar)condition).operator == EQ) {
            this.minimum(this.trVars(list), this.trVar(((Condition.ConditionVar)condition).x));
        } else {
            Kit.exit("unimplemented case for minimum");
        }
    }

    public void buildCtrMinimum(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, Condition condition) {
        Kit.exit("unimplemented case for minimum");
    }

    public void buildCtrMinimum(String id, XNode<XVariables.XVarInteger>[] trees, Condition condition) {
        XNode[] validTrees = (XNode[])Stream.of(trees).peek(t -> System.out.println(t + " " + t.getClass().getName())).map(t -> t.replaceLeafValues(v -> v instanceof XVariables.XVarInteger ? this.trVar((XVariables.XVarInteger)v) : v)).toArray(XNode[]::new);
        if (condition instanceof Condition.ConditionVar && ((Condition.ConditionVar)condition).operator == EQ) {
            ((Condition.ConditionVar)condition).x = this.trVar(((Condition.ConditionVar)condition).x);
            this.imp().minimum(validTrees, condition);
        } else {
            Kit.exit("unimplemented case for minimum");
        }
    }

    public void buildCtrElement(String id, XVariables.XVarInteger[] list, XVariables.XVarInteger value) {
        Kit.exit("unimplemented case for element");
    }

    public void buildCtrElement(String id, XVariables.XVarInteger[] list, int value) {
        Kit.exit("unimplemented case for element");
    }

    public void buildCtrElement(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, XVariables.XVarInteger value) {
        Kit.control(startIndex == 0 && rank == Types.TypeRank.ANY);
        this.element(this.trVars(list), this.trVar(index), this.trVar(value));
    }

    public void buildCtrElement(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, int value) {
        Kit.control(startIndex == 0 && rank == Types.TypeRank.ANY);
        this.element(this.trVars(list), this.trVar(index), value);
    }

    public void buildCtrElement(String id, int[] list, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, XVariables.XVarInteger value) {
        Kit.control(rank == Types.TypeRank.ANY);
        this.element(list, this.startIndex(startIndex), this.index(this.trVar(index), rank), this.trVar(value));
    }

    public void buildCtrElement(String id, int[][] matrix, int startRowIndex, XVariables.XVarInteger rowIndex, int startColIndex, XVariables.XVarInteger colIndex, XVariables.XVarInteger value) {
        Kit.control(startRowIndex == 0 && startColIndex == 0);
        this.element(matrix, startRowIndex, this.trVar(rowIndex), startColIndex, this.trVar(colIndex), this.trVar(value));
    }

    public void buildCtrElement(String id, XVariables.XVarInteger[][] matrix, int startRowIndex, XVariables.XVarInteger rowIndex, int startColIndex, XVariables.XVarInteger colIndex, int value) {
        Kit.control(startRowIndex == 0 && startColIndex == 0);
        this.element(this.trVars2D(matrix), startRowIndex, this.trVar(rowIndex), startColIndex, this.trVar(colIndex), value);
    }

    public void buildCtrChannel(String id, XVariables.XVarInteger[] list, int startIndex) {
        Kit.exit("unimplemented case for channel");
    }

    public void buildCtrChannel(String id, XVariables.XVarInteger[] list1, int startIndex1, XVariables.XVarInteger[] list2, int startIndex2) {
        Kit.control(startIndex1 == 0 && startIndex2 == 0);
        this.channel(this.trVars(list1), this.trVars(list2));
    }

    public void buildCtrChannel(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger value) {
        Kit.control(startIndex == 0);
        this.channel(this.trVars(list), this.trVar(value));
    }

    public void buildCtrStretch(String id, XVariables.XVarInteger[] list, int[] values, int[] widthsMin, int[] widthsMax) {
        Kit.exit("unimplemented case for stretch");
    }

    public void buildCtrStretch(String id, XVariables.XVarInteger[] list, int[] values, int[] widthsMin, int[] widthsMax, int[][] patterns) {
        Kit.exit("unimplemented case for stretch");
    }

    public void buildCtrNoOverlap(String id, XVariables.XVarInteger[] origins, int[] lengths, boolean zeroIgnored) {
        if (!zeroIgnored) {
            Kit.exit("unimplemented case");
        }
        this.noOverlap(this.trVars(origins), lengths);
    }

    public void buildCtrNoOverlap(String id, XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, boolean zeroIgnored) {
        if (!zeroIgnored) {
            Kit.exit("unimplemented case");
        }
        Kit.exit("unimplemented case");
    }

    public void buildCtrNoOverlap(String id, XVariables.XVarInteger[][] origins, int[][] lengths, boolean zeroIgnored) {
        if (!zeroIgnored) {
            Kit.exit("unimplemented case");
        }
        this.noOverlap(this.trVars2D(origins), lengths);
    }

    public void buildCtrNoOverlap(String id, XVariables.XVarInteger[][] origins, XVariables.XVarInteger[][] lengths, boolean zeroIgnored) {
        if (!zeroIgnored) {
            Kit.exit("unimplemented case");
        }
        this.noOverlap(this.trVars2D(origins), this.trVars2D(lengths));
    }

    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, int[] lengths, int[] heights, Condition condition) {
        if (condition instanceof Condition.ConditionVal && (((Condition.ConditionVal)condition).operator == LT || ((Condition.ConditionVal)condition).operator == LE)) {
            this.cumulative(this.trVars(origins), lengths, heights, Utilities.safeLong2Int((long)((Condition.ConditionVal)condition).k, (boolean)true) - (((Condition.ConditionVal)condition).operator == LT ? 1 : 0));
        } else {
            Kit.exit("unimplemented case");
        }
    }

    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, int[] lengths, XVariables.XVarInteger[] heights, Condition condition) {
        Kit.exit("unimplemented case");
    }

    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, int[] heights, Condition condition) {
        Kit.exit("unimplemented case");
    }

    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, XVariables.XVarInteger[] heights, Condition condition) {
        Kit.exit("unimplemented case");
    }

    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, int[] lengths, XVariables.XVarInteger[] ends, int[] heights, Condition condition) {
        Kit.exit("unimplemented case");
    }

    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, int[] lengths, XVariables.XVarInteger[] ends, XVariables.XVarInteger[] heights, Condition condition) {
        Kit.exit("unimplemented case");
    }

    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, XVariables.XVarInteger[] ends, int[] heights, Condition condition) {
        Kit.exit("unimplemented case");
    }

    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, XVariables.XVarInteger[] ends, XVariables.XVarInteger[] heights, Condition condition) {
        Kit.exit("unimplemented case");
    }

    public void buildCtrInstantiation(String id, XVariables.XVarInteger[] list, int[] values) {
        this.instantiation(this.trVars(list), values);
    }

    public void buildCtrClause(String id, XVariables.XVarInteger[] pos, XVariables.XVarInteger[] neg) {
        this.clause(this.trVars(pos), this.trVars(neg));
    }

    public void buildCtrCircuit(String id, XVariables.XVarInteger[] list, int startIndex) {
        Kit.control(startIndex == 0);
        this.circuit(this.trVars(list));
    }

    public void buildBinPacking(String id, XVariables.XVarInteger[] list, int[] sizes, Condition condition) {
        if (condition instanceof Condition.ConditionVal && (((Condition.ConditionVal)condition).operator == LT || ((Condition.ConditionVal)condition).operator == LE)) {
            this.imp().addCtr(new BinPackingSimple(this.imp(), this.trVars(list), sizes, Utilities.safeLong2Int((long)((Condition.ConditionVal)condition).k, (boolean)true) - (((Condition.ConditionVal)condition).operator == LT ? 1 : 0)), new Types.TypeClass[0]);
        } else {
            Kit.exit("unimplemented case");
        }
    }

    public void loadObj(XObjectives.XObj o) {
        if (this.imp().stuff.mustDiscard((IVar[])o.vars())) {
            return;
        }
        super.loadObj(o);
        CtrEntities.CtrEntity entity = (CtrEntities.CtrEntity)this.imp().ctrEntities.allEntities.get(this.imp().ctrEntities.allEntities.size() - 1);
        this.copyBasicAttributes((ModelingEntity)entity, (ParsingEntry)o);
    }

    public void buildObjToMinimize(String id, XVariables.XVarInteger x) {
        this.imp().minimize(this.trVar(x));
    }

    public void buildObjToMaximize(String id, XVariables.XVarInteger x) {
        this.imp().maximize(this.trVar(x));
    }

    private List<Variable.VarVal> isSum(XNodeParent<XVariables.XVarInteger> tree) {
        ArrayList<Variable.VarVal> list = new ArrayList<Variable.VarVal>();
        if (tree.type == Types.TypeExpr.ADD) {
            for (XNode son : tree.sons) {
                if (son.type == Types.TypeExpr.VAR) {
                    list.add(new Variable.VarVal(this.trVar((XVariables.XVarInteger)son.var(0)), 1));
                    continue;
                }
                if (MatcherInterface.x_mul_k.matches(son) || MatcherInterface.k_mul_x.matches(son)) {
                    list.add(new Variable.VarVal(this.trVar((XVariables.XVarInteger)son.var(0)), son.val(0)));
                    continue;
                }
                list.clear();
                break;
            }
        }
        return list;
    }

    public void buildObjToMinimize(String id, XNodeParent<XVariables.XVarInteger> tree) {
        List<Variable.VarVal> list = this.isSum(tree);
        if (list.size() > 0) {
            this.imp().minimize(Types.TypeObjective.SUM, (IVar[])list.stream().map(vv -> vv.x).toArray(VariableInteger[]::new), list.stream().mapToInt(vv -> vv.a).toArray());
        } else {
            XNode validTree = tree.replaceLeafValues(v -> v instanceof XVariables.XVarInteger ? this.trVar((XVariables.XVarInteger)v) : v);
            this.imp().minimize((XNode<IVar>)validTree);
        }
    }

    public void buildObjToMaximize(String id, XNodeParent<XVariables.XVarInteger> tree) {
        List<Variable.VarVal> list = this.isSum(tree);
        if (list.size() > 0) {
            this.imp().maximize(Types.TypeObjective.SUM, (IVar[])list.stream().map(vv -> vv.x).toArray(VariableInteger[]::new), list.stream().mapToInt(vv -> vv.a).toArray());
        } else {
            XNode validTree = tree.replaceLeafValues(v -> v instanceof XVariables.XVarInteger ? this.trVar((XVariables.XVarInteger)v) : v);
            this.imp().maximize((XNode<IVar>)validTree);
        }
    }

    public void buildObjToMinimize(String id, Types.TypeObjective type, XVariables.XVarInteger[] list) {
        this.imp().minimize(type, this.trVars(list));
    }

    public void buildObjToMaximize(String id, Types.TypeObjective type, XVariables.XVarInteger[] list) {
        this.imp().maximize(type, this.trVars(list));
    }

    public void buildObjToMinimize(String id, Types.TypeObjective type, XVariables.XVarInteger[] list, int[] coeffs) {
        this.imp().minimize(type, this.trVars(list), coeffs);
    }

    public void buildObjToMaximize(String id, Types.TypeObjective type, XVariables.XVarInteger[] list, int[] coeffs) {
        this.imp().maximize(type, this.trVars(list), coeffs);
    }

    public void buildObjToMinimize(String id, Types.TypeObjective type, XNode<XVariables.XVarInteger>[] trees) {
        XNode[] validTrees = (XNode[])Stream.of(trees).map(t -> t.replaceLeafValues(v -> v instanceof XVariables.XVarInteger ? this.trVar((XVariables.XVarInteger)v) : v)).toArray(XNode[]::new);
        this.imp().minimize(type, validTrees);
    }

    public void buildObjToMaximize(String id, Types.TypeObjective type, XNode<XVariables.XVarInteger>[] trees) {
        XNode[] validTrees = (XNode[])Stream.of(trees).map(t -> t.replaceLeafValues(v -> v instanceof XVariables.XVarInteger ? this.trVar((XVariables.XVarInteger)v) : v)).toArray(XNode[]::new);
        this.imp().maximize(type, validTrees);
    }

    public void buildObjToMinimize(String id, Types.TypeObjective type, XNode<XVariables.XVarInteger>[] trees, int[] coeffs) {
        XNode[] validTrees = (XNode[])Stream.of(trees).map(t -> t.replaceLeafValues(v -> v instanceof XVariables.XVarInteger ? this.trVar((XVariables.XVarInteger)v) : v)).toArray(XNode[]::new);
        this.imp().minimize(type, validTrees, coeffs);
    }

    public void buildObjToMaximize(String id, Types.TypeObjective type, XNode<XVariables.XVarInteger>[] trees, int[] coeffs) {
        XNode[] validTrees = (XNode[])Stream.of(trees).map(t -> t.replaceLeafValues(v -> v instanceof XVariables.XVarInteger ? this.trVar((XVariables.XVarInteger)v) : v)).toArray(XNode[]::new);
        this.imp().maximize(type, validTrees, coeffs);
    }

    public void buildCtrIntension(String id, XVariables.XVarSymbolic[] scope, XNodeParent<XVariables.XVarSymbolic> tree) {
        Utilities.control((boolean)tree.exactlyVars((IVar[])scope), (String)"Pb with scope");
        this.intension(tree);
    }

    public void buildCtrExtension(String id, XVariables.XVarSymbolic x, String[] values, boolean positive, Set<Types.TypeFlag> flags) {
        Kit.control(!flags.contains(Types.TypeFlag.STARRED_TUPLES), () -> "Forbidden for unary constraints");
        values = flags.contains(Types.TypeFlag.UNCLEAN_TUPLES) ? Variable.filterValues(this.trVar(x), values) : values;
        this.extension(this.trVar(x), values, positive);
    }

    public void buildCtrExtension(String id, XVariables.XVarSymbolic[] list, String[][] tuples, boolean positive, Set<Types.TypeFlag> flags) {
        tuples = flags.contains(Types.TypeFlag.UNCLEAN_TUPLES) ? Variable.filterTuples(this.trVars(list), tuples) : tuples;
        this.imp().extension(this.trVars(list), tuples, positive, flags.contains(Types.TypeFlag.STARRED_TUPLES));
    }

    public void buildCtrAllDifferent(String id, XVariables.XVarSymbolic[] list) {
        this.allDifferent(this.trVars(list));
    }

    public void buildAnnotationDecision(XVariables.XVarInteger[] list) {
        this.decisionVariables(this.trVars(list));
    }
}

