/*
 * Decompiled with CFR 0.152.
 */
package problems.xcsp2;

import constraints.hard.CtrIntension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.domains.Values;
import org.xcsp.common.predicates.EvaluationManager;
import org.xcsp.common.predicates.XNode;
import org.xcsp.common.predicates.XNodeLeaf;
import org.xcsp.common.predicates.XNodeParent;
import problem.Problem;
import problem.Symbolic;
import problems.xcsp2.XConstraint;
import problems.xcsp2.XConstraintIntension;
import problems.xcsp2.XHandler;
import utility.Kit;
import variables.Variable;

public class XIntension {
    private Problem problem;
    private Map<String, XConstraint> mapForScopes;
    private List<XConstraint> collectedCtrs;

    public void clear() {
        this.mapForScopes.clear();
        this.collectedCtrs.clear();
    }

    public XIntension(XHandler handler) {
        this.problem = handler.problem;
        this.mapForScopes = new HashMap<String, XConstraint>();
        this.collectedCtrs = new ArrayList<XConstraint>();
    }

    private final String buildStringWithNamesOf(Variable ... vars) {
        StringBuilder sb = new StringBuilder();
        for (Variable var : vars) {
            sb.append(var.id()).append(' ');
        }
        return sb.toString();
    }

    public void treat(String name, Variable[] scope, String[] predicate) {
        if (!this.problem.rs.cp.constraints.normalizeCtrs) {
            this.collectedCtrs.add(new XConstraintIntension(name, scope, predicate));
        } else {
            String scopeKey = this.buildStringWithNamesOf(scope);
            XConstraintIntension xconstraintWithSameScope = (XConstraintIntension)this.mapForScopes.get(scopeKey);
            if (xconstraintWithSameScope == null) {
                xconstraintWithSameScope = new XConstraintIntension(name, scope, predicate);
                this.collectedCtrs.add(xconstraintWithSameScope);
                this.mapForScopes.put(scopeKey, xconstraintWithSameScope);
            } else {
                ++this.problem.stuff.nMergedCtrs;
                xconstraintWithSameScope.mergeWith(name, predicate);
            }
        }
    }

    private XNode<IVar> parseExpression(String s, Map<String, Variable> mapForVars) {
        int leftParenthesisPosition = s.indexOf(40);
        if (leftParenthesisPosition == -1) {
            Variable var = mapForVars.get(s);
            if (var != null) {
                return new XNodeLeaf(Types.TypeExpr.VAR, (Object)var);
            }
            if (s.charAt(0) == '%') {
                long l = Utilities.safeLong((String)s.substring(1));
                Utilities.control((boolean)Utilities.isSafeInt((long)l), (String)"Bad value (index) for the parameter");
                return new XNodeLeaf(Types.TypeExpr.PAR, (Object)l);
            }
            String[] t = s.split("\\.");
            if (t.length == 2) {
                return new XNodeLeaf(Types.TypeExpr.DECIMAL, (Object)new Values.Decimal(Utilities.safeLong((String)t[0]).longValue(), Utilities.safeLong((String)t[1]).longValue()));
            }
            if (Character.isDigit(s.charAt(0)) || s.charAt(0) == '+' || s.charAt(0) == '-') {
                return new XNodeLeaf(Types.TypeExpr.LONG, (Object)Utilities.safeLong((String)s));
            }
            return new XNodeLeaf(Types.TypeExpr.SYMBOL, (Object)s);
        }
        int rightParenthesisPosition = s.lastIndexOf(")");
        Types.TypeExpr operator = Types.TypeExpr.valueOf((String)s.substring(0, leftParenthesisPosition).toUpperCase());
        if (leftParenthesisPosition == rightParenthesisPosition - 1) {
            Kit.control(operator == Types.TypeExpr.SET);
            return new XNodeLeaf(Types.TypeExpr.SET, null);
        }
        String content = s.substring(leftParenthesisPosition + 1, rightParenthesisPosition);
        ArrayList<XNode<IVar>> nodes = new ArrayList<XNode<IVar>>();
        for (int right = 0; right < content.length(); ++right) {
            int left = right;
            int nbOpens = 0;
            while (right < content.length()) {
                if (content.charAt(right) == '(') {
                    ++nbOpens;
                } else if (content.charAt(right) == ')') {
                    --nbOpens;
                } else if (content.charAt(right) == ',' && nbOpens == 0) break;
                ++right;
            }
            nodes.add(this.parseExpression(content.substring(left, right).trim(), mapForVars));
        }
        return new XNodeParent(operator, nodes);
    }

    private static boolean controlUniversalExpression(String[] expression, Symbolic symbolic) {
        for (String token : expression) {
            if (Utilities.isInteger((String)token) || symbolic != null && symbolic.isPresent(token) || EvaluationManager.arityOf((String)token) != 0 || token.startsWith("%")) continue;
            return false;
        }
        return true;
    }

    private static String buildFrom(String token, Object[] args, Symbolic symbolic, Stack<String> stack) {
        if (Utilities.isInteger((String)token)) {
            return token;
        }
        if (symbolic != null && symbolic.isPresent(token)) {
            return token;
        }
        if (token.startsWith("%")) {
            int pos = Integer.parseInt(token.substring(1));
            return args == null ? token : (args[pos] instanceof Variable ? ((Variable)args[pos]).id() : args[pos].toString());
        }
        if (token.equals("0set")) {
            return "set()";
        }
        int arity = EvaluationManager.arityOf((String)token);
        if (arity == 0 || arity == -1) {
            return token;
        }
        String s = stack.pop();
        for (int i = 1; i < arity; ++i) {
            s = stack.pop() + "," + s;
        }
        return Kit.getTokenPossiblyRemovedFromHeadNumber(token) + "(" + s + ")";
    }

    public static String buildFunctionalExpression(String[] universalPostfixExpression, Object[] args, Symbolic symbolic) {
        assert (args == null || XIntension.controlUniversalExpression(universalPostfixExpression, symbolic));
        Stack<String> stack = new Stack<String>();
        for (String token : universalPostfixExpression) {
            stack.add(XIntension.buildFrom(token, args, symbolic, stack));
        }
        assert (stack.size() == 1);
        return (String)stack.pop();
    }

    public void postConstraints() {
        this.testScopeIntersections();
        for (XConstraint xconstraintt : this.collectedCtrs) {
            XConstraintIntension xconstraint = (XConstraintIntension)xconstraintt;
            xconstraint.mergeCollectedDefinitions();
            String[] predicateExpression = xconstraint.universalPredicateExpression;
            String s = XIntension.buildFunctionalExpression(predicateExpression, xconstraint.scope, null);
            Map<String, Variable> mapForVars = Stream.of(xconstraint.scope).collect(Collectors.toMap(x -> x.id(), x -> x));
            XNodeParent tree = (XNodeParent)this.parseExpression(s, mapForVars);
            if (xconstraint.scope.length == 1) {
                this.problem.addCtr(new CtrIntension(this.problem, xconstraint.scope, (XNodeParent<IVar>)tree), new Types.TypeClass[0]);
                continue;
            }
            CtrIntension ctr = new CtrIntension(this.problem, (Variable[])tree.vars(), (XNodeParent<IVar>)tree);
            this.problem.addCtr(ctr.setId(xconstraint.name), new Types.TypeClass[0]);
        }
    }

    private int intersectionSize(Variable[] vars1, Variable ... vars2) {
        assert (Variable.areNumsIncreasing(vars1) && Variable.areNumsIncreasing(vars2));
        int i = 0;
        int j = 0;
        int cnt = 0;
        while (i < vars1.length && j < vars2.length) {
            if (vars1[i].num < vars2[j].num) {
                ++i;
                continue;
            }
            if (vars1[i].num > vars2[j].num) {
                ++j;
                continue;
            }
            ++cnt;
            ++i;
            ++j;
        }
        return cnt;
    }

    private void testScopeIntersections() {
        boolean testScope = false;
        if (testScope) {
            int i;
            XConstraintIntension[] hics = this.collectedCtrs.toArray(new XConstraintIntension[this.collectedCtrs.size()]);
            Variable[][] sortedScopes = new Variable[hics.length][];
            for (i = 0; i < hics.length; ++i) {
                sortedScopes[i] = (Variable[])Kit.sort((Object[])hics[i].scope.clone());
            }
            for (i = 0; i < hics.length - 1; ++i) {
                for (int j = i + 1; j < hics.length; ++j) {
                    if (Variable.contains(sortedScopes[i], sortedScopes[j])) {
                        Kit.log.info(Kit.join((Object)sortedScopes[i], new String[0]) + " -- " + Kit.join((Object)sortedScopes[j], new String[0]));
                        continue;
                    }
                    int cnt = this.intersectionSize(sortedScopes[i], sortedScopes[j]);
                    if (cnt <= 1) continue;
                    Kit.log.info(cnt + " " + Kit.join((Object)sortedScopes[i], new String[0]) + " -- " + Kit.join((Object)sortedScopes[j], new String[0]));
                }
            }
        }
    }
}

