/*
 * Decompiled with CFR 0.152.
 */
package problems.todo;

import java.util.StringTokenizer;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.structures.Table;
import org.xcsp.modeler.api.ProblemAPI;
import problems.ReaderFile;
import utility.Kit;

public class SportsPeriods
implements ProblemAPI,
ReaderFile.ReaderTxt {
    int nTeams;
    int[][][] originalMatches;

    void data() {
        int nWeeks = -1;
        int currentPeriod = 0;
        while (this.hasNextLine()) {
            StringTokenizer st = new StringTokenizer(this.nextLine(), " \t\n\r\f");
            if (nWeeks == -1) {
                nWeeks = st.countTokens();
                Kit.control(nWeeks % 2 == 1);
                this.nTeams = nWeeks + 1;
                this.originalMatches = new int[this.nTeams / 2][nWeeks][2];
            } else {
                Kit.control(nWeeks == st.countTokens());
            }
            for (int i = 0; i < nWeeks; ++i) {
                StringTokenizer st2 = new StringTokenizer(st.nextToken(), "vs");
                Kit.control(st2.countTokens() == 2);
                this.originalMatches[currentPeriod][i][0] = Integer.parseInt(st2.nextToken());
                this.originalMatches[currentPeriod][i][1] = Integer.parseInt(st2.nextToken());
            }
            ++currentPeriod;
        }
        Kit.control(currentPeriod == this.nTeams / 2);
    }

    private int matchNumberFor(int nPossibleMatches, int idTeam1, int idTeam2) {
        return nPossibleMatches - (this.nTeams - idTeam1) * (this.nTeams - idTeam1 - 1) / 2 + (idTeam2 - idTeam1 - 1);
    }

    public void model() {
        int nWeeks = this.nTeams - 1;
        int nPeriods = this.nTeams / 2;
        int nPossibleMatches = this.nTeams * (this.nTeams - 1) / 2;
        IVar.Var[][] h = this.array("h", this.size(nPeriods, nWeeks), this.dom(this.range(this.nTeams)), new Types.TypeClass[0]);
        IVar.Var[][] a = this.array("a", this.size(nPeriods, nWeeks), this.dom(this.range(this.nTeams)), new Types.TypeClass[0]);
        Object[][] m = this.array("m", this.size(nPeriods, nWeeks), this.dom(this.range(nPossibleMatches)), new Types.TypeClass[0]);
        Table matchNums = this.table().addFrom(this.range(this.nTeams).range(this.nTeams), (i, j) -> i < j ? this.tuple((int)i, new int[]{j, this.matchNumberFor(nPossibleMatches, (int)i, (int)j)}) : null);
        this.forall(this.range(nPeriods).range(nWeeks), (arg_0, arg_1) -> this.lambda$model$1(h, a, (IVar.Var[][])m, matchNums, arg_0, arg_1)).note("Linking variables through ternary table constraints");
        int[][] allowedMatches = new int[nPeriods][1];
        for (int i2 = 0; i2 < nWeeks; ++i2) {
            int j2;
            for (j2 = 0; j2 < nPeriods; ++j2) {
                allowedMatches[j2][0] = this.matchNumberFor(nPossibleMatches, this.originalMatches[j2][i2][0], this.originalMatches[j2][i2][1]);
            }
            for (j2 = 0; j2 < nPeriods; ++j2) {
                this.extension(new IVar.Var[]{m[j2][i2]}, allowedMatches);
            }
            this.allDifferent((IVar.Var[])this.columnOf(m, i2));
        }
        this.forall(this.range(nPeriods), p -> this.cardinality((IVar.Var[])this.vars(h[p], (IVar[])a[p]), this.vals(new Object[]{this.range(this.nTeams)}), this.occursEachBetween(1, 2))).note("Each team plays at most two times in each period");
        this.block(() -> {
            IVar.Var[] hd = this.array("hd", this.size(nPeriods), this.dom(this.range(this.nTeams)), "hd[p] is the number of the home opponent for the dummy match of the period", new Types.TypeClass[0]);
            IVar.Var[] ad = this.array("ad", this.size(nPeriods), this.dom(this.range(this.nTeams)), "ad[p] is the number of the away opponent for the dummy match of the period", new Types.TypeClass[0]);
            this.forall(this.range(nPeriods), p -> this.cardinality((IVar.Var[])this.vars(h[p], new Object[]{hd[p], ad[p], a[p]}), this.vals(new Object[]{this.range(this.nTeams)}), this.occursEachExactly(2))).note("Each team plays two times in each period");
            this.allDifferent((IVar.Var[])this.vars(hd, (IVar[])ad));
            this.forall(this.range(nPeriods), p -> this.intension(this.lt(hd[p], ad[p])));
        }).tag(new String[]{"dummyWeek"});
    }

    private /* synthetic */ void lambda$model$1(IVar.Var[][] h, IVar.Var[][] a, IVar.Var[][] m, Table matchNums, int p, int w) {
        this.extension((IVar.Var[])this.vars((IVar)h[p][w], (IVar[])new IVar.Var[]{a[p][w], m[p][w]}), matchNums);
    }
}

