/*
 * Decompiled with CFR 0.152.
 */
package problems.todo;

import java.util.ArrayList;
import org.xcsp.modeler.api.ProblemAPI;
import org.xcsp.modeler.implementation.NotData;
import utility.Kit;

public class DNA
implements ProblemAPI {
    @NotData
    int f;

    private int[] watsonCrickOf(int[] t) {
        int[] tt = new int[8];
        for (int i = 0; i < 8; ++i) {
            tt[i] = t[i] == 0 ? 3 : (t[i] == 1 ? 2 : (t[i] == 2 ? 1 : 0));
        }
        return tt;
    }

    private boolean verifyHD(int[] w1, int[] w2) {
        int cnt = 0;
        for (int i = 0; i < 8; ++i) {
            if (w1[i] == w2[i]) continue;
            ++cnt;
        }
        return cnt >= 4;
    }

    private boolean verifyRC(int[] w1, int[] w2) {
        int[] w2r = this.watsonCrickOf(w2);
        int cnt = 0;
        for (int i = 0; i < 8; ++i) {
            if (w1[8 - i - 1] == w2r[i]) continue;
            ++cnt;
        }
        return cnt >= 4;
    }

    private int[][] domains() {
        ArrayList<int[]> list = new ArrayList<int[]>();
        for (int i1 = 0; i1 < 4; ++i1) {
            for (int i2 = 0; i2 < 4; ++i2) {
                for (int i3 = 0; i3 < 4; ++i3) {
                    for (int i4 = 0; i4 < 4; ++i4) {
                        for (int i5 = 0; i5 < 4; ++i5) {
                            for (int i6 = 0; i6 < 4; ++i6) {
                                for (int i7 = 0; i7 < 4; ++i7) {
                                    for (int i8 = 0; i8 < 4; ++i8) {
                                        int[] t = new int[]{i1, i2, i3, i4, i5, i6, i7, i8};
                                        if (Kit.countIn(1, t) + Kit.countIn(2, t) != 4 || !this.verifyRC(t, t)) continue;
                                        list.add(t);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        System.out.println("Nb" + list.size());
        return Kit.intArray2D(list);
    }

    public void model() {
        int[][] m = this.domains();
        int cnt = 0;
        for (int i = 0; i < m.length; ++i) {
            for (int j = i + 1; j < m.length; ++j) {
                if (!this.verifyHD(m[i], m[j]) || !this.verifyRC(m[i], m[j]) || !this.verifyRC(m[j], m[i])) continue;
                ++cnt;
            }
        }
        System.out.println("cnt" + cnt);
    }
}

