/*
 * Decompiled with CFR 0.152.
 */
package problems.test;

import java.util.Arrays;
import java.util.Random;
import java.util.stream.IntStream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.modeler.api.ProblemAPI;
import utility.Kit;
import utility.operations.Base;

public class TestSTRMining
implements ProblemAPI {
    int n;
    int d;
    int e;
    int r;
    int itemLength;
    int subtableSize;
    int nSlices;
    int seed;
    int nPigeons;

    void data() {
        this.n = this.imp().askInt("Nb variables");
        this.d = this.imp().askInt("Nb values");
        this.e = this.imp().askInt("Nb constraints");
        this.r = this.imp().askInt("Arity");
        this.itemLength = this.imp().askInt("Item length");
        this.subtableSize = this.imp().askInt("Subtable size");
        this.nSlices = this.imp().askInt("Nb slices");
        this.seed = this.imp().askInt("Seed");
        this.nPigeons = this.imp().askInt("Nb pigeons");
        Kit.control(Math.pow(this.d, this.r - this.itemLength) < 2.147483647E9);
        Kit.control((double)this.subtableSize <= Math.pow(this.d, this.r - this.itemLength), () -> " Bad parameters");
        Kit.control(this.nSlices <= this.d);
    }

    private int[] buildTuple(int length, int[] frozenPositions, int[] frozenValues, int[] subtuple) {
        int currFrozenPosition = 0;
        int subtuplePosition = 0;
        int[] t = new int[length];
        for (int i = 0; i < t.length; ++i) {
            t[i] = currFrozenPosition < frozenPositions.length && i == frozenPositions[currFrozenPosition] ? frozenValues[currFrozenPosition++] : subtuple[subtuplePosition++];
        }
        return t;
    }

    private void buildSlice(int id, int[][] tuples, int offset, int commonVariablePositionInItems, Random random) {
        int[] itemPositions = Kit.pickDifferentValues(this.itemLength, this.r, random);
        if (!Kit.isPresent(commonVariablePositionInItems, itemPositions)) {
            int position = random.nextInt(this.itemLength);
            itemPositions[position] = commonVariablePositionInItems;
            Arrays.sort(itemPositions);
        }
        int[] itemValues = IntStream.range(0, this.itemLength).map(j -> itemPositions[j] == commonVariablePositionInItems ? id : random.nextInt(this.d)).toArray();
        Kit.log.info("New slice with prefix " + Kit.join((Object)itemPositions, new String[0]) + " = " + Kit.join((Object)itemValues, new String[0]));
        int[] subtuplesIndexes = Kit.pickDifferentValues(this.subtableSize, (int)Math.pow(this.d, this.r - this.itemLength), random);
        for (int i = 0; i < this.subtableSize; ++i) {
            tuples[offset + i] = this.buildTuple(this.r, itemPositions, itemValues, Base.baseValueFor(subtuplesIndexes[i], this.r - this.itemLength, this.d));
        }
    }

    public void model() {
        Random random = new Random(this.seed);
        int[] commonVariablePositionInItems = IntStream.range(0, this.e).map(i -> random.nextInt(this.r)).toArray();
        IVar.Var[] x = this.array("x", this.size(this.n), this.dom(this.range(this.d)), new Types.TypeClass[0]);
        IVar.Var[] p = this.array("P", this.size(this.nPigeons), this.dom(this.range(this.nPigeons - 1)), new Types.TypeClass[0]);
        this.forall(this.range(this.e), i -> {
            int[] scopeIds = Kit.pickDifferentValues(this.r, this.n, random);
            IVar.Var[] scope = (IVar.Var[])this.variablesFrom(scopeIds, id -> x[id]);
            int[][] tuples = new int[this.nSlices * this.subtableSize][];
            for (int j = 0; j < this.nSlices; ++j) {
                this.buildSlice(j, tuples, j * this.subtableSize, commonVariablePositionInItems[i], random);
            }
            Arrays.sort(tuples, Utilities.lexComparatorInt);
            this.extension(scope, tuples);
        });
        this.forall(this.range(this.nPigeons).range(this.nPigeons), (i, j) -> {
            if (i < j) {
                this.intension(this.ne(new Object[]{p[i], p[j]}));
            }
        });
    }
}

