/*
 * Decompiled with CFR 0.152.
 */
package problems.soft;

import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.stream.IntStream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.enumerations.EnumerationOfCombinations;
import org.xcsp.common.enumerations.EnumerationOfPermutations;
import org.xcsp.modeler.api.ProblemAPI;
import problem.Problem;
import utility.Kit;

public class Poker
implements ProblemAPI {
    int nbSuits = this.imp().askInt("Nb suits");
    int nbValues = this.imp().askInt("Nb values");
    int handLimit = this.imp().askInt("Hand limit");
    int order = 5;
    int[] handCosts = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    IVar.Var[][] x = this.array("x", this.size(this.order, this.order), this.dom(this.range(this.nbValues * this.nbSuits)), new Types.TypeClass[0]);

    public Poker() {
        ((Problem)this.imp()).rs.cp.optimizing.upperBound = Math.min(((Problem)this.imp()).rs.cp.optimizing.upperBound, Integer.MAX_VALUE);
        ((Problem)this.imp()).framework = Types.TypeFramework.WCSP;
    }

    int getSuitOf(int v) {
        return v / this.nbValues;
    }

    int getValueOf(int v) {
        return v % this.nbValues;
    }

    private int countNbSuccessiveEqualCards(int[] hand, int startingPosition) {
        assert (startingPosition < hand.length);
        int cnt = 1;
        for (int i = startingPosition + 1; i < hand.length && this.getValueOf(hand[startingPosition]) == this.getValueOf(hand[i]); ++i) {
            ++cnt;
        }
        return cnt;
    }

    private int computePositionOSequenceOfEqualCardsOfExactlySize(int[] hand, int size, int startingPosition) {
        while (startingPosition < hand.length) {
            int cnt = this.countNbSuccessiveEqualCards(hand, startingPosition);
            if (cnt == size) {
                return startingPosition;
            }
            startingPosition += cnt;
        }
        return -1;
    }

    private int computePositionOSequenceOfEqualCardsOfExactlySize(int[] hand, int size) {
        return this.computePositionOSequenceOfEqualCardsOfExactlySize(hand, size, 0);
    }

    private long computeNbCardsOfSuit(int[] hand, int suit) {
        return Arrays.stream(hand).filter(h -> this.getSuitOf(h) == suit).count();
    }

    private boolean isRoyalFlush(int[] hand) {
        return this.isStraight(hand) && this.isFlush(hand) && this.getValueOf(hand[0]) == 0 && this.getValueOf(hand[hand.length - 1]) == this.nbValues - 1;
    }

    private boolean isStraightFlush(int[] hand) {
        return this.isStraight(hand) && this.isFlush(hand);
    }

    private boolean isFour(int[] hand) {
        return this.computePositionOSequenceOfEqualCardsOfExactlySize(hand, 4) != -1;
    }

    private boolean isFullHouse(int[] hand) {
        return this.computePositionOSequenceOfEqualCardsOfExactlySize(hand, 2) != -1 && this.computePositionOSequenceOfEqualCardsOfExactlySize(hand, 3) != -1;
    }

    private boolean isFlush(int[] hand) {
        return IntStream.range(0, this.nbSuits).anyMatch(i -> this.computeNbCardsOfSuit(hand, i) == 5L);
    }

    private boolean isStraight(int[] hand) {
        if (this.getValueOf(hand[0]) != 0) {
            return IntStream.range(0, hand.length - 1).noneMatch(i -> this.getValueOf(hand[i]) != this.getValueOf(hand[i + 1]) - 1);
        }
        if (this.getValueOf(hand[1]) == 1) {
            return IntStream.range(1, hand.length - 1).noneMatch(i -> this.getValueOf(hand[i]) != this.getValueOf(hand[i + 1]) - 1);
        }
        if (this.getValueOf(hand[hand.length - 1]) == this.nbValues - 1) {
            return IntStream.range(1, hand.length - 1).noneMatch(i -> this.getValueOf(hand[i]) != this.getValueOf(hand[i + 1]) - 1);
        }
        return false;
    }

    private boolean isThree(int[] hand) {
        return this.computePositionOSequenceOfEqualCardsOfExactlySize(hand, 3) != -1;
    }

    private boolean isTwoPair(int[] hand) {
        int position = this.computePositionOSequenceOfEqualCardsOfExactlySize(hand, 2, 0);
        return position == -1 ? false : this.computePositionOSequenceOfEqualCardsOfExactlySize(hand, 2, position) != -1;
    }

    private boolean isOnePair(int[] hand) {
        return this.computePositionOSequenceOfEqualCardsOfExactlySize(hand, 2) != -1;
    }

    private EHandType getHandTypeOf(int[] hand) {
        int cnt = 1;
        if (this.isRoyalFlush(hand)) {
            return EHandType.RF;
        }
        if (++cnt > this.handLimit) {
            return null;
        }
        if (this.isStraightFlush(hand)) {
            return EHandType.SF;
        }
        if (++cnt > this.handLimit) {
            return null;
        }
        if (this.isFour(hand)) {
            return EHandType.FOUR;
        }
        if (++cnt > this.handLimit) {
            return null;
        }
        if (this.isFullHouse(hand)) {
            return EHandType.FULL;
        }
        if (++cnt > this.handLimit) {
            return null;
        }
        if (this.isFlush(hand)) {
            return EHandType.FLUSH;
        }
        if (++cnt > this.handLimit) {
            return null;
        }
        if (this.isStraight(hand)) {
            return EHandType.STRAIGHT;
        }
        if (++cnt > this.handLimit) {
            return null;
        }
        if (this.isThree(hand)) {
            return EHandType.THREE;
        }
        if (++cnt > this.handLimit) {
            return null;
        }
        if (this.isTwoPair(hand)) {
            return EHandType.TWO;
        }
        if (++cnt > this.handLimit) {
            return null;
        }
        if (this.isOnePair(hand)) {
            return EHandType.ONE;
        }
        return null;
    }

    private void sort(int[] t) {
        boolean modified = false;
        do {
            modified = false;
            for (int i = 0; i < t.length - 1; ++i) {
                if (this.getValueOf(t[i]) <= this.getValueOf(t[i + 1])) continue;
                Kit.swap(t, i, i + 1);
                modified = true;
            }
        } while (modified);
    }

    private int[][] buildTuplesWithCosts() {
        int[] cnts = new int[10];
        int[] t = new int[this.order];
        int[][] permutations = new EnumerationOfPermutations(this.order).toArray();
        TreeSet<int[]> setOfTuplesWithCosts = new TreeSet<int[]>(new Comparator<int[]>(){

            @Override
            public int compare(int[] t1, int[] t2) {
                for (int i = 0; i < t1.length - 1; ++i) {
                    if (t1[i] < t2[i]) {
                        return -1;
                    }
                    if (t1[i] <= t2[i]) continue;
                    return 1;
                }
                return 0;
            }
        });
        int nbCards = this.nbSuits * this.nbValues;
        EnumerationOfCombinations enumeration = new EnumerationOfCombinations(new int[]{nbCards, nbCards, nbCards, nbCards, nbCards});
        while (enumeration.hasNext()) {
            Kit.copy(enumeration.next(), t);
            this.sort(t);
            EHandType handType = this.getHandTypeOf(t);
            if (handType == null) continue;
            int cost = this.handCosts[handType.ordinal()];
            int n = handType.ordinal();
            cnts[n] = cnts[n] + 1;
            for (int[] permutation : permutations) {
                int[] tupleWithCost = new int[this.order + 1];
                for (int i = 0; i < permutation.length; ++i) {
                    tupleWithCost[i] = t[permutation[i]];
                }
                tupleWithCost[tupleWithCost.length - 1] = cost;
                setOfTuplesWithCosts.add(tupleWithCost);
            }
        }
        int[][] tuplesWithCosts = (int[][])setOfTuplesWithCosts.toArray((T[])new int[setOfTuplesWithCosts.size()][]);
        return tuplesWithCosts;
    }

    /*
     * Exception decompiling
     */
    public void model() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private /* synthetic */ void lambda$model$8(IVar.Var[] y, int[][] tuples2, long[] costs2, int i, int j) {
        if (i < j) {
            ((Problem)this.imp()).ctrSoft(this.vars(y[i], (IVar)y[j]), tuples2, costs2, 0L);
        }
    }

    private static /* synthetic */ long lambda$model$7(long l) {
        return Integer.MAX_VALUE;
    }

    private static /* synthetic */ int[][] lambda$model$6(int x$0) {
        return new int[x$0][];
    }

    private static enum EHandType {
        RF,
        SF,
        FOUR,
        FULL,
        FLUSH,
        STRAIGHT,
        THREE,
        TWO,
        ONE;

    }
}

