/*
 * Decompiled with CFR 0.152.
 */
package problems.generators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Utilities;
import problems.ReaderFile;
import problems.g4_world.NurseRostering;
import utility.Kit;

public class NurseRosteringReader
extends NurseRostering
implements ReaderFile.ReaderTxt {
    private String skipComments(String line) {
        while (line.length() == 0 || line.startsWith("#")) {
            line = this.nextLine().trim();
        }
        return line;
    }

    void data() {
        BiConsumer<String, Consumer> c = (s, r) -> {
            String line = this.skipComments(this.nextLine().trim());
            Kit.control(line.equals(s));
            line = this.skipComments(this.nextLine().trim());
            while (line != null && line.length() != 0) {
                String[] tokens = line.split(",");
                r.accept(tokens);
                if (!this.hasNextLine()) break;
                line = this.nextLine();
                if (line == null) continue;
                line = line.trim();
            }
        };
        String line = this.skipComments(this.nextLine().trim());
        Kit.control(line.equals("SECTION_HORIZON"));
        int nDays = Integer.parseInt(this.skipComments(this.nextLine().trim()));
        HashMap mapShift = new HashMap();
        ArrayList listShifts = new ArrayList();
        c.accept("SECTION_SHIFTS", toks -> {
            Object shift = this.buildInternClassObject("Shift", new Object[]{toks[0], Integer.parseInt(toks[1]), ((String[])toks).length == 2 ? null : Stream.of(toks[2].split("\\|")).toArray(String[]::new)});
            listShifts.add(shift);
            mapShift.put(toks[0], mapShift.size());
        });
        ArrayList localStaffs = new ArrayList();
        c.accept("SECTION_STAFF", tokens -> localStaffs.add(new LocalStaff((String[])tokens)));
        Map<String, Integer> mapStaff = IntStream.range(0, localStaffs.size()).boxed().collect(Collectors.toMap(i -> ((LocalStaff)localStaffs.get((int)i)).id, i -> i));
        c.accept("SECTION_DAYS_OFF", tokens -> {
            int staff = (Integer)mapStaff.get(tokens[0]);
            LocalStaff.access$802((LocalStaff)localStaffs.get(staff), IntStream.range(1, ((String[])tokens).length).map(j -> Integer.parseInt(tokens[j])).toArray());
        });
        c.accept("SECTION_SHIFT_ON_REQUESTS", toks -> {
            int staff = (Integer)mapStaff.get(toks[0]);
            ((LocalStaff)localStaffs.get(staff)).onRequests.add(this.buildInternClassObject("Request", new Object[]{Integer.parseInt(toks[1]), toks[2], Integer.parseInt(toks[3])}));
        });
        c.accept("SECTION_SHIFT_OFF_REQUESTS", tokens -> {
            int staff = (Integer)mapStaff.get(tokens[0]);
            ((LocalStaff)localStaffs.get(staff)).offRequests.add(this.buildInternClassObject("Request", new Object[]{Integer.parseInt(tokens[1]), tokens[2], Integer.parseInt(tokens[3])}));
        });
        Stream<Object> staffs = localStaffs.stream().map(s -> this.buildInternClassObject("Staff", new Object[]{((LocalStaff)s).id, ((LocalStaff)s).maxShifts, ((LocalStaff)s).minTotalMinutes, ((LocalStaff)s).maxTotalMinutes, ((LocalStaff)s).minConsecutiveShifts, ((LocalStaff)s).maxConsecutiveShifts, ((LocalStaff)s).minConsecutiveDaysOff, ((LocalStaff)s).maxWeekends, ((LocalStaff)s).daysOff, Utilities.convert((Collection)((LocalStaff)s).onRequests), Utilities.convert((Collection)((LocalStaff)s).offRequests)}));
        Object[][] covers = new Object[nDays][listShifts.size()];
        c.accept("SECTION_COVER", tokens -> {
            int day = Integer.parseInt(tokens[0]);
            int shift = (Integer)mapShift.get(tokens[1]);
            covers[day][shift] = this.buildInternClassObject("Cover", new Object[]{Integer.parseInt(tokens[2]), Integer.parseInt(tokens[3]), Integer.parseInt(tokens[4])});
        });
        this.setDataValues(nDays, new Object[]{listShifts, staffs, Utilities.convert((Object[][])covers)});
    }

    private class LocalStaff {
        private String id;
        private int[] maxShifts;
        private int minTotalMinutes;
        private int maxTotalMinutes;
        private int minConsecutiveShifts;
        private int maxConsecutiveShifts;
        private int minConsecutiveDaysOff;
        private int maxWeekends;
        private int[] daysOff;
        private List<Object> onRequests = new ArrayList<Object>();
        private List<Object> offRequests = new ArrayList<Object>();

        private LocalStaff(String[] tokens) {
            this.id = tokens[0];
            this.maxShifts = Stream.of(tokens[1].split("\\|")).mapToInt(s -> Integer.parseInt(s.substring(s.indexOf("=") + 1))).toArray();
            this.minTotalMinutes = Integer.parseInt(tokens[3]);
            this.maxTotalMinutes = Integer.parseInt(tokens[2]);
            this.minConsecutiveShifts = Integer.parseInt(tokens[5]);
            this.maxConsecutiveShifts = Integer.parseInt(tokens[4]);
            this.minConsecutiveDaysOff = Integer.parseInt(tokens[6]);
            this.maxWeekends = Integer.parseInt(tokens[7]);
        }

        static /* synthetic */ int[] access$802(LocalStaff x0, int[] x1) {
            x0.daysOff = x1;
            return x1;
        }
    }
}

