/*
 * Decompiled with CFR 0.152.
 */
package problems.generators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import problems.g3_pattern.Coloring;

public class ColoringSmallWorld
extends Coloring {
    boolean isInGraph(int[] edge, List<int[]> graph) {
        return graph.stream().anyMatch(t -> Arrays.equals(edge, t));
    }

    int[][] buildEdges(int nNodes, int nEdges, int seed, double shuffleProbability) {
        Random random = new Random(seed);
        ArrayList<int[]> ringGraph = new ArrayList<int[]>((nNodes + 1) * nEdges);
        for (int i = 0; i < nNodes; ++i) {
            for (int j = 1; j <= nEdges; ++j) {
                int ring = i + j >= nNodes ? i + j - nNodes : (i + j < 0 ? i + j + nNodes : i + j);
                int[] t = new int[]{i, ring};
                Arrays.sort(t);
                ringGraph.add(t);
            }
        }
        ArrayList<int[]> randomGraph = new ArrayList<int[]>((nNodes + 1) * nEdges);
        for (int v = 0; v < nNodes; ++v) {
            for (int i = 1; i <= nEdges; ++i) {
                int[] edge = new int[]{random.nextInt(nNodes), random.nextInt(nNodes)};
                while (true) {
                    if (edge[0] == edge[1]) {
                        continue;
                    }
                    Arrays.sort(edge);
                    if (!this.isInGraph(edge, randomGraph)) break;
                }
                randomGraph.add(edge);
            }
        }
        ArrayList<int[]> graph = new ArrayList<int[]>((nNodes + 1) * nEdges);
        ArrayList<Integer> removed = new ArrayList<Integer>();
        for (int i = 0; i < ringGraph.size(); ++i) {
            if (random.nextDouble() < shuffleProbability) {
                removed.add(i);
                continue;
            }
            graph.add((int[])ringGraph.get(i));
        }
        Iterator iterator = removed.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (!this.isInGraph((int[])randomGraph.get(i), graph)) {
                graph.add((int[])randomGraph.get(i));
                continue;
            }
            if (this.isInGraph((int[])ringGraph.get(i), graph)) continue;
            graph.add((int[])ringGraph.get(i));
        }
        return (int[][])graph.stream().toArray(x$0 -> new int[x$0][]);
    }

    void data() {
        int nNodes = this.imp().askInt("Number of nodes");
        int nEdges = this.imp().askInt("Number of edges");
        int nColors = this.imp().askInt("Number of colors");
        double shuffleProbability = this.imp().askDouble("Shuffle probability", v -> 0.0 <= v && v <= 1.0);
        int seed = this.imp().askInt("Seed");
        int[][] edges = this.buildEdges(nNodes, nEdges, seed, shuffleProbability);
        this.imp().setDataValues((Object)nNodes, new Object[]{nColors, edges});
    }
}

