/*
 * Decompiled with CFR 0.152.
 */
package problems.g4_world;

import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;

public class Vrp
implements ProblemAPI {
    int n;
    int capacity;
    int[] demand;
    int[][] distances;

    public void model() {
        IVar.Var[][] x = this.array("x", this.size(this.n, this.n), (i, j) -> i == j ? this.dom(0, new int[0]) : this.dom(0, new int[]{1}), "x[i][j] is 1 iff the arc (i,j) is part of a route", new Types.TypeClass[0]);
        IVar.Var[] u = this.array("u", this.size(this.n), i -> i == 0 ? this.dom(0, new int[0]) : this.dom(this.range(this.capacity + 1)), "u[i] is the load of vehicle after visiting node i (used for subtour elimination)", new Types.TypeClass[0]);
        this.forall(this.range(1, this.n), j -> this.exactly((IVar.Var[])this.columnOf(x, j), 1, 1)).note("exactly one incoming arc for each node j other than depot (node 0)");
        this.forall(this.range(1, this.n), i -> this.exactly(x[i], 1, 1)).note("exactly one outgoing arc for each node i other than depot (node 0)");
        this.forall(this.range(1, this.n).range(1, this.n), (i, j) -> {
            if (i != j) {
                this.sum((IVar.Var[])this.vars((IVar)u[i], (IVar[])new IVar.Var[]{u[j], x[i][j]}), this.vals(new Object[]{1, -1, this.capacity}), LE, this.capacity - this.demand[j]);
            }
        }).note("Miller-Tucker-Zemlin subtour elimination");
        this.forall(this.range(1, this.n), i -> this.greaterEqual(u[i], this.demand[i]));
        this.minimize(SUM, (IVar[][])x, this.distances);
    }
}

