/*
 * Decompiled with CFR 0.152.
 */
package problems.g4_world;

import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;

public class TravelingPurchaser
implements ProblemAPI {
    int[][] cityDistances;
    int[][] productPrices;

    public void model() {
        int nCities = this.cityDistances.length;
        int nProducts = this.productPrices.length;
        IVar.Var[] s = this.array("s", this.size(nCities), this.dom(this.range(nCities)), "s[i] is the city succeeding to the ith city (itself if not part of the route)", new Types.TypeClass[0]);
        IVar.Var[] d = this.array("d", this.size(nCities), i -> this.dom(this.cityDistances[i], v -> v >= 0), "d[i] is the distance (seen as a travel cost) between the ith city and its successor", new Types.TypeClass[0]);
        IVar.Var[] l = this.array("l", this.size(nProducts), this.dom(this.range(nCities - 1)), "l[i] is the purchase location of the ith product (last city has nothing for sale)", new Types.TypeClass[0]);
        IVar.Var[] c = this.array("c", this.size(nProducts), i -> this.dom(this.productPrices[i]), "c[i] is the purchase cost of the ith product", new Types.TypeClass[0]);
        if (this.modelVariant("")) {
            this.forall(this.range(nCities), i -> this.element(this.cityDistances[i], s[i], d[i])).note("linking distances to successors");
            this.forall(this.range(nProducts), i -> this.element(this.productPrices[i], l[i], c[i])).note("linking purchase locations to purchase costs");
            this.forall(this.range(nCities).range(nProducts), (i, j) -> this.implication(this.eq(new Object[]{s[i], i}), this.ne(new Object[]{l[j], i}))).note("purchasing a product at a city is only possible if you visit that city");
        } else if (this.modelVariant("ext")) {
            // empty if block
        }
        this.circuit(s);
        this.different(new Object[]{s[nCities - 1], nCities - 1}).note("last city must be visited (we start here)");
        this.minimize(SUM, this.vars(d, (IVar[])c));
    }
}

