/*
 * Decompiled with CFR 0.152.
 */
package problems.g4_world;

import constraints.hard.global.GridLazy;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;
import org.xcsp.modeler.implementation.NotData;
import problem.Problem;
import variables.Variable;

public class CrosswordDesignFirstUnfinished
implements ProblemAPI {
    private static final String[] letters = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
    int nRows;
    int nCols;
    int nMaxRowWords;
    int nMaxColWords;
    String[] basicWords;
    String[] themeWords;
    @NotData
    String[] allWords;
    @NotData
    boolean[] fromThemeWords;
    @NotData
    int[] oneLetterPositions;

    private void buildUniqueDictionary() {
        this.allWords = (String[])Stream.concat(Stream.of(letters), Stream.concat(Stream.of(this.basicWords), Stream.of(this.themeWords))).filter(w -> w.length() <= this.nRows).distinct().sorted().toArray(String[]::new);
        this.fromThemeWords = new boolean[this.allWords.length];
        List<String> list = Arrays.asList(this.allWords);
        Stream.of(this.themeWords).forEach(w -> {
            this.fromThemeWords[list.indexOf((Object)w)] = true;
        });
        this.oneLetterPositions = Stream.of(letters).mapToInt(l -> list.indexOf(l)).toArray();
    }

    private int[][] buildTableForTwoSuccessiveWords() {
        ArrayList<int[]> list = new ArrayList<int[]>();
        list.add(this.tuple(-1, new int[]{0, -1}));
        for (int p = 0; p < this.nRows; ++p) {
            for (int s = 1; s <= this.nRows; ++s) {
                if (p + s > this.nRows) continue;
                list.add(p + s <= 11 ? this.tuple(p, new int[]{s, p + s + 1}) : this.tuple(p, new int[]{s, -1}));
            }
        }
        return (int[][])list.stream().toArray(x$0 -> new int[x$0][]);
    }

    public void model() {
        assert (this.nRows == this.nCols);
        this.buildUniqueDictionary();
        IVar.Var[][] r = this.array("r", this.size(this.nRows, this.nMaxRowWords), this.dom(this.range(-1, this.allWords.length)), "r[i][k] is the (index of) kth word at row i; -1 means 'no word'", new Types.TypeClass[0]);
        IVar.Var[][] c = this.array("c", this.size(this.nCols, this.nMaxColWords), this.dom(this.range(-1, this.allWords.length)), "c[j][k] is the (index of) kth word at col j; -1 means 'no word'", new Types.TypeClass[0]);
        IVar.Var[][] pr = this.array("pr", this.size(this.nRows, this.nMaxRowWords), this.dom(this.range(-1, this.nCols)), "pr[i][k] is the position (index of column) of the kth word at row i; -1 means 'no position' because 'no word'", new Types.TypeClass[0]);
        IVar.Var[][] pc = this.array("pc", this.size(this.nCols, this.nMaxColWords), this.dom(this.range(-1, this.nRows)), "pc[j][k] is the position (index of row) of the kth word at col j; -1 means 'no position' because 'no word'", new Types.TypeClass[0]);
        IVar.Var[][] sr = this.array("sr", this.size(this.nRows, this.nMaxRowWords), this.dom(this.range(this.nCols + 1)), "sr[i][k] is the size of the kth word at row i; 0 means 'no size' because 'no word'", new Types.TypeClass[0]);
        IVar.Var[][] sc = this.array("sc", this.size(this.nCols, this.nMaxColWords), this.dom(this.range(this.nRows + 1)), "sc[j][k] is the size of the kth word at col j; 0 means 'no size' because 'no word'", new Types.TypeClass[0]);
        IVar.Var[] jr = this.array("jr", this.size(this.nRows), this.dom(this.range((this.nRows + 1) / 2)), "jr[i] is the number of black cells (jokers) at row i", new Types.TypeClass[0]);
        IVar.Var[] jc = this.array("jc", this.size(this.nCols), this.dom(this.range((this.nCols + 1) / 2)), "jc[j] is the number of black cells (jokers) at col j", new Types.TypeClass[0]);
        IVar.Var[][] x = this.array("x", this.size(this.nRows, this.nCols), this.dom(this.range(letters.length + 1)), "x[i][j] is the (number of) letter at row i and col j; 26 stands for a black point", new Types.TypeClass[0]);
        IVar.Var[][] jx = this.array("jx", this.size(this.nRows, this.nCols), this.dom(0, new int[]{1}), "jx[i][j] is true iff the letter at row i and col j is a black cell (joker)", new Types.TypeClass[0]);
        int[][] sizesTable = (int[][])IntStream.range(-1, this.allWords.length).mapToObj(i -> this.tuple(i, new int[]{i == -1 ? 0 : this.allWords[i].length()})).toArray(x$0 -> new int[x$0][]);
        this.forall(this.range(this.nRows).range(this.nMaxRowWords), (i, k) -> this.extension((IVar.Var[])this.vars(r[i][k], (IVar)sr[i][k]), sizesTable)).note("linking row words with their sizes");
        this.forall(this.range(this.nCols).range(this.nMaxColWords), (j, k) -> this.extension((IVar.Var[])this.vars(c[j][k], (IVar)sc[j][k]), sizesTable)).note("linking col words with their sizes");
        int[][] succsTable = this.buildTableForTwoSuccessiveWords();
        this.forall(this.range(this.nRows).range(this.nMaxRowWords - 1), (i, k) -> this.extension((IVar.Var[])this.vars((IVar)pr[i][k], (IVar[])new IVar.Var[]{sr[i][k], pr[i][k + 1]}), succsTable)).note("linking row words and positions (according to their sizes)");
        this.forall(this.range(this.nCols).range(this.nMaxColWords - 1), (j, k) -> this.extension((IVar.Var[])this.vars((IVar)pc[j][k], (IVar[])new IVar.Var[]{sc[j][k], pc[j][k + 1]}), succsTable)).note("linking col words and positions (according to their sizes)");
        ((Problem)this.imp()).addCtr(new GridLazy((Problem)this.imp(), (Variable[][])r, (Variable[][])pr, (Variable[][])sr, (Variable[][])x), new Types.TypeClass[0]);
        this.allDifferent((IVar.Var[])this.vars(r, (IVar[][])c), this.exceptValues(IntStream.range(-1, this.oneLetterPositions.length).map(i -> i == -1 ? -1 : this.oneLetterPositions[i]).toArray()));
        this.forall(this.range(this.nRows).range(this.nCols), (i, j) -> this.equivalence(new Object[]{this.eq(new Object[]{x[i][j], 26}), this.eq(new Object[]{jx[i][j], 1})}));
        this.forall(this.range(this.nRows), i -> this.sum(jx[i], EQ, jr[i]));
        this.forall(this.range(this.nRows), j -> this.sum((IVar.Var[])this.columnOf(jx, j), EQ, jc[j]));
        this.forall(this.range(this.nRows), i -> this.sum((IVar.Var[])this.vars(sr[i], (IVar)jr[i]), EQ, this.nCols));
        this.forall(this.range(this.nCols), j -> this.sum((IVar.Var[])this.vars(sc[j], (IVar)jc[j]), EQ, this.nRows));
        this.exactly((IVar.Var[])this.vars((IVar[][])x), 26, 26);
        this.forall(this.range(this.nRows), i -> this.implication(this.eq(new Object[]{r[i][this.nMaxRowWords - 2], -1}), this.eq(new Object[]{r[i][this.nMaxRowWords - 1], -1})));
        this.forall(this.range(this.nCols), j -> this.implication(this.eq(new Object[]{c[j][this.nMaxColWords - 2], -1}), this.eq(new Object[]{c[j][this.nMaxColWords - 1], -1})));
    }

    public static void main(String[] args) {
        try (Scanner scanner = new Scanner(new File(args[0]));
             PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(args[0] + ".fmt")));){
            while (scanner.hasNextLine()) {
                out.println("\"" + scanner.nextLine() + "\", ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

