/*
 * Decompiled with CFR 0.152.
 */
package problems.g3_pattern;

import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.structures.Table;
import org.xcsp.modeler.api.ProblemAPI;

public class TravellingSalesman
implements ProblemAPI {
    int[][] distances;

    public void model() {
        int nCities = this.distances.length;
        IVar.Var[] c = this.array("c", this.size(nCities), this.dom(this.range(nCities)), "c[i] is the ith city of the tour", new Types.TypeClass[0]);
        IVar.Var[] d = this.array("d", this.size(nCities), this.dom(this.distances), "d[i] is the distance between the cities i and i+1", new Types.TypeClass[0]);
        this.allDifferent(c).note("Visiting each city only once");
        Table table = this.table().addFrom(this.range(nCities).range(nCities), (i, j) -> i == j ? null : this.tuple((int)i, new int[]{j, this.distances[i][j]}));
        this.forall(this.range(nCities), i -> this.extension((IVar.Var[])this.vars((IVar)c[i], (IVar[])new IVar.Var[]{c[(i + 1) % nCities], d[i]}), table)).note("computing the distance between any two successive cities in the tour");
        this.minimize(SUM, (IVar[])d);
    }
}

