/*
 * Decompiled with CFR 0.152.
 */
package problems.g3_pattern;

import java.util.ArrayList;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.enumerations.EnumerationCartesian;
import org.xcsp.modeler.api.ProblemAPI;

public class Kakuro
implements ProblemAPI {
    int nRows;
    int nCols;
    Clue[][] clues;

    private IVar.Var[] horScope(IVar.Var[][] x, int i, int j) {
        assert (this.clues[i][j].x > 0);
        ArrayList<IVar.Var> list = new ArrayList<IVar.Var>();
        for (int k = j + 1; k < this.nCols && this.clues[i][k].x == 0; ++k) {
            list.add(x[i][k]);
        }
        return list.toArray(new IVar.Var[0]);
    }

    private IVar.Var[] verScope(IVar.Var[][] x, int i, int j) {
        assert (this.clues[i][j].y > 0);
        ArrayList<IVar.Var> list = new ArrayList<IVar.Var>();
        for (int k = i + 1; k < this.nRows && this.clues[k][j].y == 0; ++k) {
            list.add(x[k][j]);
        }
        return list.toArray(new IVar.Var[0]);
    }

    public void model() {
        IVar.Var[][] x = this.array("x", this.size(this.nRows, this.nCols), (i, j) -> this.dom(this.rangeClosed(1, 9)).when(this.clues[i][j].x == 0 && this.clues[i][j].y == 0), "x[i][j] is the value put at row i and column j", new Types.TypeClass[0]);
        if (this.modelVariant("")) {
            this.forall(this.range(this.nRows).range(this.nCols), (i, j) -> {
                if (this.clues[i][j].x > 0) {
                    IVar.Var[] scp = this.horScope(x, i, j);
                    this.sum(scp, EQ, this.clues[i][j].x);
                    this.allDifferent(scp);
                }
            });
            this.forall(this.range(this.nRows).range(this.nCols), (i, j) -> {
                if (this.clues[i][j].y > 0) {
                    IVar.Var[] scp = this.verScope(x, i, j);
                    this.sum(scp, EQ, this.clues[i][j].y);
                    this.allDifferent(scp);
                }
            });
        }
        if (this.modelVariant("table")) {
            this.forall(this.range(this.nRows).range(this.nCols), (i, j) -> {
                if (this.clues[i][j].x > 0) {
                    IVar.Var[] scp = this.horScope(x, i, j);
                    this.extension(scp, EnumerationCartesian.tuplesWithDiffValuesSummingTo((int)this.clues[i][j].x, (int)9, (int)scp.length, (int)1));
                }
            });
            this.forall(this.range(this.nRows).range(this.nCols), (i, j) -> {
                if (this.clues[i][j].y > 0) {
                    IVar.Var[] scp = this.verScope(x, i, j);
                    this.extension(scp, EnumerationCartesian.tuplesWithDiffValuesSummingTo((int)this.clues[i][j].y, (int)9, (int)scp.length, (int)1));
                }
            });
        }
    }

    class Clue {
        int x;
        int y;

        Clue() {
        }
    }
}

