/*
 * Decompiled with CFR 0.152.
 */
package problems.g3_pattern;

import constraints.hard.extension.structures.SmartTuple;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;
import problem.Problem;

public class BusScheduling
implements ProblemAPI {
    int nTasks;
    int[][] shifts;

    public void model() {
        IVar.Var[] x;
        int nShifts = this.shifts.length;
        if (this.modelVariant("")) {
            x = this.array("x", this.size(nShifts), this.dom(0, new int[]{1}), "x[i] is 1 iff the ith shift is selected", new Types.TypeClass[0]);
            this.forall(this.range(this.nTasks), t -> this.exactly((IVar.Var[])this.select(x, i -> this.contains(this.shifts[i], t)), this.takingValue(1), 1)).note("Each task is covered by exactly one shift");
            this.minimize(SUM, (IVar[])x);
        }
        if (this.modelVariant("smt")) {
            x = this.array("x", this.size(this.nTasks), t -> this.dom(this.range(nShifts).select(i -> this.contains(this.shifts[i], t))), "x[t] is the shift selected to perform task t", new Types.TypeClass[0]);
            this.forall(this.range(nShifts), i -> {
                IVar.Var[] scp = (IVar.Var[])this.select(x, this.shifts[i]);
                SmartTuple st1 = new SmartTuple(this.repeat(i, this.shifts[i].length));
                SmartTuple st2 = new SmartTuple(Stream.of(scp).map(y -> this.ne(new Object[]{y, i})));
                ((Problem)this.imp()).smart((IVar[])scp, st1, st2);
            }).note("a shift is selected for a task iff it is slected for each task it covers");
            this.minimize(NVALUES, (IVar[])x);
        }
    }
}

