/*
 * Decompiled with CFR 0.152.
 */
package problems.g3_pattern;

import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.structures.Table;
import org.xcsp.modeler.api.ProblemAPI;
import problem.Problem;
import utility.Kit;

public class BinPacking
implements ProblemAPI {
    static final int NO = 0;
    int binCapacity;
    int[] itemWeights;

    private int[] occWeights(int length) {
        int[] occWeights = new int[length];
        occWeights[0] = 1;
        int currentWeight = 0;
        for (int i = 1; i < this.itemWeights.length; ++i) {
            if (this.itemWeights[i] != this.itemWeights[i - 1]) {
                // empty if block
            }
            int n = ++currentWeight;
            occWeights[n] = occWeights[n] + 1;
        }
        return occWeights;
    }

    private int nBins() {
        int nBins = 0;
        int currentBinLoad = 0;
        for (int i = 0; i < this.itemWeights.length; ++i) {
            if ((currentBinLoad += this.itemWeights[i]) <= this.binCapacity) continue;
            ++nBins;
            currentBinLoad = this.itemWeights[i];
        }
        return nBins;
    }

    private int nMaxItemsPerBin() {
        int sum = 0;
        for (int i = 0; i < this.itemWeights.length; ++i) {
            if ((sum += this.itemWeights[i]) <= this.binCapacity) continue;
            return i;
        }
        return -1;
    }

    public void model() {
        int[] distinctWeights = this.singleValuesIn(new Object[]{this.itemWeights});
        int[] occWeights = this.occWeights(distinctWeights.length);
        int nBins = this.nBins();
        int nMaxItemsPerBin = this.nMaxItemsPerBin();
        IVar.Var[][] w = this.array("w", this.size(nBins, nMaxItemsPerBin), this.dom(this.vals(new Object[]{0, distinctWeights})), "w[i][j] indicates the weight of the jth object put in the ith bin. It is 0 if there is no object at this place.", new Types.TypeClass[0]);
        if (this.modelVariant("")) {
            this.forall(this.range(nBins), i -> this.sum(w[i], LE, this.binCapacity)).note("not exceeding the capacity of each bin");
            this.forall(this.range(nBins), i -> this.decreasing(w[i])).note("items are stored decreasingly in each bin according to their weights");
        } else if (this.modelVariant("table")) {
            Table table = this.buildTable(nMaxItemsPerBin);
            this.forall(this.range(nBins), i -> this.extension(w[i], table));
        } else if (this.modelVariant("mdd")) {
            Table table = this.buildTable(nMaxItemsPerBin);
            this.forall(this.range(nBins), i -> ((Problem)this.imp()).mdd(w[i], table.toArray()));
        }
        this.cardinality((IVar.Var[])this.vars((IVar[][])w), this.vals(new Object[]{0, distinctWeights}), this.occurExactly(this.vals(new Object[]{nBins * nMaxItemsPerBin - this.itemWeights.length, occWeights}))).note("ensuring that each item is stored in a bin");
        this.decreasing(w).tag(new Types.TypeClass[]{SYMMETRY_BREAKING});
        this.maximize(SUM, this.treesFrom(this.range(nBins), i -> this.eq(new Object[]{w[i][0], 0}))).note("maximizing the number of unused bins");
    }

    private boolean recursiveBuild(Table table, int nbStored, int[] tmp, int i, int sum) {
        int j;
        if (table.size() > 200000000) {
            return false;
        }
        assert (sum + this.itemWeights[i] <= this.binCapacity);
        tmp[nbStored++] = this.itemWeights[i];
        sum += this.itemWeights[i];
        int[] tmp2 = (int[])tmp.clone();
        for (j = nbStored; j < tmp2.length; ++j) {
            tmp2[j] = 0;
        }
        table.add((int[][])new int[][]{tmp2});
        for (j = 0; j < i && sum + this.itemWeights[j] <= this.binCapacity; ++j) {
            if (j < i - 1 && this.itemWeights[j] == this.itemWeights[j + 1] || this.recursiveBuild(table, nbStored, tmp, j, sum)) continue;
            return false;
        }
        return true;
    }

    private Table build(int nMaxItemsPerBin) {
        Table table = new Table();
        int[] tmp = new int[nMaxItemsPerBin];
        table.add((int[][])new int[][]{(int[])tmp.clone()});
        for (int i = 0; i < this.itemWeights.length; ++i) {
            if (i < this.itemWeights.length - 1 && this.itemWeights[i] == this.itemWeights[i + 1] || this.recursiveBuild(table, 0, tmp, i, 0)) continue;
            Kit.exit("not possible to build the table with less than the specified number of tuples");
        }
        return table;
    }

    private Table buildTable(int nMaxItemsPerBin) {
        return this.build(nMaxItemsPerBin);
    }
}

