/*
 * Decompiled with CFR 0.152.
 */
package problems.g3_pattern;

import java.math.BigDecimal;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;

public class Auction
implements ProblemAPI {
    Bid[] bids;

    private int[] bidValues() {
        Object[] t = (BigDecimal[])Stream.of(this.bids).map(b -> new BigDecimal(b.value).stripTrailingZeros()).toArray(BigDecimal[]::new);
        int maxScale = Stream.of(t).filter(s -> s.scale() > 0).mapToInt(s -> s.scale()).max().orElse(0);
        return this.valuesFrom(t, b -> b.movePointRight(maxScale).intValueExact());
    }

    public void model() {
        int[] allItems = this.singleValuesFrom(this.bids, bid -> bid.items);
        int nBids = this.bids.length;
        int nItems = allItems.length;
        IVar.Var[] b = this.array("b", this.size(nBids), this.dom(0, new int[]{1}), "b[i] is 1 iff the ith bid is selected", new Types.TypeClass[0]);
        this.forall(this.range(nItems), i -> {
            int[] itemBids = this.select(this.range(nBids), j -> this.contains(this.bids[j].items, allItems[i]));
            if (itemBids.length > 1) {
                this.atMost1((IVar.Var[])this.select(b, itemBids), this.takingValue(1));
            }
        }).note("avoiding intersection of bids");
        this.maximize(SUM, (IVar[])b, this.weightedBy(this.bidValues())).note("maximizing summed value of selected bids");
    }

    class Bid {
        String value;
        int[] items;

        Bid() {
        }
    }
}

