/*
 * Decompiled with CFR 0.152.
 */
package problems.g2_academic;

import org.xcsp.common.IVar;
import org.xcsp.common.Range;
import org.xcsp.common.Types;
import org.xcsp.common.structures.Table;
import org.xcsp.modeler.api.ProblemAPI;

public class SportsScheduling
implements ProblemAPI {
    int nTeams;

    private int matchNumber(int team1, int team2) {
        int nPossibleMatches = (this.nTeams - 1) * this.nTeams / 2;
        return nPossibleMatches - (this.nTeams - team1) * (this.nTeams - team1 - 1) / 2 + (team2 - team1 - 1);
    }

    private Table matchs() {
        Table table = this.table();
        for (int team1 = 0; team1 < this.nTeams; ++team1) {
            for (int team2 = team1 + 1; team2 < this.nTeams; ++team2) {
                table.add(team1, new int[]{team2, this.matchNumber(team1, team2)});
            }
        }
        return table;
    }

    public void model() {
        int nWeeks = this.nTeams - 1;
        int nPeriods = this.nTeams / 2;
        int nPossibleMatches = (this.nTeams - 1) * this.nTeams / 2;
        Range allTeams = this.range(this.nTeams);
        IVar.Var[][] h = this.array("h", this.size(nWeeks, nPeriods), this.dom(allTeams), "h[w][p] is the home team at week w and period p", new Types.TypeClass[0]);
        IVar.Var[][] a = this.array("a", this.size(nWeeks, nPeriods), this.dom(allTeams), "a[w][p] is the away team at week w and period p", new Types.TypeClass[0]);
        IVar.Var[][] m = this.array("m", this.size(nWeeks, nPeriods), this.dom(this.range(nPossibleMatches)), "m[w][p] is the number of the match at week w and period p", new Types.TypeClass[0]);
        Table table = this.matchs();
        this.forall(this.range(nWeeks).range(nPeriods), (w, p) -> this.extension((IVar.Var[])this.vars((IVar)h[w][p], (IVar[])new IVar.Var[]{a[w][p], m[w][p]}), table)).note("linking variables through ternary table constraints");
        this.allDifferent(m).note("all matches are different (no team can play twice against another team)");
        this.forall(this.range(nWeeks), w -> this.allDifferent(new IVar.Var[][]{(IVar.Var[])this.vars(h[w], new Object[0]), a[w]})).note("each week, all teams are different (each team plays each week)");
        this.forall(this.range(nPeriods), p -> this.cardinality((IVar.Var[])this.vars(this.columnOf(h, p), (IVar[])this.columnOf(a, p)), allTeams, this.occursEachBetween(1, 2))).note("each team plays at most two times in each period");
        this.block(() -> {
            this.forall(this.range(nWeeks), w -> this.exactly1(m[w], this.takingValue(this.matchNumber(0, w + 1)))).note("the match '0 versus t' (with t strictly greater than 0) appears at week t-1");
            this.instantiation(m[0], this.takingValues(this.range(nPeriods).map(p -> this.matchNumber(2 * p, 2 * p + 1)))).note("the first week is set : 0 vs 1, 2 vs 3, 4 vs 5, etc.");
        }).tag(new Types.TypeClass[]{SYMMETRY_BREAKING});
        this.block(() -> {
            IVar.Var[] hd = this.array("hd", this.size(nPeriods), this.dom(this.range(this.nTeams)), "hd[p] is the home team for the dummy match of period p", new Types.TypeClass[0]);
            IVar.Var[] ad = this.array("ad", this.size(nPeriods), this.dom(this.range(this.nTeams)), "ad[p] is the away team for the dummy match of period p", new Types.TypeClass[0]);
            this.allDifferent((IVar.Var[])this.vars(hd, (IVar[])ad)).note("all teams are different in the dummy week");
            this.forall(this.range(nPeriods), p -> this.cardinality((IVar.Var[])this.vars(this.columnOf(h, p), new Object[]{this.columnOf(a, p), hd[p], ad[p]}), allTeams, this.occursEachExactly(2))).note("each team plays two times in each period");
            this.forall(this.range(nPeriods), p -> this.lessThan(hd[p], ad[p]));
        }).note("handling dummy week (variables and constraints)").tag(new String[]{"dummy-week"});
    }
}

