/*
 * Decompiled with CFR 0.152.
 */
package problems.g2_academic;

import org.xcsp.common.IVar;
import org.xcsp.common.Range;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;

public class MagicHexagon
implements ProblemAPI {
    int n;
    int s;

    private IVar.Var[] scopeForDiagonal(IVar.Var[][] x, int i, boolean right) {
        int d = x.length;
        int v1 = right ? Math.max(0, d / 2 - i) : Math.max(0, i - d / 2);
        int v2 = d / 2 - v1;
        Range r = this.range(d - Math.abs(d / 2 - i));
        return (IVar.Var[])this.variablesFrom(r, j -> x[j + v1][i - Math.max(0, right ? v2 - j : j - v2)]);
    }

    public void model() {
        int gap = 3 * this.n * this.n - 3 * this.n + 1;
        int sum = this.sumOf(this.range(this.s, this.s + gap));
        this.control(sum % (2 * this.n - 1) == 0, new Object[]{"No magic hexagon for order=" + this.n + " and start=" + this.s});
        int magic = sum / (2 * this.n - 1);
        int d = this.n + this.n - 1;
        IVar.Var[][] x = this.array("x", this.size(d, d), (i, j) -> this.dom(this.range(this.s, this.s + gap)).when(j < d - Math.abs(d / 2 - i)), "x represents the hexagon; on row x[i], only the first n - |n/2 - i| cells are useful (here, n = " + d + ").", new Types.TypeClass[0]);
        this.allDifferent(x);
        this.forall(this.range(d), i -> this.sum(x[i], EQ, magic)).note("all rows sum to the magic value");
        this.forall(this.range(d), i -> this.sum(this.scopeForDiagonal(x, i, true), EQ, magic)).note("all right-sloping diagonals sum to the magic value");
        this.forall(this.range(d), i -> this.sum(this.scopeForDiagonal(x, i, false), EQ, magic)).note("all left-sloping diagonals sum to the magic value");
        this.block(() -> {
            this.lessThan(x[0][0], x[0][this.n - 1]);
            this.lessThan(x[0][0], x[this.n - 1][d - 1]);
            this.lessThan(x[0][0], x[d - 1][this.n - 1]);
            this.lessThan(x[0][0], x[d - 1][0]);
            this.lessThan(x[0][0], x[this.n - 1][0]);
            this.lessThan(x[0][this.n - 1], x[this.n - 1][0]);
        }).tag(new Types.TypeClass[]{SYMMETRY_BREAKING});
    }
}

