/*
 * Decompiled with CFR 0.152.
 */
package problems.g2_academic;

import java.util.ArrayList;
import java.util.List;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.predicates.XNode;
import org.xcsp.modeler.api.ProblemAPI;

public class GolombRuler
implements ProblemAPI {
    int n;

    private List<XNode<IVar>> trees(IVar.Var[] x) {
        ArrayList<XNode<IVar>> list = new ArrayList<XNode<IVar>>();
        for (int i = 0; i < x.length; ++i) {
            for (int j = i + 1; j < x.length; ++j) {
                list.add((XNode<IVar>)this.abs(this.sub(x[i], x[j])));
            }
        }
        return list;
    }

    public void model() {
        int rulerLength = this.n * this.n + 1;
        IVar.Var[] x = this.array("x", this.size(this.n), this.dom(this.range(rulerLength)), "x[i] is the position of the ith tick", new Types.TypeClass[0]);
        if (this.modelVariant("")) {
            this.allDifferent(this.trees(x).stream()).note("all distances are different");
        } else if (this.modelVariant("dec")) {
            this.forall(this.range(this.n).range(this.n).range(this.n).range(this.n), (i, j, k, l) -> {
                if (i < j && i < k && k < l) {
                    this.different(new Object[]{this.dist(x[i], x[j]), this.dist(x[k], x[l])});
                }
            }).note("all distances are different");
        } else if (this.modelVariant("aux")) {
            IVar.Var[][] y = this.array("y", this.size(this.n, this.n), (i, j) -> this.dom(this.range(1, rulerLength)).when(i < j), "y[i][j] is the distance between x[i] and x[j], for i strictly less than j", new Types.TypeClass[0]);
            this.allDifferent(y).note("all distances are different");
            this.forall(this.range(this.n), i -> this.forall(this.range(i + 1, this.n), j -> this.equal(new Object[]{x[j], this.add(new Object[]{x[i], y[i][j]})}))).note("linking variables from both arrays");
            this.decisionVariables((IVar[])x);
        }
        this.block(() -> {
            this.equal(new Object[]{x[0], 0});
            this.strictlyIncreasing(x);
        }).tag(new Types.TypeClass[]{SYMMETRY_BREAKING});
        this.minimize(MAXIMUM, (IVar[])x).note("minimizing the position of the rightmost tick");
    }
}

