/*
 * Decompiled with CFR 0.152.
 */
package problems;

import java.util.Arrays;
import utility.Kit;

public class BorderArray {
    private char[][] m;
    private int cellWidth;
    private int cellHeight;

    public BorderArray(int nRows, int nColumns, int cellWidth, int cellHeight, char initialValue) {
        this.cellWidth = cellWidth;
        this.cellHeight = cellHeight;
        for (char[] t : this.m = new char[(1 + cellHeight) * nRows + 1][(1 + cellWidth) * nColumns + 1]) {
            Arrays.fill(t, initialValue);
        }
    }

    public BorderArray(int nRows, int nColumns, int cellWidth, int cellHeight) {
        this(nRows, nColumns, cellWidth, cellHeight, ' ');
    }

    public BorderArray(int nRows, int nColumns) {
        this(nRows, nColumns, 2, 1);
    }

    public void writeBorder(int left, int right, int top, int bottom) {
        int k;
        int j;
        for (j = left; j < right; ++j) {
            for (k = 1; k <= this.cellWidth; ++k) {
                this.m[(1 + this.cellHeight) * top][(1 + this.cellWidth) * j + k] = 45;
                this.m[(1 + this.cellHeight) * bottom][(1 + this.cellWidth) * j + k] = 45;
            }
        }
        for (j = top; j < bottom; ++j) {
            for (k = 1; k <= this.cellHeight; ++k) {
                this.m[(1 + this.cellHeight) * j + k][(1 + this.cellWidth) * left] = 124;
                this.m[(1 + this.cellHeight) * j + k][(1 + this.cellWidth) * right] = 124;
            }
        }
    }

    public void writeBorder(String left, String right, String top, String bottom) {
        this.writeBorder(Integer.parseInt(left), Integer.parseInt(right), Integer.parseInt(top), Integer.parseInt(bottom));
    }

    public void writeValue(int i, int j, int value) {
        Kit.control(value >= 0 && (double)value < Math.pow(10.0, this.cellWidth));
        int k = this.cellWidth;
        do {
            this.m[(1 + this.cellHeight) * i + 1][(1 + this.cellWidth) * j + k] = (char)(48 + value % 10);
            --k;
        } while ((value /= 10) > 0);
    }

    public String toString() {
        return Kit.join((Object)this.m, "\n", "");
    }
}

