/*
 * Decompiled with CFR 0.152.
 */
package problem.cliques;

import constraints.Constraint;
import utility.Kit;
import variables.Variable;

public class Clique
implements Comparable<Clique> {
    public final Constraint c1;
    public final Constraint c2;
    public final Constraint c3;
    public final Variable x;
    public final Variable y;
    public final Variable z;
    private int cliquePositionForC1 = -1;
    private int cliquePositionForC2 = -1;
    private int cliquePositionForC3 = -1;
    public Constraint wrk1;
    public Constraint wrk2;

    public Variable setWorkingSet(Variable firstVar, Variable secondVar) {
        if (this.x != firstVar && this.x != secondVar) {
            if (firstVar == this.y) {
                this.wrk1 = this.c1;
                this.wrk2 = this.c3;
            } else {
                this.wrk1 = this.c3;
                this.wrk2 = this.c1;
            }
            return this.x;
        }
        if (this.y != firstVar && this.y != secondVar) {
            if (firstVar == this.x) {
                this.wrk1 = this.c1;
                this.wrk2 = this.c2;
            } else {
                this.wrk1 = this.c2;
                this.wrk2 = this.c1;
            }
            return this.y;
        }
        if (firstVar == this.x) {
            this.wrk1 = this.c3;
            this.wrk2 = this.c2;
        } else {
            this.wrk1 = this.c2;
            this.wrk2 = this.c3;
        }
        return this.z;
    }

    public Constraint getEdgeConstraint(Constraint c, Variable w) {
        assert (c.involves(w));
        if (c == this.c1) {
            return w == this.x ? this.c3 : this.c2;
        }
        if (c == this.c2) {
            return w == this.y ? this.c1 : this.c3;
        }
        return w == this.x ? this.c1 : this.c2;
    }

    private boolean isInvolving(Constraint c) {
        return this.c1 == c || this.c2 == c || this.c3 == c;
    }

    private Variable getThirdVariableWrt(Constraint c) {
        assert (this.isInvolving(c));
        return c == this.c1 ? this.z : (c == this.c2 ? this.x : this.y);
    }

    @Override
    public int compareTo(Clique clique) {
        Constraint c = clique.isInvolving(this.c1) ? this.c1 : (clique.isInvolving(this.c2) ? this.c2 : (clique.isInvolving(this.c3) ? this.c3 : null));
        return this.getThirdVariableWrt((Constraint)c).dom.size() - clique.getThirdVariableWrt((Constraint)c).dom.size();
    }

    public Clique(Constraint c1, Constraint c2, Constraint c3) {
        Kit.control(c1.scp.length == 2 && c2.scp.length == 2 && c3.scp.length == 2);
        this.c1 = c1;
        this.c2 = c2;
        this.c3 = c3;
        this.x = c3.involves(c1.scp[0]) ? c1.scp[0] : c1.scp[1];
        this.y = c2.involves(c1.scp[0]) ? c1.scp[0] : c1.scp[1];
        this.z = c2.involves(c3.scp[0]) ? c3.scp[0] : c3.scp[1];
        Kit.control(this.controlClique());
    }

    public void setPosition(Constraint c, int position) {
        assert (this.isInvolving(c));
        if (this.c1 == c) {
            this.cliquePositionForC1 = position;
        } else if (this.c2 == c) {
            this.cliquePositionForC2 = position;
        } else {
            this.cliquePositionForC3 = position;
        }
    }

    public int getPositionOf(Constraint c) {
        assert (this.isInvolving(c));
        return this.c1 == c ? this.cliquePositionForC1 : (this.c2 == c ? this.cliquePositionForC2 : this.cliquePositionForC3);
    }

    public String toString() {
        return "(" + this.c1 + "," + this.c2 + "," + this.c3 + ")";
    }

    private boolean controlClique() {
        return this.x != this.y && this.x != this.z && this.y != this.z && this.c1.involves(this.x) && this.c1.involves(this.y) && this.c2.involves(this.y) && this.c2.involves(this.z) && this.c3.involves(this.x) && this.c3.involves(this.z);
    }
}

