/*
 * Decompiled with CFR 0.152.
 */
package problem;

import constraints.Constraint;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.w3c.dom.Document;
import problem.Compiler3Abscon;
import problem.Problem;
import utility.Kit;
import variables.Variable;

public final class Subproblem {
    public final Problem pb;
    private final boolean[] presentVars;
    private final boolean[] presentCtrs;

    public boolean isPresentVar(int i) {
        return this.presentVars == null || this.presentVars[i];
    }

    public boolean isPresentCtr(int i) {
        return this.presentCtrs == null || this.presentCtrs[i];
    }

    public int nPresentVars() {
        return this.presentVars == null ? this.pb.variables.length : Kit.countIn(true, this.presentVars);
    }

    public int nPresentCtrs() {
        return this.presentCtrs == null ? this.pb.constraints.length : Kit.countIn(true, this.presentCtrs);
    }

    public boolean isFullProblem() {
        return this.nPresentVars() == this.pb.variables.length && this.nPresentCtrs() == this.pb.constraints.length;
    }

    private static boolean[] buildPresentConstraintsFrom(Problem pb, boolean[] presentVars, boolean removeDisconnectedVars) {
        boolean[] presentCtrs = new boolean[pb.constraints.length];
        boolean[] connectedVars = removeDisconnectedVars ? new boolean[presentVars.length] : null;
        for (int i = 0; i < presentCtrs.length; ++i) {
            boolean bl = presentCtrs[i] = !Constraint.isInvolvingAbsentVar(pb.constraints[i], presentVars);
            if (!removeDisconnectedVars || !presentCtrs[i]) continue;
            for (Variable x : pb.constraints[i].scp) {
                connectedVars[x.num] = true;
            }
        }
        if (removeDisconnectedVars) {
            Kit.and(presentVars, connectedVars);
        }
        return presentCtrs;
    }

    private static boolean[] buildPresentVariablesFrom(Problem pb, boolean[] presentCtrs) {
        return Kit.toPrimitive(Stream.of(pb.variables).map(x -> Variable.isInducedBy(x, presentCtrs)));
    }

    public Subproblem(Problem pb, boolean[] presentVars, boolean[] presentCtrs) {
        this.pb = pb;
        this.presentVars = presentVars;
        this.presentCtrs = presentCtrs;
        assert (this.controlCoherence());
    }

    public Subproblem(Problem pb, boolean[] presentVars, boolean removeDisconnectedVars) {
        this(pb, presentVars, Subproblem.buildPresentConstraintsFrom(pb, presentVars, removeDisconnectedVars));
    }

    public Subproblem(Problem pb, boolean[] presentCtrs) {
        this(pb, Subproblem.buildPresentVariablesFrom(pb, presentCtrs), presentCtrs);
    }

    public Subproblem(Problem pb) {
        this(pb, null, null);
    }

    public Document documentXCSP() {
        return new Compiler3Abscon(this).buildDocument();
    }

    private boolean controlCoherence() {
        if (this.presentVars == null && this.presentCtrs == null) {
            return true;
        }
        if (this.presentVars == null || this.presentCtrs == null) {
            return false;
        }
        if (this.pb.variables.length != this.presentVars.length || this.pb.constraints.length != this.presentCtrs.length) {
            return false;
        }
        IntStream.range(0, this.presentCtrs.length).forEach(i -> Kit.control(!this.presentCtrs[i] || !Constraint.isInvolvingAbsentVar(this.pb.constraints[i], this.presentVars), () -> "constraint " + this.pb.constraints[i] + " involving one absent variable "));
        IntStream.range(0, this.presentVars.length).forEach(i -> Kit.control(!this.presentVars[i] || !Variable.isInducedBy(this.pb.variables[i], this.presentCtrs), () -> "variable " + this.pb.variables[i] + " involving in no present constraint"));
        return true;
    }
}

