/*
 * Decompiled with CFR 0.152.
 */
package problem;

import constraints.Constraint;
import constraints.CtrHard;
import constraints.CtrRaw;
import constraints.hard.CtrExtension;
import constraints.hard.CtrGlobal;
import constraints.hard.CtrHardFalse;
import constraints.hard.CtrHardTrue;
import constraints.hard.CtrIntension;
import constraints.hard.extension.CtrExtensionMDD;
import constraints.hard.extension.CtrExtensionOrMDD;
import constraints.hard.extension.CtrExtensionSmart;
import constraints.hard.extension.structures.MDDCD;
import constraints.hard.extension.structures.SmartTuple;
import constraints.hard.global.AllDifferent;
import constraints.hard.global.AllDifferentBound;
import constraints.hard.global.AllDifferentCounting;
import constraints.hard.global.AllDifferentExceptWeak;
import constraints.hard.global.AllDifferentPermutation;
import constraints.hard.global.AllDifferentWeak;
import constraints.hard.global.AllEqual;
import constraints.hard.global.Among;
import constraints.hard.global.CardinalityConstant;
import constraints.hard.global.Circuit;
import constraints.hard.global.Count;
import constraints.hard.global.DistinctVectorsK;
import constraints.hard.global.Element;
import constraints.hard.global.ElementMatrix;
import constraints.hard.global.ExactlyKVariable;
import constraints.hard.global.Extremum;
import constraints.hard.global.HammingProximityConstant;
import constraints.hard.global.Lexicographic;
import constraints.hard.global.NValues;
import constraints.hard.global.NValuesVar;
import constraints.hard.global.NotAllEqual;
import constraints.hard.global.Ordered;
import constraints.hard.global.SumScalarBoolean;
import constraints.hard.global.SumSimple;
import constraints.hard.global.SumWeighted;
import constraints.hard.primitive.Disjonctive;
import constraints.hard.primitive.GE;
import constraints.hard.primitive.GT;
import constraints.hard.primitive.LE;
import constraints.hard.primitive.LT;
import constraints.hard.primitive.NE;
import constraints.soft.extension.CtrSoftExtension;
import executables.Integration;
import executables.Resolution;
import heuristics.values.HeuristicValues;
import heuristics.values.direct.First;
import heuristics.values.direct.Last;
import heuristics.values.direct.Values;
import java.io.File;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import objectives.Obj;
import objectives.ObjMaximum;
import objectives.ObjMinimum;
import objectives.ObjVar;
import objectives.OptimizationCompatible;
import objectives.OptimizationPilot;
import objectives.OptimizationPilotBasic;
import org.w3c.dom.Document;
import org.xcsp.common.Condition;
import org.xcsp.common.IVar;
import org.xcsp.common.Range;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.domains.Domains;
import org.xcsp.common.domains.Values;
import org.xcsp.common.enumerations.EnumerationCartesian;
import org.xcsp.common.predicates.EvaluationManager;
import org.xcsp.common.predicates.XNode;
import org.xcsp.common.predicates.XNodeLeaf;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.common.structures.Automaton;
import org.xcsp.common.structures.Table;
import org.xcsp.common.structures.Transition;
import org.xcsp.modeler.api.ProblemAPI;
import org.xcsp.modeler.definitions.ICtr;
import org.xcsp.modeler.definitions.IObj;
import org.xcsp.modeler.entities.CtrEntities;
import org.xcsp.modeler.entities.ObjEntities;
import org.xcsp.modeler.entities.VarEntities;
import org.xcsp.modeler.implementation.ProblemIMP;
import problem.Compiler3Abscon;
import problem.IdentificationAllDifferent;
import problem.IdentificationAutomorphism;
import problem.ProblemStuff;
import problem.Subproblem;
import problem.Symbolic;
import problems.tran.WcspReader;
import propagation.order1.PropagationForward;
import propagation.order2.path.PC8;
import search.Solver;
import search.backtrack.localBranching.LBAtLeastEqual;
import search.backtrack.localBranching.LocalBranchingConstraints;
import utility.Enums;
import utility.Kit;
import utility.Reflector;
import utility.exceptions.MissingImplementationException;
import utility.exceptions.UnreachableCodeException;
import utility.observers.ObserverConstructionProblem;
import utility.observers.ObserverConstructionSolver;
import utility.observers.ObserverDomainReduction;
import variables.Variable;
import variables.VariableInteger;
import variables.VariableSymbolic;
import variables.domains.Domain;

public class Problem
extends ProblemIMP
implements ObserverConstructionProblem,
ObserverConstructionSolver {
    public static final Boolean DONT_KNOW = null;
    public static final Boolean STARRED = Boolean.TRUE;
    public static final Boolean UNSTARRED = Boolean.FALSE;
    public static final String AUXILIARY_VARIABLE_PREFIX = "aux_";
    public Resolution rs;
    public Types.TypeFramework framework;
    public Solver solver;
    public Variable[] variables;
    public Constraint[] constraints;
    public OptimizationPilot optimizationPilot;
    public Variable[] priorityVars = Variable.EMPTY_ARRAY;
    public int nStrictPriorityVars;
    public ProblemStuff stuff;
    public Symbolic symbolic;
    public int nTuplesRemoved;
    public int nValuesRemoved;
    public final List<List<int[]>> symmetryGroupGenerators = new ArrayList<List<int[]>>();
    public final Collection<ObserverDomainReduction> observersDomainReduction = new ArrayList<ObserverDomainReduction>();
    public LocalBranchingConstraints localBranchingConstraints;
    public final List<int[]> domainTypes = new ArrayList<int[]>();
    public List<String> undisplay = new ArrayList<String>();
    public final Map<String, Variable> mapForVars = new HashMap<String, Variable>();
    private ProblemIMP.Converter converter = new ProblemIMP.Converter(){

        public StringBuilder signatureFor(IVar.Var[] scp) {
            return Variable.signatureFor((Variable[])scp);
        }

        public int[][] domValuesOf(IVar.Var[] scp) {
            return Variable.initDomainValues((Variable[])scp);
        }

        public Utilities.ModifiableBoolean mode() {
            Enums.EExportMode exportMode = Enums.EExportMode.EXTENSION;
            return new Utilities.ModifiableBoolean(exportMode != Enums.EExportMode.EXTENSION_SUPPORTS && exportMode != Enums.EExportMode.EXTENSION_CONFLICTS ? null : Boolean.valueOf(exportMode == Enums.EExportMode.EXTENSION_SUPPORTS));
        }
    };
    public static final String vfsComment = "Either you set -f=cop or you set -f=csp together with -vfs=v where v is an integer value forcing the value of the objective.";

    @Override
    public void onConstructionProblemFinished() {
        block12: {
            Kit.control(Variable.areNumsNormalized(this.variables) && Constraint.areNumsNormalized(this.constraints), () -> "Non normalized nums in the problem");
            for (Variable x : this.variables) {
                x.dom.finalizeConstructionWith(this.variables.length + 1);
                Kit.control(Stream.of(x.ctrs).noneMatch(c -> c.num == -1), () -> "Pb with a non posted constraint ");
            }
            HashSet<String> allIds = new HashSet<String>();
            for (Variable x : this.variables) {
                String name = x.id();
                Kit.control(!allIds.contains(name));
                allIds.add(name);
            }
            Kit.control((this.framework == Types.TypeFramework.COP || this.framework == Types.TypeFramework.WCSP) == (this.optimizationPilot != null), () -> "Not a COP " + this.framework + " " + (this.optimizationPilot == null));
            if (this.rs.cp.experimental.save4Baudouin) {
                Stream.of(this.constraints).forEach(c -> ((CtrHard)c).save4Baudouin());
            }
            if (this.priorityVars.length == 0 && this.annotations.decision != null) {
                this.priorityVars = (Variable[])this.annotations.decision;
            }
            if (this.framework != Types.TypeFramework.COP || !this.rs.cp.valh.optValHeuristic) break block12;
            Variable[] scp = ((CtrGlobal)((Object)this.optimizationPilot.ctr)).scp;
            if (this.optimizationPilot.ctr instanceof SumSimple || this.optimizationPilot.ctr instanceof Obj) {
                for (Variable x : scp) {
                    x.heuristicVal = this.optimizationPilot.minimization ? new First(x, false) : new Last(x, false);
                }
            } else if (this.optimizationPilot.ctr instanceof SumWeighted) {
                int[] coeffs = ((SumWeighted)((Object)this.optimizationPilot.ctr)).coeffs;
                for (int i = 0; i < scp.length; ++i) {
                    boolean f = this.optimizationPilot.minimization && coeffs[i] >= 0 || !this.optimizationPilot.minimization && coeffs[i] < 0;
                    scp[i].heuristicVal = f ? new First(scp[i], false) : new Last(scp[i], false);
                }
            } else {
                assert (this.optimizationPilot.ctr instanceof NValues.NValuesLE);
                for (Variable x : scp) {
                    x.heuristicVal = new Values(x, false, scp);
                }
            }
        }
    }

    @Override
    public void onConstructionSolverFinished() {
        Stream.of(this.variables).forEach(x -> x.dom.setSolver(this.solver));
    }

    public final Range range(int length) {
        return new Range(length);
    }

    public final String name() {
        String s = super.name();
        return s.matches("XCSP[23]-.*") ? s.substring(6) : s;
    }

    public final void modifyAskedParameter(int index, Object value) {
        this.parameters.set(index, new AbstractMap.SimpleEntry(value, ((AbstractMap.SimpleEntry)this.parameters.get(index)).getValue()));
    }

    public int askInt(String message, Predicate<Integer> control, IntFunction<String> format, boolean incrementWhenSeries) {
        Integer v = Utilities.toInteger((String)this.ask(message));
        Utilities.control((v != null ? 1 : 0) != 0, (String)("Value " + v + " for " + message + " is not valid (not an integer)"));
        v = v + (incrementWhenSeries ? this.rs.instanceNumber : 0);
        Utilities.control((control == null || control.test(v) ? 1 : 0) != 0, (String)("Value " + v + " for " + message + " does not respect the control " + control));
        return (Integer)this.addParameter(v, format == null ? null : format.apply(v));
    }

    public int askInt(String message, Predicate<Integer> control, String format, boolean incrementWhenSeries) {
        return this.askInt(message, control, (int v) -> format, incrementWhenSeries);
    }

    public int askInt(String message, Predicate<Integer> control, boolean incrementWhenSeries) {
        return this.askInt(message, control, (IntFunction<String>)null, incrementWhenSeries);
    }

    public int askInt(String message, String format, boolean incrementWhenSeries) {
        return this.askInt(message, null, format, incrementWhenSeries);
    }

    public int askInt(String message, boolean incrementWhenSeries) {
        return this.askInt(message, null, (IntFunction<String>)null, incrementWhenSeries);
    }

    public final IVar.Var[][] project3(IVar.Var[][][] m) {
        return (IVar.Var[][])IntStream.range(0, m[0][0].length).mapToObj(i -> (IVar.Var[])this.api.select((Object[][][])m, (w, g, p) -> p == i)).toArray(x$0 -> new IVar.Var[x$0][]);
    }

    public void removeCtr(Constraint c) {
        Kit.control(this.constraints == null, () -> "too late");
        this.stuff.collectedCtrsAtInit.remove(c);
        Stream.of(c.scp).forEach(x -> x.collectedCtrs.remove(c));
        CtrEntities.CtrAlone ca = (CtrEntities.CtrAlone)this.ctrEntities.ctrToCtrAlone.get(c);
        this.ctrEntities.allEntities.remove(ca);
        this.ctrEntities.ctrToCtrAlone.remove(c);
    }

    public final CtrEntities.CtrAlone addCtr(Constraint c, Types.TypeClass ... classes) {
        if (this.stuff.collectedCtrsAtInit.isEmpty()) {
            System.out.print("  Loading constraints...");
        }
        if (this.rs.cp.verbose > 1 && !this.rs.cp.competitionMode) {
            int n = this.stuff.collectedCtrsAtInit.size();
            int nDigits = n < 10 ? 1 : (n < 100 ? 2 : (n < 1000 ? 3 : (n < 10000 ? 4 : (n < 100000 ? 5 : (n < 1000000 ? 6 : 7)))));
            IntStream.range(0, nDigits).forEach(i -> System.out.print("\b"));
            System.out.print(n + 1 + "");
        }
        c.num = this.stuff.addCollectedConstraint(c);
        CtrEntities ctrEntities = this.ctrEntities;
        ctrEntities.getClass();
        return new CtrEntities.CtrAlone(ctrEntities, (ICtr)c, classes);
    }

    public void annotateVarhStatic(Variable[] vars) {
        if (this.rs.cp.general.enableAnnotations) {
            this.priorityVars = vars;
            this.nStrictPriorityVars = this.priorityVars.length;
        }
    }

    public void annotateValh(IVar.Var[] vars, Class<? extends HeuristicValues> clazz) {
        if (this.rs.cp.general.enableAnnotations) {
            Stream.of(vars).forEach(x -> {
                ((Variable)x).heuristicVal = Reflector.buildObject(clazz.getSimpleName(), HeuristicValues.class, x, null);
            });
        }
    }

    public void resetWdeg() {
        Kit.log.info("reset of weighted degrees");
        Stream.of(this.variables).forEach(x -> x.resetWdeg());
        Stream.of(this.constraints).forEach(c -> c.resetWdeg());
    }

    public void reset(boolean preserveWeighedDegrees) {
        Stream.of(this.variables).forEach(x -> x.reset(preserveWeighedDegrees));
        Stream.of(this.constraints).forEach(c -> c.reset(preserveWeighedDegrees));
        Stream.of(this.constraints).forEach(c -> {
            c.ignored = false;
        });
        this.nValuesRemoved = 0;
        this.nTuplesRemoved = 0;
        if (this.rs.cp.verbose > 0) {
            Kit.log.info("Reset of problem instance");
        }
    }

    public void reduceTo(boolean[] presentVariables, boolean[] presentConstraints, boolean preserveWeighedDegrees) {
        Kit.control(this.symmetryGroupGenerators.size() == 0 && presentVariables.length == this.variables.length && presentConstraints.length == this.constraints.length);
        assert (Variable.firstWipeoutVariableIn(this.variables) == null && Variable.areNumsNormalized(this.variables) && Constraint.areNumsNormalized(this.constraints));
        for (Variable var : this.priorityVars = (Variable[])IntStream.range(0, this.variables.length).filter(i -> presentVariables[i]).mapToObj(i -> this.variables[i]).toArray(Variable[]::new)) {
            var.reset(preserveWeighedDegrees);
        }
        for (int i2 = 0; i2 < this.constraints.length; ++i2) {
            this.constraints[i2].ignored = !presentConstraints[i2];
            if (this.constraints[i2].ignored) continue;
            this.constraints[i2].reset(preserveWeighedDegrees);
        }
        this.nValuesRemoved = 0;
        this.nTuplesRemoved = 0;
        if (this.rs.cp.verbose >= 0) {
            Kit.log.info("Reduction to (#V=" + this.priorityVars.length + ",#C=" + Kit.countIn(true, presentConstraints) + ")");
        }
    }

    private CtrEntities.CtrAlone buildCtrTrue(Variable x, Variable y) {
        return (CtrEntities.CtrAlone)(x instanceof VariableInteger ? this.api.ctrTrue((IVar.Var[])new VariableInteger[]{(VariableInteger)x, (VariableInteger)y}) : this.api.ctrTrue((IVar.VarSymbolic[])new VariableSymbolic[]{(VariableSymbolic)x, (VariableSymbolic)y}));
    }

    public final Constraint addUniversalConstraintDynamicallyBetween(Variable x, Variable y) {
        assert (x.getClass() == y.getClass());
        assert (!Stream.of(y.ctrs).anyMatch(c -> c.scp.length == 2 && c.involves(x)));
        assert (this.solver.propagation instanceof PropagationForward);
        CtrEntities.CtrAlone ca = this.extension(this.vars(new Object[]{x, y}), new int[0][], false, DONT_KNOW);
        Constraint c2 = (Constraint)ca.ctr;
        c2.cloneStructures(false);
        this.constraints = this.stuff.collectedCtrsAtInit.toArray(new Constraint[this.stuff.collectedCtrsAtInit.size()]);
        x.whenFinishedProblemConstruction();
        y.whenFinishedProblemConstruction();
        if (x.isAssigned()) {
            c2.doPastVariable(x);
        }
        if (y.isAssigned()) {
            c2.doPastVariable(y);
        }
        return c2;
    }

    private void makeGraphComplete() {
        if (!this.rs.cp.problem.completeGraph || !this.rs.cp.propagating.clazz.equals(PC8.class.getSimpleName())) {
            return;
        }
        int sizeBefore = this.stuff.collectedCtrsAtInit.size();
        IntStream.range(0, this.variables.length).forEach(i -> IntStream.range(i + 1, this.variables.length).forEach(j -> {
            if (!this.stuff.collectedCtrsAtInit.stream().anyMatch(c -> c.scp.length == 2 && c.involves(this.variables[i], this.variables[j]))) {
                this.buildCtrTrue(this.variables[i], this.variables[j]);
            }
        }));
        this.stuff.nAddedCtrs += this.stuff.collectedCtrsAtInit.size() - sizeBefore;
    }

    private void buildSymmetries() {
        if (this.rs.cp.symmetryBreaking) {
            int nBefore = this.stuff.collectedCtrsAtInit.size();
            for (Constraint c : this.stuff.collectedCtrsAtInit) {
                if (Constraint.getSymmetryMatching(c.key) != null) continue;
                Constraint.putSymmetryMatching(c.key, c.defineSymmetryMatching());
            }
            IdentificationAutomorphism automorphismIdentification = new IdentificationAutomorphism(this);
            for (Constraint c : automorphismIdentification.buildVariableSymmetriesFor(this.variables, this.stuff.collectedCtrsAtInit)) {
                this.addCtr(c, new Types.TypeClass[0]);
            }
            this.stuff.addToMapForAutomorphismIdentification(automorphismIdentification);
            this.symmetryGroupGenerators.addAll(automorphismIdentification.getGenerators());
            this.stuff.nAddedCtrs += this.stuff.collectedCtrsAtInit.size() - nBefore;
        }
    }

    private void inferAllDifferents() {
        if (this.rs.cp.constraints.inferAllDifferent) {
            this.stuff.addToMapForAllDifferentIdentification(new IdentificationAllDifferent(this));
        }
    }

    public final void storeConstraintsToArray() {
        this.makeGraphComplete();
        this.buildSymmetries();
        this.inferAllDifferents();
        if (this.rs.cp.lb.enabled) {
            this.localBranchingConstraints = this.symbolic != null ? Reflector.buildObject(LBAtLeastEqual.class.getSimpleName(), LocalBranchingConstraints.class, this) : Reflector.buildObject(this.rs.cp.lb.neighborhood, LocalBranchingConstraints.class, this);
        }
        this.constraints = this.stuff.collectedCtrsAtInit.toArray(new Constraint[0]);
        for (Variable var : this.variables) {
            var.whenFinishedProblemConstruction();
            this.stuff.varDegrees.add(var.staticDegree());
        }
        assert (Variable.areNumsNormalized(this.variables));
        this.rs.clearMapsUsedByConstraints();
    }

    public Variable findVarWithNumOrId(Object o) {
        if (o instanceof Integer) {
            int num = (Integer)o;
            Kit.control(0 <= num && num < this.variables.length, () -> num + " is not a valid variable num. Check your configuration parameters -ins -pr1 or -pr2.");
            Kit.control(this.variables[num].num != -2, () -> "You cannot use the discarded variable whose (initial) num is " + num + ". Check your configuration parameters -ins -pr1 or -pr2.");
            return this.variables[num];
        }
        Variable var = this.mapForVars.get(o);
        Kit.control(var != null, () -> "The variable " + o + " cannot be found. Check your configuration parameters -ins -pr1 or -pr2.");
        Kit.control(var.num != -2, () -> "You cannot use the discarded variable " + o + ". Check your configuration parameters. -ins -pr1 or -pr2.");
        return var;
    }

    private final void addUnaryConstraintsOfUserInstantiation() {
        Kit.control(this.rs.cp.cpv.instantiatedVars.length == this.rs.cp.cpv.instantiatedVals.length, () -> "In the given instantiation, the number of variables (ids or names) is different from the number of values.");
        boolean removeValues = true;
        for (int i = 0; i < this.rs.cp.cpv.instantiatedVars.length; ++i) {
            Variable x = this.findVarWithNumOrId(this.rs.cp.cpv.instantiatedVars[i]);
            int v = this.rs.cp.cpv.instantiatedVals[i];
            Kit.control(x.dom.toPresentIdx(v) != -1, () -> "Value " + v + " not present in domain of " + x + ". Check  -ins.");
            if (removeValues) {
                x.dom.reduceToValueAtConstructionTime(v);
                continue;
            }
            this.equal(new Object[]{x, v});
        }
    }

    private final void reduceDomainsOfIsolatedVariables() {
        boolean reduceIsolatedVars = this.rs.cp.variables.reduceIsolatedVars && this.rs.cp.general.nSearchedSolutions == 1L && !this.rs.cp.export && !this.rs.cp.symmetryBreaking && this.rs.cp.framework == Types.TypeFramework.CSP;
        ArrayList<Variable> isolatedVars = new ArrayList<Variable>();
        ArrayList<Variable> fixedVars = new ArrayList<Variable>();
        int nRemovedValues = 0;
        for (Variable x : this.stuff.collectedVarsAtInit) {
            if (x.ctrs.length == 0) {
                isolatedVars.add(x);
                if (reduceIsolatedVars) {
                    nRemovedValues += x.dom.size() - 1;
                    x.dom.reduceToValueAtConstructionTime(x.dom.firstValue());
                }
            }
            if (x.dom.size() != 1) continue;
            fixedVars.add(x);
        }
        if (isolatedVars.size() > 0) {
            this.stuff.nIsolatedVars += isolatedVars.size();
            Kit.log.info("Isolated variables : " + Kit.join(isolatedVars, new String[0]));
            Kit.log.info("Nb values removed due to isolated variables : " + nRemovedValues + "\n");
        }
        if (fixedVars.size() > 0) {
            this.stuff.nFixedVars += fixedVars.size();
            Kit.log.info("Fixed variables : " + (fixedVars.size() <= 100 ? Kit.join(fixedVars, new String[0]) : "more than 100") + "\n");
        }
    }

    private final void updateConflictsStructuresIfReducedDomains() {
        if (this.nValuesRemoved > 0) {
            int[] domainFrontiers = Kit.repeat(-1, this.variables.length);
            for (Constraint ctr : this.constraints) {
                if (!(ctr instanceof CtrHard)) continue;
                ((CtrHard)ctr).updateConflictsStructures(domainFrontiers);
            }
        }
    }

    public static int[][] buildTable(Variable[] scp, CtrHard ... ctrs) {
        int[][] vaps = (int[][])Stream.of(ctrs).map(c -> IntStream.range(0, c.scp.length).map(i -> Utilities.indexOf((Object)c.scp[i], (Object[])scp)).toArray()).toArray(x$0 -> new int[x$0][]);
        int[][] tmps = (int[][])Stream.of(ctrs).map(c -> c.tupleManager.localTuple).toArray(x$0 -> new int[x$0][]);
        ArrayList<int[]> list = new ArrayList<int[]>();
        EnumerationCartesian ec = new EnumerationCartesian(Variable.domSizeArrayOf(scp, true));
        while (ec.hasNext()) {
            int[] tuple = ec.next();
            boolean inconsistent = false;
            for (int i2 = 0; !inconsistent && i2 < ctrs.length; ++i2) {
                int[] vap = vaps[i2];
                int[] t = tmps[i2];
                IntStream.range(0, t.length).forEach(j -> {
                    t[j] = tuple[vap[j]];
                });
                if (ctrs[i2].checkIndexes(t)) continue;
                inconsistent = true;
            }
            if (inconsistent) continue;
            list.add(IntStream.range(0, scp.length).map(i -> scp[i].dom.toVal(tuple[i])).toArray());
        }
        return Kit.intArray2D(list);
    }

    public int[][] buildTable(CtrHard ... ctrs) {
        return Problem.buildTable((Variable[])this.distinctSorted(this.vars(Stream.of(ctrs).map(c -> c.scp).toArray())), ctrs);
    }

    public Problem(ProblemAPI api, String modelVariant, String data, String dataFormat, boolean dataSaving, String[] argsForPb, Resolution rs) {
        super(api, modelVariant, argsForPb);
        this.rs = rs;
        rs.problem = this;
        rs.observersConstructionProblem.add(this);
        Kit.control(rs.observersConstructionSolver.size() == 0, () -> "Must be the first in the list " + rs.observersConstructionSolver.size());
        rs.observersConstructionSolver.add(this);
        this.framework = rs.cp.framework;
        this.stuff = new ProblemStuff(this);
        this.loadDataAndModel(data, dataFormat, dataSaving);
        this.variables = this.stuff.collectedVarsAtInit.toArray(new Variable[this.stuff.collectedVarsAtInit.size()]);
        this.addUnaryConstraintsOfUserInstantiation();
        this.storeConstraintsToArray();
        if (this.framework == Types.TypeFramework.WCSP) {
            this.optimizationPilot = new OptimizationPilotBasic(this, "c0");
        } else if (Solver.class.getSimpleName().equals(rs.cp.solving.clazz)) {
            this.optimizationPilot = new OptimizationPilotBasic(this, "#violatedConstraints");
        }
        rs.output.printAfterBuildingProblem();
        this.reduceDomainsOfIsolatedVariables();
        this.updateConflictsStructuresIfReducedDomains();
    }

    public final void display() {
        if (this.rs.cp.verbose >= 2) {
            Kit.log.finer("\nProblem " + this.name());
            Stream.of(this.variables).forEach(x -> x.display(this.rs.cp.verbose == 3));
            Stream.of(this.constraints).forEach(c -> c.display(this.rs.cp.verbose == 3));
        }
    }

    public void undisplay(String ... names) {
        this.undisplay = Arrays.asList(names);
    }

    public String lastSolutionX(String PREFIX) {
        String s = "<instantiation id='sol" + this.solver.solManager.nSolutionsFound + "' type='solution'" + (this.framework != Types.TypeFramework.CSP ? " cost='" + this.solver.solManager.bestBound + "'" : "") + ">";
        String list = " " + this.varEntities.allEntities.stream().filter(va -> !this.undisplay.contains(va.id) && !va.id.startsWith(AUXILIARY_VARIABLE_PREFIX)).map(va -> va instanceof VarEntities.VarAlone ? va.id : va.id + Arrays.stream(((VarEntities.VarArray)VarEntities.VarArray.class.cast((Object)va)).sizes).mapToObj(d -> "[]").collect(Collectors.joining(""))).collect(Collectors.joining(" ")) + " ";
        String values = " " + this.varEntities.allEntities.stream().filter(va -> !this.undisplay.contains(va.id) && !va.id.startsWith(AUXILIARY_VARIABLE_PREFIX)).map(va -> va instanceof VarEntities.VarAlone ? Variable.instantiationOf(((VarEntities.VarAlone)VarEntities.VarAlone.class.cast((Object)va)).var, PREFIX) : Variable.rawInstantiationOf(((VarEntities.VarArray)VarEntities.VarArray.class.cast((Object)va)).vars, PREFIX)).collect(Collectors.joining(" ")) + " ";
        return s + "  <list>" + list + "</list>  <values>" + values + "</values>  </instantiation>";
    }

    public final void prettyDisplay() {
        String s;
        boolean displayJ;
        if (!this.rs.cp.competitionMode && this.solver.solManager.nSolutionsFound != 1L && this.rs.cp.verbose < 1) {
            return;
        }
        String PREFIX = this.rs.cp.competitionMode ? "v " : "   ";
        boolean bl = displayJ = !this.rs.cp.competitionMode;
        if (displayJ) {
            s = PREFIX + "{\n";
            s = s + this.varEntities.allEntities.stream().filter(va -> !this.undisplay.contains(va.id)).map(va -> PREFIX + " " + va.id + ": " + (va instanceof VarEntities.VarAlone ? Variable.instantiationOf(((VarEntities.VarAlone)VarEntities.VarAlone.class.cast((Object)va)).var, PREFIX) : Variable.instantiationOf(((VarEntities.VarArray)VarEntities.VarArray.class.cast((Object)va)).vars, PREFIX))).collect(Collectors.joining(",\n"));
            s = s + "\n" + PREFIX + "}";
            Kit.log.config(s + "\n");
        }
        this.solver.solManager.lastSolutionX = s = this.lastSolutionX(PREFIX);
        if (!this.rs.cp.competitionMode) {
            Kit.log.config(PREFIX + s + "\n");
        }
        String[] values = this.varEntities.allEntities.stream().filter(va -> !this.undisplay.contains(va.id)).map(va -> va instanceof VarEntities.VarAlone ? Variable.instantiationOf(((VarEntities.VarAlone)VarEntities.VarAlone.class.cast((Object)va)).var, PREFIX) : Variable.rawInstantiationOf(((VarEntities.VarArray)VarEntities.VarArray.class.cast((Object)va)).vars, PREFIX)).collect(Collectors.joining(" ")).split("\\s+");
        this.api.prettyDisplay(values);
    }

    private String savingName() {
        if (this.rs.cp.xml.keepInstanceName) {
            return this.name();
        }
        String s = this.name();
        int start = s.lastIndexOf(File.separator) + 1;
        int end = s.lastIndexOf(".xml.bz2") != -1 ? s.lastIndexOf(".xml.bz2") : (s.lastIndexOf(".xml.lzma") != -1 ? s.lastIndexOf(".xml.lzma") : s.length());
        s = s.substring(start, end) + (this.stuff.nMergedCtrs > 0 ? "_mgd" : "") + (this.rs.cp.extension.wcnConversion != Enums.EWCNConversion.NO ? "_ub" + this.rs.cp.optimizing.upperBound : "");
        if (this.rs.cp.general.limitForSatisfaction != Long.MAX_VALUE) {
            s = s + "_lfs" + this.rs.cp.general.limitForSatisfaction;
        }
        return s;
    }

    public final void saveIntoXCSP(Enums.EExportMoment moment) {
        if (!this.rs.cp.export || this.rs.cp.xml.exportMoment != moment) {
            return;
        }
        Document document = new Compiler3Abscon(new Subproblem(this)).buildDocument();
        String fileName = this.rs.cp.xml.export == Enums.EExport.STD ? null : this.savingName() + ".xml";
        this.save(document, fileName);
        if (this.rs.cp.xml.indentAndCompressUnderLinux) {
            this.indentAndCompressXmlUnderLinux(fileName);
        }
    }

    public Class<VariableInteger> classVI() {
        return VariableInteger.class;
    }

    public Class<VariableSymbolic> classVS() {
        return VariableSymbolic.class;
    }

    private boolean mustBuildWCN() {
        if (this.rs instanceof Integration) {
            return false;
        }
        if (this.api instanceof WcspReader) {
            return true;
        }
        if (this.rs.cp.extension.wcnConversion != Enums.EWCNConversion.NO) {
            return true;
        }
        return this.rs.cp.framework == Types.TypeFramework.WCSP || this.framework == Types.TypeFramework.WCSP;
    }

    public Types.TypeFramework typeFramework() {
        return this.mustBuildWCN() ? Types.TypeFramework.WCSP : this.framework;
    }

    public final Variable addVar(Variable x) {
        Kit.control(!this.mapForVars.containsKey(x.id()), () -> x.id() + " duplicated");
        if (this.stuff.mustDiscard(x)) {
            return null;
        }
        if (this.stuff.collectedVarsAtInit.isEmpty()) {
            this.rs.output.printBeforeLoading(this.rs.instanceNumber);
            System.out.print("\n  Loading variables..." + (this.rs.cp.verbose <= 1 || this.rs.cp.competitionMode ? "\n" : ""));
        }
        if (this.rs.cp.verbose > 1 && !this.rs.cp.competitionMode) {
            int n = this.stuff.collectedVarsAtInit.size();
            int nDigits = n < 10 ? 1 : (n < 100 ? 2 : (n < 1000 ? 3 : (n < 10000 ? 4 : (n < 100000 ? 5 : (n < 1000000 ? 6 : 7)))));
            IntStream.range(0, nDigits).forEach(i -> System.out.print("\b"));
            System.out.print(n + 1 + "");
        }
        x.num = this.stuff.addCollectedVariable(x);
        this.mapForVars.put(x.id(), x);
        return x;
    }

    public VariableInteger buildVarInteger(String id, Domains.Dom dom) {
        Object[] values = dom.values;
        VariableInteger x = null;
        if (values.length == 1 && values[0] instanceof Values.IntegerInterval) {
            Values.IntegerInterval ii = (Values.IntegerInterval)values[0];
            int min = Utilities.safeLong2IntWhileHandlingInfinity((long)ii.inf, (boolean)true);
            int max = Utilities.safeLong2IntWhileHandlingInfinity((long)ii.sup, (boolean)true);
            x = new VariableInteger(this, id, min, max);
        } else {
            x = values.length == 3 && values[0] instanceof Values.IntegerValue && values[1] instanceof Values.IntegerValue && values[2] instanceof Values.IntegerValue && ((Values.IntegerValue)values[2]).v == Integer.MAX_VALUE ? new VariableInteger(this, id, Utilities.safeLong2IntWhileHandlingInfinity((long)((Values.IntegerValue)values[0]).v, (boolean)true), Utilities.safeLong2IntWhileHandlingInfinity((long)((Values.IntegerValue)values[1]).v, (boolean)true)) : new VariableInteger(this, id, Values.IntegerEntity.toIntArray((Values.IntegerEntity[])((Values.IntegerEntity[])values), (int)Integer.MAX_VALUE));
        }
        return (VariableInteger)this.addVar(x);
    }

    public VariableSymbolic buildVarSymbolic(String id, Domains.DomSymbolic dom) {
        return (VariableSymbolic)this.addVar(new VariableSymbolic(this, id, (String[])dom.values));
    }

    public boolean isBasicType(int type) {
        return type == 0 || this.rs.cp.global.priorityType0 && this.rs.cp.export;
    }

    private CtrEntities.CtrEntity unimplemented(String msg) {
        return (CtrEntities.CtrEntity)Kit.exit("\nunimplemented case for " + msg);
    }

    private CtrEntities.CtrEntity unimplementedIf(boolean b, String msg) {
        return b ? this.unimplemented(msg) : null;
    }

    public final CtrEntities.CtrAlone intension(XNodeParent<IVar> tree) {
        Variable[] scp = (Variable[])tree.vars();
        Kit.control(Stream.of(scp).allMatch(x -> x instanceof IVar.Var) || Stream.of(scp).allMatch(x -> x instanceof IVar.VarSymbolic));
        if (scp.length == 1 && !this.rs.mustPreserveUnaryConstraints()) {
            Variable x2 = scp[0];
            EvaluationManager em = x2 instanceof VariableInteger ? new EvaluationManager(tree) : new EvaluationManager(tree, this.symbolic.mapOfSymbols);
            x2.dom.executeOnValues(v -> {
                if (em.evaluate(v.intValue()) != 1L) {
                    x.dom.removeValueAtConstructionTime((int)v);
                }
            });
            ++this.stuff.nRemovedUnaryCtrs;
            CtrEntities ctrEntities = this.ctrEntities;
            ctrEntities.getClass();
            return new CtrEntities.CtrAloneDummy(ctrEntities, "Removed unary constraint by domain reduction", new Types.TypeClass[0]);
        }
        if (!this.rs.cp.export && scp.length <= this.rs.cp.extension.arityLimitForIntensionToExtension && Variable.nValidTuplesBoundedAtMaxValueFor(scp) <= this.rs.cp.extension.validLimitForIntensionToExtension && Stream.of(scp).allMatch(x -> x instanceof IVar.Var)) {
            return this.extension(tree);
        }
        return this.addCtr(new CtrIntension(this, scp, tree), new Types.TypeClass[0]);
    }

    protected ProblemIMP.Converter getConverter() {
        return this.converter;
    }

    private Variable[] translate(IVar[] t) {
        return t instanceof Variable[] ? (Variable[])t : (Variable[])Stream.of(t).map(x -> (Variable)x).toArray(Variable[]::new);
    }

    private Variable[][] translate2D(IVar[][] m) {
        return m instanceof Variable[][] ? (Variable[][])m : (Variable[][])Stream.of(m).map(t -> this.translate((IVar[])t)).toArray(x$0 -> new Variable[x$0][]);
    }

    public final CtrEntities.CtrAlone extension(IVar[] scp, Object tuples, boolean positive, Boolean starred) {
        return this.addCtr(CtrExtension.build(this, this.translate(scp), tuples, positive, starred), new Types.TypeClass[0]);
    }

    public final CtrEntities.CtrAlone extension(IVar.Var[] scp, int[][] tuples, boolean positive) {
        if (!this.rs.cp.export && tuples.length == 0) {
            return this.addCtr(positive ? new CtrHardFalse(this, this.translate((IVar[])scp), "Table constraint with 0 support") : new CtrHardTrue(this, this.translate((IVar[])scp)), new Types.TypeClass[0]);
        }
        return this.extension((IVar[])scp, tuples, positive, DONT_KNOW);
    }

    public final CtrEntities.CtrAlone extension(IVar.VarSymbolic[] scp, String[][] tuples, boolean positive) {
        return this.extension((IVar[])scp, tuples, positive, DONT_KNOW);
    }

    public final CtrEntities.CtrAlone regular(IVar.Var[] list, Automaton automaton) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawRegular.buildFrom(this, (IVar[])list, this.varEntities.compactOrdered((IVar[])list), Stream.of(automaton.transitions).map(t -> t.toString()).collect(Collectors.joining()), automaton.startState, automaton.finalStates), new Types.TypeClass[0]);
        }
        return this.addCtr(new CtrExtensionMDD(this, this.translate((IVar[])list), automaton), new Types.TypeClass[0]);
    }

    public final CtrEntities.CtrAlone mdd(IVar.Var[] list, Transition[] transitions) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawMdd.buildFrom(this, (IVar[])list, this.varEntities.compactOrdered((IVar[])list), Stream.of(transitions).map(t -> t.toString()).collect(Collectors.joining())), new Types.TypeClass[0]);
        }
        return this.addCtr(new CtrExtensionMDD(this, this.translate((IVar[])list), transitions), new Types.TypeClass[0]);
    }

    public final CtrEntities.CtrAlone mdd(IVar.Var[] scp, int[][] tuples) {
        return this.addCtr(new CtrExtensionMDD(this, this.translate((IVar[])scp), tuples), new Types.TypeClass[0]);
    }

    public final CtrEntities.CtrAlone mddOr(IVar.Var[] scp, MDDCD[] t) {
        return this.addCtr(new CtrExtensionOrMDD(this, this.translate((IVar[])scp), t), new Types.TypeClass[0]);
    }

    private CtrEntities.CtrEntity allDifferent(Variable[] scp) {
        if (scp.length <= 1) {
            CtrEntities ctrEntities = this.ctrEntities;
            ctrEntities.getClass();
            return new CtrEntities.CtrAloneDummy(ctrEntities, "Removed alldiff constraint with scope length = " + scp.length, new Types.TypeClass[0]);
        }
        if (this.isBasicType(this.rs.cp.global.typeAllDifferent)) {
            return this.addCtr(Variable.isPermutationElligible(scp) ? new AllDifferentPermutation(this, scp) : new AllDifferent(this, scp), new Types.TypeClass[0]);
        }
        if (this.rs.cp.global.typeAllDifferent == 1) {
            return this.forall(this.range(scp.length).range(scp.length), (i, j) -> {
                if (i < j) {
                    this.addCtr(new NE(this, scp[i], scp[j]), new Types.TypeClass[0]);
                }
            });
        }
        if (this.rs.cp.global.typeAllDifferent == 2) {
            return this.addCtr(new AllDifferentWeak(this, scp), new Types.TypeClass[0]);
        }
        if (this.rs.cp.global.typeAllDifferent == 3) {
            return this.addCtr(new AllDifferentCounting(this, scp), new Types.TypeClass[0]);
        }
        if (this.rs.cp.global.typeAllDifferent == 4) {
            return this.addCtr(new AllDifferentBound(this, scp), new Types.TypeClass[0]);
        }
        throw new MissingImplementationException();
    }

    public final CtrEntities.CtrEntity allDifferent(IVar.Var[] list) {
        return this.allDifferent(this.translate((IVar[])list));
    }

    public final CtrEntities.CtrEntity allDifferent(IVar.VarSymbolic[] list) {
        return this.allDifferent(this.translate((IVar[])list));
    }

    public final CtrEntities.CtrEntity allDifferent(IVar.Var[] scp, int[] exceptValues) {
        Kit.control(exceptValues.length >= 1);
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawAllDifferent.buildFrom(this, (IVar[])scp, ICtr.LIST, this.varEntities.compact((IVar[])scp), Kit.join((Object)exceptValues, new String[0])), new Types.TypeClass[0]);
        }
        if (this.rs.cp.global.typeAllDifferent <= 1) {
            return this.forall(this.range(scp.length).range(scp.length), (i, j) -> {
                if (i < j) {
                    this.intension((XNodeParent<IVar>)XNodeParent.or((Object[])new Object[]{XNodeParent.ne((Object[])new Object[]{scp[i], scp[j]}), exceptValues.length == 1 ? XNodeParent.eq((Object[])new Object[]{scp[i], exceptValues[0]}) : XNodeParent.in((Object)scp[i], (Object)exceptValues)}));
                }
            });
        }
        if (this.rs.cp.global.typeAllDifferent == 2) {
            return this.addCtr(new AllDifferentExceptWeak(this, this.translate((IVar[])scp), exceptValues), new Types.TypeClass[0]);
        }
        throw new MissingImplementationException();
    }

    private CtrEntities.CtrAlone distinctVectors(Variable[] t1, Variable[] t2) {
        Kit.control(this.rs.cp.export || Variable.areAllDistinct((Variable[])this.vars(new Object[]{t1, t2})), () -> "For the moment not handled");
        if (this.isBasicType(this.rs.cp.global.typeDistinctVectors2)) {
            return this.addCtr(CtrExtensionSmart.buildDistinctVectors(this, t1, t2), new Types.TypeClass[0]);
        }
        if (this.rs.cp.global.typeDistinctVectors2 == 1) {
            if (this.rs.cp.global.smartTable) {
                return this.addCtr(CtrExtensionSmart.buildDistinctVectors(this, t1, t2), new Types.TypeClass[0]);
            }
            if (this.rs.cp.global.jokerTable) {
                return this.extension((IVar.Var[])this.vars(new Object[]{t1, t2}), constraints.hard.extension.structures.Table.shortTuplesFordNotEqualVectors(t1, t2), true);
            }
        }
        throw new MissingImplementationException();
    }

    private CtrEntities.CtrEntity distinctVectors(Variable[][] lists) {
        if (this.isBasicType(this.rs.cp.global.typeDistinctVectorsK)) {
            return this.addCtr(new DistinctVectorsK(this, lists), new Types.TypeClass[0]);
        }
        if (this.rs.cp.global.typeDistinctVectorsK == 1) {
            return this.forall(this.range(lists.length).range(lists.length), (i, j) -> {
                if (i < j) {
                    if (this.rs.cp.global.smartTable) {
                        this.addCtr(CtrExtensionSmart.buildDistinctVectors(this, lists[i], lists[j]), new Types.TypeClass[0]);
                    } else if (this.rs.cp.global.jokerTable) {
                        this.extension((IVar.Var[])this.vars(new Object[]{lists[i], lists[j]}), constraints.hard.extension.structures.Table.shortTuplesFordNotEqualVectors(lists[i], lists[j]), true);
                    } else {
                        this.addCtr(CtrExtensionSmart.buildDistinctVectors(this, lists[i], lists[j]), new Types.TypeClass[0]);
                    }
                }
            });
        }
        throw new MissingImplementationException();
    }

    public final CtrEntities.CtrEntity allDifferentList(IVar.Var[] ... lists) {
        Kit.control(lists.length >= 2);
        Variable[][] m = this.translate2D((IVar[][])lists);
        return lists.length == 2 ? this.distinctVectors(m[0], m[1]) : this.distinctVectors(m);
    }

    public final CtrEntities.CtrEntity allDifferentMatrix(IVar.Var[][] matrix) {
        if (this.isBasicType(this.rs.cp.global.typeAllDifferentMatrix)) {
            return this.addCtr(CtrRaw.RawAllDifferent.buildFrom(this, this.vars((IVar[][])matrix), ICtr.MATRIX, this.varEntities.compactMatrix((IVar[][])matrix), null), new Types.TypeClass[0]);
        }
        if (this.rs.cp.global.typeAllDifferentMatrix == 1) {
            CtrEntities.CtrArray ctrSet1 = this.forall(this.range(matrix.length), i -> this.allDifferent(matrix[i]));
            CtrEntities.CtrArray ctrSet2 = this.forall(this.range(matrix[0].length), i -> this.allDifferent((IVar.Var[])this.api.columnOf((Object[][])matrix, i)));
            return ctrSet1.append(ctrSet2);
        }
        throw new MissingImplementationException();
    }

    public CtrEntities.CtrEntity allDifferent(XNode<IVar>[] trees) {
        if (this.rs.cp.export) {
            String s = Stream.of(trees).map(t -> t.toString()).collect(Collectors.joining(" "));
            return this.addCtr(CtrRaw.RawAllDifferent.buildFrom(this, this.scope(new Object[]{Stream.of(trees).map(t -> t.vars())}), ICtr.LIST, s, null), new Types.TypeClass[0]);
        }
        return this.forall(this.range(trees.length).range(trees.length), (i, j) -> {
            if (i < j) {
                this.different(new Object[]{trees[i], trees[j]});
            }
        });
    }

    private CtrEntities.CtrEntity allEqual(Variable[] scp) {
        if (this.isBasicType(this.rs.cp.global.typeAllEqual)) {
            return this.addCtr(new AllEqual(this, scp), new Types.TypeClass[0]);
        }
        if (this.rs.cp.global.typeAllEqual == 1) {
            return this.forall(this.range(scp.length - 1), i -> this.equal(new Object[]{scp[i], scp[i + 1]}));
        }
        if (this.rs.cp.global.typeAllEqual == 2) {
            if (this.rs.cp.global.smartTable) {
                return this.addCtr(CtrExtensionSmart.buildAllEqual(this, scp), new Types.TypeClass[0]);
            }
            if (this.rs.cp.global.basicTable) {
                int[][] tuples = (int[][])IntStream.of(scp[0].dom.values()).mapToObj(val -> Kit.repeat(val, scp.length)).toArray(x$0 -> new int[x$0][]);
                return this.api.extension((IVar.Var[])((VariableInteger[])scp), Variable.filterTuples(scp, tuples, false));
            }
        }
        throw new MissingImplementationException();
    }

    public final CtrEntities.CtrEntity allEqual(IVar.Var ... scp) {
        return this.allEqual(this.translate((IVar[])scp));
    }

    public final CtrEntities.CtrEntity allEqual(IVar.VarSymbolic ... scp) {
        return this.allEqual(this.translate((IVar[])scp));
    }

    public final CtrEntities.CtrEntity allEqualList(IVar.Var[] ... lists) {
        Kit.control(lists.length >= 2);
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawAllEqual.buildFrom(this, this.vars((IVar[][])lists), "lists", this.varEntities.compactOrdered((IVar[][])lists)), new Types.TypeClass[0]);
        }
        return (CtrEntities.CtrEntity)Kit.exit("unimplemented case for element");
    }

    public final CtrEntities.CtrEntity ordered(IVar.Var[] list, int[] lengths, Types.TypeOperatorRel op) {
        Kit.control(list != null && lengths != null && list.length == lengths.length + 1 && op != null);
        if (this.isBasicType(this.rs.cp.global.typeOrdered) || this.rs.cp.global.typeOrdered == 1) {
            return this.addCtr(Ordered.build(this, this.translate((IVar[])list), lengths, op), new Types.TypeClass[0]);
        }
        if (this.rs.cp.global.typeOrdered == 2) {
            return this.forall(this.range(list.length - 1), i -> this.intension((XNodeParent<IVar>)XNodeParent.build((Types.TypeExpr)op.toTypeExpr(), (Object[])new Object[]{lengths[i] == 0 ? list[i] : XNodeParent.add((Object[])new Object[]{list[i], lengths[i]}), list[i + 1]})));
        }
        return this.forall(this.range(list.length - 1), i -> {
            if (op == Types.TypeOperatorRel.LT) {
                this.addCtr(new LT(this, (Variable)list[i], lengths[i], (Variable)list[i + 1]), new Types.TypeClass[0]);
            } else if (op == Types.TypeOperatorRel.LE) {
                this.addCtr(new LE(this, (Variable)list[i], lengths[i], (Variable)list[i + 1]), new Types.TypeClass[0]);
            } else if (op == Types.TypeOperatorRel.GE) {
                this.addCtr(new GE(this, (Variable)list[i], lengths[i], (Variable)list[i + 1]), new Types.TypeClass[0]);
            } else {
                this.addCtr(new GT(this, (Variable)list[i], lengths[i], (Variable)list[i + 1]), new Types.TypeClass[0]);
            }
        });
    }

    public final CtrEntities.CtrEntity ordered(IVar.Var[] list, IVar.Var[] lengths, Types.TypeOperatorRel op) {
        Kit.control(list != null && lengths != null && list.length == lengths.length + 1 && op != null);
        if (this.isBasicType(this.rs.cp.global.typeOrdered)) {
            return this.addCtr(CtrRaw.RawOrdered.buildFrom(this, this.scope(new Object[]{list, lengths}), this.varEntities.compactOrdered((IVar[])list), this.varEntities.compactOrdered((IVar[])lengths), op), new Types.TypeClass[0]);
        }
        return this.forall(this.range(list.length - 1), i -> this.intension((XNodeParent<IVar>)XNodeParent.build((Types.TypeExpr)op.toTypeExpr(), (Object[])new Object[]{XNodeParent.add((Object[])new Object[]{list[i], lengths[i]}), list[i + 1]})));
    }

    private final CtrEntities.CtrAlone lexSimple(Variable[] t1, Variable[] t2, Types.TypeOperatorRel operator) {
        Kit.control(operator != null);
        if (operator == Types.TypeOperatorRel.GT || operator == Types.TypeOperatorRel.GE) {
            Variable[] t = t1;
            t1 = t2;
            t2 = t;
        }
        if (operator == Types.TypeOperatorRel.LT || operator == Types.TypeOperatorRel.GT) {
            if (this.rs.cp.global.smartTable) {
                return this.addCtr(CtrExtensionSmart.buildLexicographicL(this, t1, t2, true), new Types.TypeClass[0]);
            }
            return this.addCtr(new Lexicographic.LexicographicLt(this, t1, t2), new Types.TypeClass[0]);
        }
        if (operator == Types.TypeOperatorRel.LE || operator == Types.TypeOperatorRel.GE) {
            if (this.rs.cp.global.smartTable) {
                return this.addCtr(CtrExtensionSmart.buildLexicographicL(this, t1, t2, false), new Types.TypeClass[0]);
            }
            return this.addCtr(new Lexicographic.LexicographicLe(this, t1, t2), new Types.TypeClass[0]);
        }
        throw new UnreachableCodeException();
    }

    public final CtrEntities.CtrEntity lex(IVar.Var[][] lists, Types.TypeOperatorRel operator) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawOrdered.buildFrom(this, this.vars((IVar[][])lists), "lists", this.varEntities.compactOrdered((IVar[][])lists), operator), new Types.TypeClass[0]);
        }
        return this.forall(this.range(lists.length - 1), i -> this.lexSimple(this.translate((IVar[])lists[i]), this.translate((IVar[])lists[i + 1]), operator));
    }

    public final CtrEntities.CtrEntity lexMatrix(IVar.Var[][] matrix, Types.TypeOperatorRel operator) {
        if (this.rs.cp.export) {
            return (CtrEntities.CtrEntity)Kit.exit("lexMatrix not managed here for the moment; use org.xcp.modeler.Compiler");
        }
        CtrEntities.CtrArray ctrSet1 = this.forall(this.range(matrix.length - 1), i -> this.lexSimple(this.translate((IVar[])matrix[i]), this.translate((IVar[])matrix[i + 1]), operator));
        CtrEntities.CtrArray ctrSet2 = this.forall(this.range(matrix[0].length - 1), j -> this.lexSimple(this.translate((IVar[])this.api.columnOf((Object[][])matrix, j)), this.translate((IVar[])this.api.columnOf((Object[][])matrix, j + 1)), operator));
        return ctrSet1.append(ctrSet2);
    }

    private IVar.Var replaceByAuxiliaryVariable(XNode<IVar> tree) {
        int[] nArray;
        if (tree.getType().isPredicateOperator()) {
            int[] nArray2 = new int[2];
            nArray2[0] = 0;
            nArray = nArray2;
            nArray2[1] = 1;
        } else {
            nArray = new EvaluationManager(tree).generatePossibleValues(Variable.initDomainValues(this.translate(tree.vars())));
        }
        int[] values = nArray;
        IVar.Var tmp = this.api.var(AUXILIARY_VARIABLE_PREFIX + this.varEntities.allEntities.size(), this.api.dom(values), "auxiliary", new Types.TypeClass[0]);
        this.equal(new Object[]{tmp, tree});
        return tmp;
    }

    private IVar.Var[] replaceByAuxiliaryVariables(XNode<IVar>[] trees) {
        int[][] values = (int[][])Stream.of(trees).map(t -> {
            int[] nArray;
            if (t.getType().isPredicateOperator()) {
                int[] nArray2 = new int[2];
                nArray2[0] = 0;
                nArray = nArray2;
                nArray2[1] = 1;
            } else {
                nArray = new EvaluationManager(t).generatePossibleValues(Variable.initDomainValues(this.translate(t.vars())));
            }
            return nArray;
        }).toArray(x$0 -> new int[x$0][]);
        IVar.Var[] tmp = this.api.array(AUXILIARY_VARIABLE_PREFIX + this.varEntities.allEntities.size(), this.api.size(trees.length), i -> this.api.dom(values[i]), "auxiliary", new Types.TypeClass[0]);
        this.forall(this.range(trees.length), i -> this.equal(new Object[]{tmp[i], trees[i]}));
        return tmp;
    }

    private CtrEntities.CtrEntity sum1(Variable[] list, int[] coeffs, Types.TypeConditionOperatorRel op, long limit, boolean inversable) {
        Stream<Term> s = IntStream.range(0, list.length).mapToObj(i -> new Term(coeffs[i], list[i]));
        if (!Variable.areAllDistinct(list)) {
            s = s.collect(Collectors.groupingBy(t -> t.var, Collectors.summingInt(t -> t.coeff))).entrySet().stream().map(e -> new Term((Integer)e.getValue(), (Variable)e.getKey()));
            Kit.log.info("Sum constraint with several ocurrences of the same variable");
        }
        s = s.filter(t -> t.coeff != 0);
        Term[] orderedTerms = (Term[])Kit.sort(s.toArray(Term[]::new));
        Variable[] vs = (VariableInteger[])Stream.of(orderedTerms).map(t -> t.var).toArray(VariableInteger[]::new);
        int[] cs = Stream.of(orderedTerms).mapToInt(t -> t.coeff).toArray();
        if (inversable && cs[0] == -1 && cs[cs.length - 1] == -1) {
            Arrays.fill(cs, 1);
            op = op.arithmeticInversion();
            limit = -limit;
        }
        if (cs[0] == 1 && cs[cs.length - 1] == 1) {
            if (this.rs.cp.hardCoding.convertBooleanSumAsCountingCtr && op != Types.TypeConditionOperatorRel.NE && Variable.areInitiallyBoolean(list)) {
                Kit.control(0L <= limit && limit <= (long)vs.length);
                int l = (int)limit;
                return op == Types.TypeConditionOperatorRel.LT ? this.api.atMost((IVar.Var[])vs, 1, l - 1) : (op == Types.TypeConditionOperatorRel.LE ? this.api.atMost((IVar.Var[])vs, 1, l) : (op == Types.TypeConditionOperatorRel.GE ? this.api.atLeast((IVar.Var[])vs, 1, l) : (op == Types.TypeConditionOperatorRel.GT ? this.api.atLeast((IVar.Var[])vs, 1, l + 1) : this.api.exactly((IVar.Var[])vs, 1, l))));
            }
            if (op == Types.TypeConditionOperatorRel.LT) {
                return this.addCtr(new SumSimple.SumSimpleLE(this, vs, limit - 1L), new Types.TypeClass[0]);
            }
            if (op == Types.TypeConditionOperatorRel.LE) {
                return this.addCtr(new SumSimple.SumSimpleLE(this, vs, limit), new Types.TypeClass[0]);
            }
            if (op == Types.TypeConditionOperatorRel.GE) {
                return this.addCtr(new SumSimple.SumSimpleGE(this, list, limit), new Types.TypeClass[0]);
            }
            if (op == Types.TypeConditionOperatorRel.GT) {
                return this.addCtr(new SumSimple.SumSimpleGE(this, vs, limit + 1L), new Types.TypeClass[0]);
            }
            if (op == Types.TypeConditionOperatorRel.NE) {
                return this.addCtr(new SumSimple.SumSimpleNE(this, vs, limit), new Types.TypeClass[0]);
            }
            return this.addCtr(new SumSimple.SumSimpleEQ(this, vs, limit), new Types.TypeClass[0]);
        }
        if (op == Types.TypeConditionOperatorRel.LT) {
            return this.addCtr(new SumWeighted.SumWeightedLE(this, vs, cs, limit - 1L), new Types.TypeClass[0]);
        }
        if (op == Types.TypeConditionOperatorRel.LE) {
            return this.addCtr(new SumWeighted.SumWeightedLE(this, vs, cs, limit), new Types.TypeClass[0]);
        }
        if (op == Types.TypeConditionOperatorRel.GE) {
            return this.addCtr(new SumWeighted.SumWeightedGE(this, vs, cs, limit), new Types.TypeClass[0]);
        }
        if (op == Types.TypeConditionOperatorRel.GT) {
            return this.addCtr(new SumWeighted.SumWeightedGE(this, vs, cs, limit + 1L), new Types.TypeClass[0]);
        }
        if (op == Types.TypeConditionOperatorRel.NE) {
            return this.addCtr(new SumWeighted.SumWeightedNE(this, vs, cs, limit), new Types.TypeClass[0]);
        }
        return this.addCtr(new SumWeighted.SumWeightedEQ(this, vs, cs, limit), new Types.TypeClass[0]);
    }

    private CtrEntities.CtrEntity sum2(Variable[] list, int[] coeffs, Types.TypeConditionOperatorRel op, Variable limit) {
        return this.sum1((Variable[])this.vars(new Object[]{list, limit}), this.api.vals(new Object[]{coeffs, -1}), op, 0L, true);
    }

    private CtrEntities.CtrEntity sum3(Variable[] list, int[] coeffs, Types.TypeConditionOperatorSet op, long min, long max) {
        if (op == Types.TypeConditionOperatorSet.IN) {
            return this.addCtr(new CtrExtensionMDD(this, list, coeffs, this.api.rangeClosed(Utilities.safeLong2Int((long)min, (boolean)true), Utilities.safeLong2Int((long)max, (boolean)true))), new Types.TypeClass[0]);
        }
        return this.unimplemented("sum3");
    }

    private CtrEntities.CtrEntity sum4(Variable[] list, int[] coeffs, Types.TypeConditionOperatorSet op, int[] values) {
        if (op == Types.TypeConditionOperatorSet.IN) {
            return this.addCtr(new CtrExtensionMDD(this, list, coeffs, values), new Types.TypeClass[0]);
        }
        return this.unimplemented("sum4");
    }

    public final CtrEntities.CtrEntity sum(IVar.Var[] list, int[] coeffs, Condition condition) {
        Utilities.control((boolean)Stream.of(list).noneMatch(x -> x == null), (String)"A variable is null");
        Utilities.control((list.length == coeffs.length ? 1 : 0) != 0, (String)"Pb because the number of variables is different form the number of coefficients");
        IVar[] newList = this.translate((IVar[])this.api.select((Object[])list, i -> coeffs[i] != 0));
        int[] newCoeffs = this.api.selectFromIndexing(coeffs, i -> coeffs[i] != 0);
        Utilities.control((newList.length > 0 && newList.length == newCoeffs.length ? 1 : 0) != 0, (String)"Pb because the number of variables is different form the number of coefficients");
        if (this.rs.cp.export) {
            String cfs = Kit.withOnly(1, newCoeffs) ? null : Kit.join((Object)newCoeffs, new String[0]);
            return this.addCtr(CtrRaw.RawSum.buildFrom(this, this.scope(new Object[]{newList, condition}), cfs == null ? this.varEntities.compact(newList) : this.varEntities.compactOrdered(newList), cfs, condition), new Types.TypeClass[0]);
        }
        if (newList.length == 1) {
            // empty if block
        }
        if (condition instanceof Condition.ConditionVal) {
            return this.sum1((Variable[])newList, newCoeffs, ((Condition.ConditionVal)condition).operator, ((Condition.ConditionVal)condition).k, true);
        }
        if (condition instanceof Condition.ConditionVar) {
            return this.sum2((Variable[])newList, newCoeffs, ((Condition.ConditionVar)condition).operator, (Variable)((Condition.ConditionVar)condition).x);
        }
        if (condition instanceof Condition.ConditionIntvl) {
            return this.sum3((Variable[])newList, newCoeffs, ((Condition.ConditionIntvl)condition).operator, ((Condition.ConditionIntvl)condition).min, ((Condition.ConditionIntvl)condition).max);
        }
        return this.sum4((Variable[])newList, newCoeffs, ((Condition.ConditionIntset)condition).operator, ((Condition.ConditionIntset)condition).t);
    }

    public final CtrEntities.CtrEntity sum(IVar.Var[] list, IVar.Var[] coeffs, Condition condition) {
        Utilities.control((Stream.of(list).noneMatch(x -> x == null) && Stream.of(coeffs).noneMatch(x -> x == null) ? 1 : 0) != 0, (String)"A variable is null");
        Utilities.control((list.length == coeffs.length ? 1 : 0) != 0, (String)"Pb because the number of variables is different form the number of coefficients");
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawSum.buildFrom(this, this.scope(new Object[]{list, coeffs, condition}), this.varEntities.compactOrdered((IVar[])list), this.varEntities.compactOrdered((IVar[])coeffs), condition), new Types.TypeClass[0]);
        }
        if (condition instanceof Condition.ConditionVal) {
            int k = Utilities.safeLong2Int((long)((Condition.ConditionVal)condition).k, (boolean)true);
            if (Variable.areInitiallyBoolean(this.translate((IVar[])list)) && Variable.areInitiallyBoolean(this.translate((IVar[])coeffs))) {
                if (((Condition.ConditionVal)condition).operator == Types.TypeConditionOperatorRel.LE) {
                    return this.addCtr(new SumScalarBoolean.SumScalarBooleanLE(this, this.translate((IVar[])list), this.translate((IVar[])coeffs), k), new Types.TypeClass[0]);
                }
                if (((Condition.ConditionVal)condition).operator == Types.TypeConditionOperatorRel.EQ) {
                    return this.addCtr(new SumScalarBoolean.SumScalarBooleanEQ(this, this.translate((IVar[])list), this.translate((IVar[])coeffs), k), new Types.TypeClass[0]);
                }
            }
            return this.unimplemented("sum " + condition);
        }
        if (condition instanceof Condition.ConditionVar) {
            VariableInteger limit = (VariableInteger)((Condition.ConditionVar)condition).x;
            Utilities.control((limit != null ? 1 : 0) != 0, (String)"A variable is null");
            if (Variable.areInitiallyBoolean((Variable[])list) && Variable.areInitiallyBoolean(this.translate((IVar[])coeffs)) && ((Condition.ConditionVar)condition).operator == Types.TypeConditionOperatorRel.LE) {
                return this.addCtr(new SumScalarBoolean.SumScalarBooleanLEVar(this, this.translate((IVar[])list), this.translate((IVar[])coeffs), limit), new Types.TypeClass[0]);
            }
            IVar.Var[] aux = this.replaceByAuxiliaryVariables((XNode[])IntStream.range(0, list.length).mapToObj(i -> this.api.mul(new Object[]{list[i], coeffs[i]})).toArray(XNode[]::new));
            return this.sum(aux, Kit.repeat(1, aux.length), condition);
        }
        if (condition instanceof Condition.ConditionIntvl) {
            XNode[] trees = (XNode[])IntStream.range(0, list.length).mapToObj(i -> this.api.mul(new Object[]{list[i], coeffs[i]})).toArray(XNode[]::new);
            IVar.Var[] tmp = this.replaceByAuxiliaryVariables(trees);
            CtrEntities.CtrEntity c = this.sum(tmp, Kit.repeat(1, tmp.length), this.api.condition(Types.TypeConditionOperatorRel.GE, ((Condition.ConditionIntvl)condition).min));
            this.sum(tmp, Kit.repeat(1, tmp.length), this.api.condition(Types.TypeConditionOperatorRel.LE, ((Condition.ConditionIntvl)condition).max));
            return c;
        }
        return this.unimplemented("sum");
    }

    public CtrEntities.CtrEntity sum(XNode<IVar>[] trees, int[] coeffs, Condition condition) {
        if (this.rs.cp.export) {
            String s = Stream.of(trees).map(t -> t.toString()).collect(Collectors.joining(" "));
            return this.addCtr(CtrRaw.RawSum.buildFrom(this, this.scope(new Object[]{Stream.of(trees).map(t -> t.vars()), condition}), s, Kit.join((Object)coeffs, new String[0]), condition), new Types.TypeClass[0]);
        }
        boolean b = false;
        if (condition instanceof Condition.ConditionRel) {
            Object limit;
            Types.TypeExpr op = ((Condition.ConditionRel)condition).operator.toExpr();
            Object object = limit = condition instanceof Condition.ConditionVal ? Long.valueOf(((Condition.ConditionVal)condition).k) : ((Condition.ConditionVar)condition).x;
            if (trees.length == 1) {
                return this.intension((XNodeParent<IVar>)XNodeParent.build((Types.TypeExpr)op, (Object[])new Object[]{trees[0], limit}));
            }
            if (b) {
                return this.intension((XNodeParent<IVar>)XNodeParent.build((Types.TypeExpr)op, (Object[])new Object[]{XNodeParent.add((Object[])trees), limit}));
            }
        }
        IVar.Var[] tmp = this.replaceByAuxiliaryVariables(trees);
        return this.sum(tmp, coeffs, condition);
    }

    private CtrEntities.CtrEntity atLeast(IVar.Var[] list, int value, int k) {
        Kit.control(list.length != 0 && k >= 0);
        Variable[] scp = (Variable[])Stream.of(list).filter(x -> ((VariableInteger)x).dom.isPresentValue(value) && ((VariableInteger)x).dom.size() > 1).toArray(Variable[]::new);
        int newK = k - (int)Stream.of(list).filter(x -> ((VariableInteger)x).dom.onlyContainsValue(value)).count();
        if (newK <= 0) {
            CtrEntities ctrEntities = this.ctrEntities;
            ctrEntities.getClass();
            return new CtrEntities.CtrAloneDummy(ctrEntities, "Removed constraint due to newk < 0", new Types.TypeClass[0]);
        }
        if (newK == scp.length) {
            return this.forall(this.range(scp.length), i -> this.equal(new Object[]{scp[i], value}));
        }
        if (newK > scp.length) {
            return this.addCtr(new CtrHardFalse(this, this.translate((IVar[])list), "Constraint atLeast intially unsatisfiable"), new Types.TypeClass[0]);
        }
        return newK == 1 ? this.addCtr(new Count.AtLeast1(this, scp, value), new Types.TypeClass[0]) : this.addCtr(new Count.AtLeastK(this, scp, value, newK), new Types.TypeClass[0]);
    }

    private CtrEntities.CtrEntity atMost(IVar.Var[] list, int value, int k) {
        if (list.length == 0) {
            CtrEntities ctrEntities = this.ctrEntities;
            ctrEntities.getClass();
            return new CtrEntities.CtrAloneDummy(ctrEntities, "atMost with empty set", new Types.TypeClass[0]);
        }
        Kit.control(k >= 0);
        Variable[] scp = (Variable[])Stream.of(list).filter(x -> ((VariableInteger)x).dom.isPresentValue(value) && ((VariableInteger)x).dom.size() > 1).toArray(Variable[]::new);
        int newK = k - (int)Stream.of(list).filter(x -> ((VariableInteger)x).dom.onlyContainsValue(value)).count();
        if (newK < 0) {
            return this.addCtr(new CtrHardFalse(this, this.translate((IVar[])list), "Constraint atMost intially unsatisfiable"), new Types.TypeClass[0]);
        }
        if (newK == 0) {
            return this.forall(this.range(scp.length), i -> this.different(new Object[]{scp[i], value}));
        }
        if (newK >= scp.length) {
            CtrEntities ctrEntities = this.ctrEntities;
            ctrEntities.getClass();
            return new CtrEntities.CtrAloneDummy(ctrEntities, "atMost with newK greater than scp.length", new Types.TypeClass[0]);
        }
        return newK == 1 ? this.addCtr(new Count.AtMost1(this, scp, value), new Types.TypeClass[0]) : this.addCtr(new Count.AtMostK(this, scp, value, newK), new Types.TypeClass[0]);
    }

    private CtrEntities.CtrEntity exactly(IVar.Var[] list, int value, int k) {
        Kit.control(list.length != 0 && k >= 0);
        Variable[] scp = (Variable[])Stream.of(list).filter(x -> ((VariableInteger)x).dom.isPresentValue(value) && ((VariableInteger)x).dom.size() > 1).toArray(Variable[]::new);
        int newK = k - (int)Stream.of(list).filter(x -> ((VariableInteger)x).dom.onlyContainsValue(value)).count();
        Kit.control(newK >= 0, () -> "UNSAT, constraint Exactly with scope " + Kit.join((Object)list, new String[0]) + " has already more than " + k + " variables equal to " + value);
        if (newK == 0) {
            return this.forall(this.range(scp.length), i -> this.different(new Object[]{scp[i], value}));
        }
        if (newK == scp.length) {
            return this.forall(this.range(scp.length), i -> this.equal(new Object[]{scp[i], value}));
        }
        Kit.control(newK < scp.length, () -> "Instance is UNSAT, constraint Exactly with scope " + Kit.join((Object)list, new String[0]) + " cannot have " + k + " variables equal to " + value);
        return newK == 1 ? this.addCtr(new Count.Exactly1(this, scp, value), new Types.TypeClass[0]) : this.addCtr(new Count.ExactlyK(this, scp, value, newK), new Types.TypeClass[0]);
    }

    private CtrEntities.CtrEntity among(IVar.Var[] list, int[] values, int k) {
        Kit.control(list.length >= k);
        if (list.length == k) {
            for (IVar.Var x : list) {
                Domain dom = ((VariableInteger)x).dom;
                int a = dom.first();
                while (a != -1) {
                    int v = dom.toVal(a);
                    if (!Kit.isPresent(v, values)) {
                        this.different(new Object[]{x, v});
                    }
                    a = dom.next(a);
                }
            }
            return null;
        }
        return this.addCtr(new Among(this, (VariableInteger[])list, values, k), new Types.TypeClass[0]);
    }

    private CtrEntities.CtrEntity count1(VariableInteger[] list, int[] values, Types.TypeConditionOperatorRel op, long limit) {
        int l = Utilities.safeLong2Int((long)limit, (boolean)true);
        if (values.length == 1) {
            if (op == Types.TypeConditionOperatorRel.GE) {
                return this.atLeast(list, values[0], l);
            }
            if (op == Types.TypeConditionOperatorRel.GT) {
                return this.atLeast(list, values[0], l + 1);
            }
            if (op == Types.TypeConditionOperatorRel.LT) {
                return this.atMost(list, values[0], l - 1);
            }
            if (op == Types.TypeConditionOperatorRel.LE) {
                return this.atMost(list, values[0], l);
            }
            if (op == Types.TypeConditionOperatorRel.EQ) {
                return this.exactly(list, values[0], l);
            }
            return this.unimplemented("count");
        }
        if (op == Types.TypeConditionOperatorRel.EQ) {
            return this.among(list, values, l);
        }
        return this.unimplemented("count");
    }

    private CtrEntities.CtrEntity count2(VariableInteger[] list, int[] values, Types.TypeConditionOperatorRel op, VariableInteger limit) {
        if (values.length == 1) {
            if (op == Types.TypeConditionOperatorRel.EQ) {
                return this.addCtr(new ExactlyKVariable(this, list, values[0], limit), new Types.TypeClass[0]);
            }
            return this.unimplemented("count");
        }
        return this.unimplemented("count");
    }

    public final CtrEntities.CtrEntity count(IVar.Var[] list, int[] values, Condition condition) {
        list = (IVar.Var[])this.clean((IVar[])list);
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawCount.buildFrom(this, this.scope(new Object[]{list, condition}), this.varEntities.compact((IVar[])list), Kit.join((Object)values, new String[0]), condition), new Types.TypeClass[0]);
        }
        if (condition instanceof Condition.ConditionVal) {
            return this.count1((VariableInteger[])list, values, ((Condition.ConditionVal)condition).operator, ((Condition.ConditionVal)condition).k);
        }
        if (condition instanceof Condition.ConditionVar) {
            return this.count2((VariableInteger[])list, values, ((Condition.ConditionVar)condition).operator, (VariableInteger)((Condition.ConditionVar)condition).x);
        }
        this.unimplementedIf(condition instanceof Condition.ConditionIntvl, "count");
        return this.unimplemented("count");
    }

    public final CtrEntities.CtrEntity count(IVar.Var[] list, IVar.Var[] values, Condition condition) {
        list = (IVar.Var[])this.clean((IVar[])list);
        values = (IVar.Var[])this.clean((IVar[])values);
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawCount.buildFrom(this, this.scope(new Object[]{list, values, condition}), this.varEntities.compact((IVar[])list), this.varEntities.compact((IVar[])values), condition), new Types.TypeClass[0]);
        }
        return this.unimplemented("count");
    }

    public CtrEntities.CtrEntity nValues(IVar.Var[] list, Condition condition) {
        Types.TypeConditionOperatorRel op;
        list = (IVar.Var[])this.clean((IVar[])list);
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawNValues.buildFrom(this, this.scope(new Object[]{list, condition}), this.varEntities.compact((IVar[])list), null, condition), new Types.TypeClass[0]);
        }
        if (condition instanceof Condition.ConditionVal) {
            Types.TypeConditionOperatorRel op2 = ((Condition.ConditionVal)condition).operator;
            int k = Utilities.safeLong2Int((long)((Condition.ConditionVal)condition).k, (boolean)true);
            if (op2 == Types.TypeConditionOperatorRel.GT && k == 1 || op2 == Types.TypeConditionOperatorRel.GE && k == 2) {
                if (this.isBasicType(this.rs.cp.global.typeNotAllEqual)) {
                    return this.addCtr(new NotAllEqual(this, (VariableInteger[])list), new Types.TypeClass[0]);
                }
                if (this.rs.cp.global.typeNotAllEqual == 1) {
                    VariableInteger[] clone = (VariableInteger[])list.clone();
                    return this.intension((XNodeParent<IVar>)XNodeParent.or((Object[])IntStream.range(0, list.length - 1).mapToObj(i -> XNodeParent.ne((Object[])new Object[]{clone[i], clone[i + 1]})).toArray(Object[]::new)));
                }
            }
            if (op2 == Types.TypeConditionOperatorRel.LE || op2 == Types.TypeConditionOperatorRel.LT) {
                return this.addCtr(new NValues.NValuesLE(this, (Variable[])((VariableInteger[])list), op2 == Types.TypeConditionOperatorRel.LE ? k : k - 1), new Types.TypeClass[0]);
            }
            if (op2 == Types.TypeConditionOperatorRel.GE || op2 == Types.TypeConditionOperatorRel.GT) {
                return this.addCtr(new NValues.NValuesGE(this, (Variable[])((VariableInteger[])list), op2 == Types.TypeConditionOperatorRel.GE ? k : k + 1), new Types.TypeClass[0]);
            }
        } else if (condition instanceof Condition.ConditionVar && (op = ((Condition.ConditionVar)condition).operator) == Types.TypeConditionOperatorRel.EQ) {
            return this.addCtr(new NValuesVar(this, (Variable[])((VariableInteger[])list), (VariableInteger)((Condition.ConditionVar)condition).x), new Types.TypeClass[0]);
        }
        return this.unimplemented("nValues");
    }

    public CtrEntities.CtrEntity nValues(IVar.Var[] list, Condition condition, int[] exceptValues) {
        list = (IVar.Var[])this.clean((IVar[])list);
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawNValues.buildFrom(this, this.scope(new Object[]{list, condition}), this.varEntities.compact((IVar[])list), Kit.join((Object)exceptValues, new String[0]), condition), new Types.TypeClass[0]);
        }
        return this.unimplemented("nValues");
    }

    private CtrEntities.CtrArray postClosed(VariableInteger[] list, int[] values) {
        Kit.control(Stream.of(list).anyMatch(x -> !x.dom.areInitValuesSubsetOf(values)));
        return this.forall(this.range(list.length), i -> {
            if (!list[i].dom.areInitValuesSubsetOf(values)) {
                this.api.extension((IVar.Var)list[i], this.api.select(values, v -> list[i].dom.isPresentValue(v)));
            }
        });
    }

    public final CtrEntities.CtrEntity cardinality(IVar.Var[] list, int[] values, boolean mustBeClosed, int[] occurs) {
        Kit.control(values.length == occurs.length);
        list = (IVar.Var[])this.clean((IVar[])list);
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawCardinality.buildFrom(this, (IVar[])list, this.varEntities.compact((IVar[])list), Kit.join((Object)values, new String[0]), mustBeClosed, Kit.join((Object)occurs, new String[0])), new Types.TypeClass[0]);
        }
        if (mustBeClosed && Stream.of(list).anyMatch(x -> !((VariableInteger)x).dom.areInitValuesSubsetOf(values))) {
            this.postClosed((VariableInteger[])list, values);
        }
        return this.addCtr(new CardinalityConstant(this, (VariableInteger[])list, values, occurs), new Types.TypeClass[0]);
    }

    public final CtrEntities.CtrEntity cardinality(IVar.Var[] list, int[] values, boolean mustBeClosed, IVar.Var[] occurs) {
        Kit.control(values.length == occurs.length && Stream.of(occurs).noneMatch(x -> x == null));
        list = (IVar.Var[])this.clean((IVar[])list);
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawCardinality.buildFrom(this, this.scope(new Object[]{list, occurs}), this.varEntities.compact((IVar[])list), Kit.join((Object)values, new String[0]), mustBeClosed, this.varEntities.compactOrdered((IVar[])occurs)), new Types.TypeClass[0]);
        }
        if (mustBeClosed && Stream.of(list).anyMatch(x -> !((VariableInteger)x).dom.areInitValuesSubsetOf(values))) {
            this.postClosed((VariableInteger[])list, values);
        }
        VariableInteger[] clone = (VariableInteger[])list.clone();
        return this.forall(this.range(values.length), i -> this.api.exactly((IVar.Var[])clone, values[i], occurs[i]));
    }

    public final CtrEntities.CtrEntity cardinality(IVar.Var[] list, int[] values, boolean mustBeClosed, int[] occursMin, int[] occursMax) {
        Kit.control(values.length == occursMin.length && values.length == occursMax.length);
        list = (IVar.Var[])this.clean((IVar[])list);
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawCardinality.buildFrom(this, (IVar[])list, this.varEntities.compact((IVar[])list), Kit.join((Object)values, new String[0]), mustBeClosed, this.intervalAsString(occursMin, occursMax)), new Types.TypeClass[0]);
        }
        return this.addCtr(new CardinalityConstant(this, (VariableInteger[])list, values, occursMin, occursMax), new Types.TypeClass[0]);
    }

    public final CtrEntities.CtrEntity cardinality(IVar.Var[] list, IVar.Var[] values, boolean mustBeClosed, int[] occurs) {
        Kit.control(values.length == occurs.length && Stream.of(values).noneMatch(x -> x == null));
        list = (IVar.Var[])this.clean((IVar[])list);
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawCardinality.buildFrom(this, this.scope(new Object[]{list, values}), this.varEntities.compact((IVar[])list), this.varEntities.compactOrdered((IVar[])values), mustBeClosed, Kit.join((Object)occurs, new String[0])), new Types.TypeClass[0]);
        }
        return this.unimplemented("cardinality");
    }

    public final CtrEntities.CtrEntity cardinality(IVar.Var[] list, IVar.Var[] values, boolean mustBeClosed, IVar.Var[] occurs) {
        Kit.control(values.length == occurs.length && Stream.of(values).noneMatch(x -> x == null) && Stream.of(occurs).noneMatch(x -> x == null));
        list = (IVar.Var[])this.clean((IVar[])list);
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawCardinality.buildFrom(this, this.scope(new Object[]{list, values, occurs}), this.varEntities.compact((IVar[])list), this.varEntities.compactOrdered((IVar[])values), mustBeClosed, this.varEntities.compactOrdered((IVar[])occurs)), new Types.TypeClass[0]);
        }
        return this.unimplemented("cardinality");
    }

    public final CtrEntities.CtrEntity cardinality(IVar.Var[] list, IVar.Var[] values, boolean mustBeClosed, int[] occursMin, int[] occursMax) {
        Kit.control(values.length == occursMin.length && values.length == occursMax.length && Stream.of(values).noneMatch(x -> x == null));
        list = (IVar.Var[])this.clean((IVar[])list);
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawCardinality.buildFrom(this, this.scope(new Object[]{list, values}), this.varEntities.compact((IVar[])list), this.varEntities.compactOrdered((IVar[])values), mustBeClosed, this.intervalAsString(occursMin, occursMax)), new Types.TypeClass[0]);
        }
        return this.unimplemented("cardinality");
    }

    private final CtrEntities.CtrEntity extremum(IVar.Var[] list, Condition condition, boolean minimum) {
        IVar[] vars = (Variable[])this.clean((IVar[])list);
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawExtremum.buildFrom(this, this.scope(new Object[]{vars, condition}), this.varEntities.compact(vars), null, null, null, condition, minimum), new Types.TypeClass[0]);
        }
        if (condition instanceof Condition.ConditionVar) {
            Types.TypeConditionOperatorRel op = ((Condition.ConditionVar)condition).operator;
            if (op != Types.TypeConditionOperatorRel.EQ) {
                return this.unimplemented(minimum ? "minimum" : "maximum");
            }
            Variable y = (Variable)((Condition.ConditionVar)condition).x;
            if (vars.length == 1) {
                return this.equal(new Object[]{y, vars[0]});
            }
            if (Stream.of(vars).anyMatch(x -> x == y)) {
                return this.forall(this.range(vars.length), arg_0 -> this.lambda$extremum$135(y, (Variable[])vars, minimum, arg_0));
            }
            if (this.rs.cp.global.smartTable) {
                return this.addCtr(minimum ? CtrExtensionSmart.buildMinimum(this, (Variable[])vars, y) : CtrExtensionSmart.buildMaximum(this, (Variable[])vars, y), new Types.TypeClass[0]);
            }
            return this.addCtr(minimum ? new Extremum.Minimum(this, (Variable[])vars, y) : new Extremum.Maximum(this, (Variable[])vars, y), new Types.TypeClass[0]);
        }
        if (condition instanceof Condition.ConditionVal) {
            Types.TypeConditionOperatorRel op = ((Condition.ConditionVal)condition).operator;
            Kit.control(op != Types.TypeConditionOperatorRel.EQ && op != Types.TypeConditionOperatorRel.NE);
            int k = Utilities.safeLong2Int((long)((Condition.ConditionVal)condition).k, (boolean)true);
            if (op == Types.TypeConditionOperatorRel.LT || op == Types.TypeConditionOperatorRel.LE) {
                k = op == Types.TypeConditionOperatorRel.LE ? k : k - 1;
                return this.addCtr(minimum ? new ObjMinimum.ObjMinimumLE(this, (Variable[])vars, k) : new ObjMaximum.ObjMaximumLE(this, (Variable[])vars, k), new Types.TypeClass[0]);
            }
            if (op == Types.TypeConditionOperatorRel.GT || op == Types.TypeConditionOperatorRel.GE) {
                k = op == Types.TypeConditionOperatorRel.GE ? k : k + 1;
                return this.addCtr(minimum ? new ObjMinimum.ObjMinimumGE(this, (Variable[])vars, k) : new ObjMaximum.ObjMaximumGE(this, (Variable[])vars, k), new Types.TypeClass[0]);
            }
        }
        return this.unimplemented(minimum ? "minimum" : "maximum");
    }

    private final CtrEntities.CtrEntity extremum(IVar.Var[] list, int startIndex, IVar.Var index, Types.TypeRank rank, Condition condition, boolean minimum) {
        Kit.control(Stream.of(list).noneMatch(x -> x == null));
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawExtremum.buildFrom(this, this.scope(new Object[]{list, index, condition}), this.varEntities.compactOrdered((IVar[])list), startIndex, index, rank, condition, minimum), new Types.TypeClass[0]);
        }
        return this.unimplemented(minimum ? "minimum" : "maximum");
    }

    public final CtrEntities.CtrEntity minimum(IVar.Var[] list, Condition condition) {
        return this.extremum(list, condition, true);
    }

    public final CtrEntities.CtrEntity minimum(IVar.Var[] list, int startIndex, IVar.Var index, Types.TypeRank rank) {
        return this.extremum(list, startIndex, index, rank, null, true);
    }

    public final CtrEntities.CtrEntity minimum(IVar.Var[] list, int startIndex, IVar.Var index, Types.TypeRank rank, Condition condition) {
        return this.extremum(list, startIndex, index, rank, condition, true);
    }

    public final CtrEntities.CtrEntity minimum(XNode<IVar>[] trees, Condition condition) {
        System.out.println("beforer replacement");
        IVar.Var[] tmp = this.replaceByAuxiliaryVariables(trees);
        System.out.println("fater replacement");
        return this.minimum(tmp, condition);
    }

    public final CtrEntities.CtrEntity maximum(IVar.Var[] list, Condition condition) {
        return this.extremum(list, condition, false);
    }

    public final CtrEntities.CtrEntity maximum(IVar.Var[] list, int startIndex, IVar.Var index, Types.TypeRank rank) {
        return this.extremum(list, startIndex, index, rank, null, false);
    }

    public final CtrEntities.CtrEntity maximum(IVar.Var[] list, int startIndex, IVar.Var index, Types.TypeRank rank, Condition condition) {
        return this.extremum(list, startIndex, index, rank, condition, false);
    }

    public final CtrEntities.CtrEntity maximum(XNode<IVar>[] trees, Condition condition) {
        IVar.Var[] tmp = this.replaceByAuxiliaryVariables(trees);
        return this.maximum(tmp, condition);
    }

    public final CtrEntities.CtrAlone element(IVar.Var[] list, int value) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawElement.buildFrom(this, (IVar[])list, this.varEntities.compact((IVar[])list), null, null, null, value), new Types.TypeClass[0]);
        }
        return (CtrEntities.CtrAlone)this.atLeast(list, value, 1);
    }

    public final CtrEntities.CtrAlone element(IVar.Var[] list, IVar.Var value) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawElement.buildFrom(this, this.scope(new Object[]{list, value}), this.varEntities.compact((IVar[])list), null, null, null, value), new Types.TypeClass[0]);
        }
        return (CtrEntities.CtrAlone)this.unimplemented("element");
    }

    public final CtrEntities.CtrAlone element(IVar.Var[] list, int startIndex, IVar.Var index, Types.TypeRank rank, int value) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawElement.buildFrom(this, this.scope(new Object[]{list, index}), this.varEntities.compactOrdered((IVar[])list), startIndex, index, rank, value), new Types.TypeClass[0]);
        }
        this.unimplementedIf(startIndex != 0 || rank != null && rank != Types.TypeRank.ANY, "element");
        if (this.rs.cp.global.jokerTable) {
            return this.extension((IVar.Var[])this.vars(new Object[]{index, list}), constraints.hard.extension.structures.Table.shortTuplesForElement(this.translate((IVar[])list), (Variable)index, value), true);
        }
        Variable[] lst = (VariableInteger[])Arrays.stream(list).map(v -> (VariableInteger)v).toArray(VariableInteger[]::new);
        return this.addCtr(new Element.ElementConstant(this, lst, (VariableInteger)index, value), new Types.TypeClass[0]);
    }

    public final CtrEntities.CtrAlone element(IVar.Var[] list, int startIndex, IVar.Var index, Types.TypeRank rank, IVar.Var value) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawElement.buildFrom(this, this.scope(new Object[]{list, index, value}), this.varEntities.compactOrdered((IVar[])list), startIndex, index, rank, value), new Types.TypeClass[0]);
        }
        this.unimplementedIf(startIndex != 0 || rank != null && rank != Types.TypeRank.ANY, "element");
        if (this.rs.cp.global.smartTable) {
            return this.addCtr(CtrExtensionSmart.buildElement(this, (VariableInteger[])list, (VariableInteger)index, (VariableInteger)value), new Types.TypeClass[0]);
        }
        if (this.rs.cp.global.jokerTable) {
            return this.extension(Utilities.indexOf((Object)value, (Object[])list) == -1 ? (IVar.Var[])this.vars(new Object[]{index, list, value}) : (IVar.Var[])this.vars(new Object[]{index, list}), constraints.hard.extension.structures.Table.shortTuplesForElement((Variable[])list, (Variable)index, (Variable)value), true);
        }
        Variable[] lst = (VariableInteger[])Arrays.stream(list).map(v -> (VariableInteger)v).toArray(VariableInteger[]::new);
        return this.addCtr(new Element.ElementVariable(this, lst, (VariableInteger)index, (VariableInteger)value), new Types.TypeClass[0]);
    }

    private final CtrEntities.CtrEntity element(int[] list, int startIndex, IVar.Var index, IVar.Var value, int startValue) {
        ArrayList<int[]> l = new ArrayList<int[]>();
        Domain x = ((VariableInteger)index).dom;
        Domain z = ((VariableInteger)value).dom;
        int a = x.first();
        while (a != -1) {
            int v = x.toVal(a) - startIndex;
            if (0 <= v && v < list.length && z.isPresentValue(list[v] - startValue)) {
                l.add(new int[]{v + startIndex, list[v] - startValue});
            }
            a = x.next(a);
        }
        return this.api.extension((IVar.Var[])this.vars(new Object[]{index, value}), Table.clean(l));
    }

    public final CtrEntities.CtrEntity element(int[] list, int startIndex, IVar.Var index, Types.TypeRank rank, IVar.Var value) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawElement.buildFrom(this, this.scope(new Object[]{index, value}), Utilities.join((Object)list), startIndex, index, rank, value), new Types.TypeClass[0]);
        }
        this.unimplementedIf(rank != null && rank != Types.TypeRank.ANY, "element");
        return this.element(list, startIndex, index, value, 0);
    }

    public int[][] jokerTableForElement(IVar.Var[] list, IVar.Var index, IVar.Var value, int startValue) {
        Utilities.control((Utilities.indexOf((Object)index, (Object[])list) == -1 && index != value ? 1 : 0) != 0, (String)"index cannot be in vector or be the same variable as result");
        int pos = Utilities.indexOf((Object)value, (Object[])list);
        if (pos != -1) {
            int[] tuple = this.api.repeat(0x7FFFFFFE, 1 + list.length);
            ArrayList<int[]> tuples = new ArrayList<int[]>();
            int a = ((Variable)index).dom.first();
            while (a != -1) {
                int v = ((Variable)index).dom.toVal(a);
                if (0 <= v && v < list.length) {
                    if (list[v] == value) {
                        if (startValue == 0) {
                            int[] t = (int[])tuple.clone();
                            t[0] = v;
                            tuples.add(t);
                        }
                    } else {
                        int b = ((Variable)list[v]).dom.first();
                        while (b != -1) {
                            int w = ((Variable)list[v]).dom.toVal(b);
                            if (((Variable)value).dom.isPresentValue(w - startValue)) {
                                int[] t = (int[])tuple.clone();
                                t[0] = v;
                                t[1 + v] = w;
                                t[1 + pos] = w - startValue;
                                tuples.add(t);
                            }
                            b = ((Variable)list[v]).dom.next(b);
                        }
                    }
                }
                a = ((Variable)index).dom.next(a);
            }
            return Kit.intArray2D(tuples);
        }
        return (int[][])Kit.exit("unimplemented case ");
    }

    public CtrEntities.CtrEntity element(int[][] matrix, int startRowIndex, IVar.Var rowIndex, int startColIndex, IVar.Var colIndex, IVar.Var value) {
        this.unimplementedIf(startRowIndex != 0 && startColIndex != 0, "element");
        ArrayList<int[]> l = new ArrayList<int[]>();
        Domain x = ((VariableInteger)rowIndex).dom;
        Domain y = ((VariableInteger)colIndex).dom;
        Domain z = ((VariableInteger)value).dom;
        int a = x.first();
        while (a != -1) {
            int b = y.first();
            while (b != -1) {
                int i = x.toVal(a);
                int j = y.toVal(b);
                if (0 <= i && i < matrix.length && 0 <= j && j < matrix[i].length && z.isPresentValue(matrix[i][j])) {
                    l.add(new int[]{i, j, matrix[i][j]});
                }
                b = y.next(b);
            }
            a = x.next(a);
        }
        return this.api.extension((IVar.Var[])this.vars(new Object[]{rowIndex, colIndex, value}), Table.clean(l));
    }

    public CtrEntities.CtrEntity element(IVar.Var[][] matrix, int startRowIndex, IVar.Var rowIndex, int startColIndex, IVar.Var colIndex, int value) {
        this.unimplementedIf(startRowIndex != 0 && startColIndex != 0, "element");
        if (rowIndex == colIndex) {
            Kit.control(matrix.length == matrix[0].length);
            IVar.Var[] t = (IVar.Var[])IntStream.range(0, matrix.length).mapToObj(i -> matrix[i][i]).toArray(IVar.Var[]::new);
            return this.element(t, startRowIndex, rowIndex, null, value);
        }
        return this.addCtr(new ElementMatrix(this, (Variable[][])matrix, (Variable)rowIndex, (Variable)colIndex, value), new Types.TypeClass[0]);
    }

    public CtrEntities.CtrEntity channel(IVar.Var[] list, int startIndex) {
        Kit.control(Stream.of(list).noneMatch(x -> x == null));
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawChannel.buildFrom(this, (IVar[])list, this.varEntities.compactOrdered((IVar[])list), startIndex, null, null, null), new Types.TypeClass[0]);
        }
        return this.unimplemented("channel");
    }

    public CtrEntities.CtrEntity channel(IVar.Var[] list1, int startIndex1, IVar.Var[] list2, int startIndex2) {
        Kit.control(Stream.of(list1).noneMatch(x -> x == null) && Stream.of(list2).noneMatch(x -> x == null));
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawChannel.buildFrom(this, this.scope(new Object[]{list1, list2}), this.varEntities.compactOrdered((IVar[])list1), startIndex1, this.varEntities.compactOrdered((IVar[])list2), startIndex2, null), new Types.TypeClass[0]);
        }
        Kit.control(startIndex1 == 0 && startIndex2 == 0, () -> "unimplemented case for channel");
        if (list1.length == list2.length) {
            this.allDifferent(list1);
            this.allDifferent(list2);
        }
        return this.forall(this.range(list1.length), i -> this.api.element(list2, list1[i], i));
    }

    public final CtrEntities.CtrEntity channel(IVar.Var[] list, int startIndex, IVar.Var value) {
        Kit.control(Stream.of(list).noneMatch(x -> x == null));
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawChannel.buildFrom(this, this.scope(new Object[]{list, value}), this.varEntities.compactOrdered((IVar[])list), startIndex, null, null, value), new Types.TypeClass[0]);
        }
        Kit.control(Variable.areInitiallyBoolean((VariableInteger[])list) && ((VariableInteger)value).dom.areInitValuesExactly(this.range(list.length)));
        return this.forall(this.range(list.length), i -> this.intension((XNodeParent<IVar>)XNodeParent.iff((Object[])new Object[]{list[i], XNodeParent.eq((Object[])new Object[]{value, i})})));
    }

    public CtrEntities.CtrEntity stretch(IVar.Var[] list, int[] values, int[] widthsMin, int[] widthsMax, int[][] patterns) {
        Kit.control(values.length == widthsMin.length && values.length == widthsMax.length);
        Kit.control(IntStream.range(0, values.length).allMatch(i -> widthsMin[i] <= widthsMax[i]));
        Kit.control(patterns == null || Stream.of(patterns).allMatch(t -> ((int[])t).length == 2));
        if (this.rs.cp.export) {
            String t2 = patterns == null ? null : ICtr.ICtrExtension.tableAsString((int[][])Table.clean((int[][])patterns));
            return this.addCtr(CtrRaw.RawStretch.buildFrom(this, (IVar[])list, this.varEntities.compactOrdered((IVar[])list), Kit.join((Object)values, new String[0]), this.intervalAsString(widthsMin, widthsMax), t2), new Types.TypeClass[0]);
        }
        return this.unimplemented("strtech");
    }

    private CtrEntities.CtrAlone noOverlap(IVar.Var x1, IVar.Var x2, int w1, int w2) {
        if (this.isBasicType(this.rs.cp.global.typeNoOverlap)) {
            return this.addCtr(new Disjonctive(this, (Variable)x1, w1, (Variable)x2, w2), new Types.TypeClass[0]);
        }
        if (this.rs.cp.global.typeNoOverlap == 2) {
            return this.intension((XNodeParent<IVar>)XNodeParent.or((Object[])new Object[]{XNodeParent.le((Object)XNodeParent.add((Object[])new Object[]{x1, w1}), (Object)x2), XNodeParent.le((Object)XNodeParent.add((Object[])new Object[]{x2, w2}), (Object)x1)}));
        }
        if (this.rs.cp.global.typeNoOverlap == 10) {
            return this.addCtr(CtrExtensionSmart.buildNoOverlap(this, (Variable)x1, (Variable)x2, w1, w2), new Types.TypeClass[0]);
        }
        return (CtrEntities.CtrAlone)Kit.exit("Bad value for the choice of the propagator");
    }

    public final CtrEntities.CtrEntity noOverlap(IVar.Var[] origins, int[] lengths, boolean zeroIgnored) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawNoOverlap.buildFrom(this, (IVar[])origins, this.varEntities.compactOrdered((IVar[])origins), Kit.join((Object)lengths, new String[0]), zeroIgnored), new Types.TypeClass[0]);
        }
        this.unimplementedIf(!zeroIgnored, "noOverlap");
        return this.forall(this.range(origins.length).range(origins.length), (i, j) -> {
            if (i < j) {
                this.noOverlap(origins[i], origins[j], lengths[i], lengths[j]);
            }
        });
    }

    public final CtrEntities.CtrEntity noOverlap(IVar.Var[] origins, IVar.Var[] lengths, boolean zeroIgnored) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawNoOverlap.buildFrom(this, this.scope(new Object[]{origins, lengths}), this.varEntities.compactOrdered((IVar[])origins), this.varEntities.compactOrdered((IVar[])lengths), zeroIgnored), new Types.TypeClass[0]);
        }
        return this.unimplemented("noOverlap");
    }

    private void addNonOverlapTuplesFor(List<int[]> list, Domain dom1, Domain dom2, int offset, boolean first, boolean xAxis) {
        int a = dom1.first();
        while (a != -1) {
            int w;
            int v = dom1.toVal(a);
            int b = dom2.last();
            while (b != -1 && v + offset <= (w = dom2.toVal(b))) {
                list.add(xAxis ? this.api.tuple(first ? v : w, new int[]{first ? w : v, 0x7FFFFFFE, 0x7FFFFFFE}) : this.api.tuple(0x7FFFFFFE, new int[]{0x7FFFFFFE, first ? v : w, first ? w : v}));
                b = dom2.prev(b);
            }
            a = dom1.next(a);
        }
    }

    private int[][] computeTable(Variable x1, Variable x2, Variable y1, Variable y2, int w1, int w2, int h1, int h2) {
        ArrayList<int[]> list = new ArrayList<int[]>();
        this.addNonOverlapTuplesFor(list, x1.dom, x2.dom, w1, true, true);
        this.addNonOverlapTuplesFor(list, x2.dom, x1.dom, w2, false, true);
        this.addNonOverlapTuplesFor(list, y1.dom, y2.dom, h1, true, false);
        this.addNonOverlapTuplesFor(list, y2.dom, y1.dom, h2, false, false);
        return Kit.intArray2D(list);
    }

    private CtrEntities.CtrAlone noOverlap(VariableInteger x1, VariableInteger x2, VariableInteger y1, VariableInteger y2, int w1, int w2, int h1, int h2) {
        if (this.rs.cp.global.smartTable) {
            return this.addCtr(CtrExtensionSmart.buildNoOverlap(this, (Variable)x1, (Variable)y1, (Variable)x2, (Variable)y2, w1, h1, w2, h2), new Types.TypeClass[0]);
        }
        if (this.rs.cp.global.jokerTable) {
            return this.extension(this.vars(new Object[]{x1, x2, y1, y2}), this.computeTable(x1, x2, y1, y2, w1, w2, h1, h2), true, true);
        }
        return this.intension((XNodeParent<IVar>)XNodeParent.or((Object[])new Object[]{XNodeParent.le((Object)XNodeParent.add((Object[])new Object[]{x1, w1}), (Object)x2), XNodeParent.le((Object)XNodeParent.add((Object[])new Object[]{x2, w2}), (Object)x1), XNodeParent.le((Object)XNodeParent.add((Object[])new Object[]{y1, h1}), (Object)y2), XNodeParent.le((Object)XNodeParent.add((Object[])new Object[]{y2, h2}), (Object)y1)}));
    }

    public final CtrEntities.CtrEntity noOverlap(IVar.Var[][] origins, int[][] lengths, boolean zeroIgnored) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawNoOverlap.buildFrom(this, this.vars((IVar[][])origins), this.varEntities.compactMatrix((IVar[][])origins), "(" + Kit.join((Object)lengths, ")(", ",") + ")", zeroIgnored), new Types.TypeClass[0]);
        }
        this.unimplementedIf(!zeroIgnored, "noOverlap");
        return this.forall(this.range(origins.length).range(origins.length), (i, j) -> {
            if (i < j) {
                this.noOverlap((VariableInteger)origins[i][0], (VariableInteger)origins[j][0], (VariableInteger)origins[i][1], (VariableInteger)origins[j][1], lengths[i][0], lengths[j][0], lengths[i][1], lengths[j][1]);
            }
        });
    }

    private CtrEntities.CtrAlone noOverlap(VariableInteger x1, VariableInteger x2, VariableInteger y1, VariableInteger y2, VariableInteger w1, VariableInteger w2, VariableInteger h1, VariableInteger h2) {
        if (this.rs.cp.global.smartTable && Stream.of(w1, w2, h1, h2).allMatch(x -> x.dom.initSize() == 2)) {
            return this.addCtr(CtrExtensionSmart.buildNoOverlap(this, (Variable)x1, (Variable)y1, (Variable)x2, (Variable)y2, w1, h1, w2, h2), new Types.TypeClass[0]);
        }
        return this.intension((XNodeParent<IVar>)XNodeParent.or((Object[])new Object[]{XNodeParent.le((Object)XNodeParent.add((Object[])new Object[]{x1, w1}), (Object)x2), XNodeParent.le((Object)XNodeParent.add((Object[])new Object[]{x2, w2}), (Object)x1), XNodeParent.le((Object)XNodeParent.add((Object[])new Object[]{y1, h1}), (Object)y2), XNodeParent.le((Object)XNodeParent.add((Object[])new Object[]{y2, h2}), (Object)y1)}));
    }

    public final CtrEntities.CtrEntity noOverlap(IVar.Var[][] origins, IVar.Var[][] lengths, boolean zeroIgnored) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawNoOverlap.buildFrom(this, this.scope(new Object[]{origins, lengths}), this.varEntities.compactMatrix((IVar[][])origins), "(" + Kit.join((Object)lengths, ")(", ",") + ")", zeroIgnored), new Types.TypeClass[0]);
        }
        this.unimplementedIf(!zeroIgnored, "noOverlap");
        return this.forall(this.range(origins.length).range(origins.length), (i, j) -> {
            if (i < j) {
                this.noOverlap((VariableInteger)origins[i][0], (VariableInteger)origins[j][0], (VariableInteger)origins[i][1], (VariableInteger)origins[j][1], (VariableInteger)lengths[i][0], (VariableInteger)lengths[j][0], (VariableInteger)lengths[i][1], (VariableInteger)lengths[j][1]);
            }
        });
    }

    public final CtrEntities.CtrEntity cumulative(IVar.Var[] origins, int[] lengths, IVar.Var[] ends, int[] heights, Condition condition) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawCumulative.buildFrom(this, this.scope(new Object[]{origins, ends, condition}), this.varEntities.compactOrdered((IVar[])origins), Kit.join((Object)lengths, new String[0]), ends == null ? null : this.varEntities.compactOrdered((IVar[])ends), Kit.join((Object)heights, new String[0]), condition), new Types.TypeClass[0]);
        }
        return this.unimplemented("cumulative");
    }

    public final CtrEntities.CtrEntity cumulative(IVar.Var[] origins, IVar.Var[] lengths, IVar.Var[] ends, int[] heights, Condition condition) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawCumulative.buildFrom(this, this.scope(new Object[]{origins, lengths, ends, condition}), this.varEntities.compactOrdered((IVar[])origins), this.varEntities.compactOrdered((IVar[])lengths), ends == null ? null : this.varEntities.compactOrdered((IVar[])ends), Kit.join((Object)heights, new String[0]), condition), new Types.TypeClass[0]);
        }
        return this.unimplemented("cumulative");
    }

    public final CtrEntities.CtrEntity cumulative(IVar.Var[] origins, int[] lengths, IVar.Var[] ends, IVar.Var[] heights, Condition condition) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawCumulative.buildFrom(this, this.scope(new Object[]{origins, ends, heights, condition}), this.varEntities.compactOrdered((IVar[])origins), Kit.join((Object)lengths, new String[0]), ends == null ? null : this.varEntities.compactOrdered((IVar[])ends), this.varEntities.compactOrdered((IVar[])heights), condition), new Types.TypeClass[0]);
        }
        return this.unimplemented("cumulative");
    }

    public final CtrEntities.CtrEntity cumulative(IVar.Var[] origins, IVar.Var[] lengths, IVar.Var[] ends, IVar.Var[] heights, Condition condition) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawCumulative.buildFrom(this, this.scope(new Object[]{origins, lengths, ends, heights, condition}), this.varEntities.compactOrdered((IVar[])origins), this.varEntities.compactOrdered((IVar[])lengths), ends == null ? null : this.varEntities.compactOrdered((IVar[])ends), this.varEntities.compactOrdered((IVar[])heights), condition), new Types.TypeClass[0]);
        }
        return this.unimplemented("cumulative");
    }

    public CtrEntities.CtrEntity circuit(IVar.Var[] list, int startIndex) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawCircuit.buildFrom(this, (IVar[])list, this.varEntities.compactOrdered((IVar[])list), startIndex, null), new Types.TypeClass[0]);
        }
        this.unimplementedIf(startIndex != 0, "circuit");
        return this.addCtr(new Circuit(this, this.translate((IVar[])list)), new Types.TypeClass[0]);
    }

    public CtrEntities.CtrEntity circuit(IVar.Var[] list, int startIndex, int size) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawCircuit.buildFrom(this, (IVar[])list, this.varEntities.compactOrdered((IVar[])list), startIndex, size), new Types.TypeClass[0]);
        }
        return this.unimplemented("circuit");
    }

    public CtrEntities.CtrEntity circuit(IVar.Var[] list, int startIndex, IVar.Var size) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawCircuit.buildFrom(this, this.scope(new Object[]{list, size}), this.varEntities.compactOrdered((IVar[])list), startIndex, size), new Types.TypeClass[0]);
        }
        return this.unimplemented("circuit");
    }

    public final CtrEntities.CtrEntity clause(IVar.Var[] list, Boolean[] phases) {
        Utilities.control((boolean)Stream.of(list).noneMatch(x -> x == null), (String)"A variable in array list is null");
        Utilities.control((list.length == phases.length ? 1 : 0) != 0, (String)"Bad form of clause");
        Utilities.control((boolean)Variable.areInitiallyBoolean((VariableInteger[])list), (String)"A variable is not Boolean in the array list.");
        if (this.rs.cp.export) {
            String s = IntStream.range(0, list.length).mapToObj(i -> phases[i] != false ? list[i].id() : "not(" + list[i].id() + ")").collect(Collectors.joining(" "));
            return this.addCtr(CtrRaw.RawClause.buildFrom(this, (IVar[])list, s), new Types.TypeClass[0]);
        }
        if (this.rs.cp.global.typeClause == 1) {
            return this.api.sum(list, Stream.of(phases).mapToInt(p -> p != false ? 1 : -1).toArray(), Types.TypeConditionOperatorRel.NE, -Stream.of(phases).filter(p -> p == false).count());
        }
        return this.unimplemented("clause");
    }

    public final CtrEntities.CtrEntity instantiation(IVar.Var[] list, int[] values) {
        Kit.control(list.length == values.length && list.length > 0);
        Kit.control(IntStream.range(0, list.length).noneMatch(i -> !((Variable)list[i]).dom.isPresentValue(values[i])), () -> "Pb");
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawInstantiation.buildFrom(this, (IVar[])list, this.varEntities.compactOrdered((IVar[])list), Kit.join((Object)values, new String[0])), new Types.TypeClass[0]);
        }
        if (this.rs.cp.global.typeInstantiation == 1) {
            return this.forall(this.range(list.length), i -> this.equal(new Object[]{list[i], values[i]}));
        }
        return this.unimplemented("instantiation");
    }

    private int[] computeOffsets(IVar[][] lists, IVar[] scp0, IVar[] scp1) {
        return IntStream.range(0, lists.length).map(i -> {
            int pos0 = Stream.of(scp0).filter(x -> Utilities.indexOf((Object)x, (Object[])lists[i]) >= 0).mapToInt(x -> Utilities.indexOf((Object)x, (Object[])lists[i])).min().orElse(-1);
            int pos1 = Stream.of(scp1).filter(x -> Utilities.indexOf((Object)x, (Object[])lists[i]) >= 0).mapToInt(x -> Utilities.indexOf((Object)x, (Object[])lists[i])).min().orElse(-1);
            Kit.control(pos0 != -1 && pos1 != -1);
            return pos1 - pos0;
        }).toArray();
    }

    private int[] computeCollects(IVar[][] lists, IVar[] scp) {
        return IntStream.range(0, lists.length).map(i -> (int)Stream.of(scp).filter(x -> Utilities.indexOf((Object)x, (Object[])lists[i]) >= 0).count()).toArray();
    }

    public final CtrEntities.CtrEntity slide(IVar[] list, Range range, IntFunction<CtrEntities.CtrEntity> template) {
        Kit.control(range.startInclusive == 0 && range.length() > 0);
        if (range.length() == 1) {
            return template.apply(0);
        }
        if (this.rs.cp.export) {
            CtrEntities.CtrAlone[] cas = (CtrEntities.CtrAlone[])range.stream().mapToObj(i -> (CtrEntities.CtrEntity)template.apply(i)).toArray(CtrEntities.CtrAlone[]::new);
            for (int i2 = cas.length - 1; i2 >= 0; --i2) {
                this.removeCtr((CtrHard)cas[i2].ctr);
            }
            IVar[][] scopes = (IVar[][])Stream.of(cas).map(ca -> ca.ctr.scope()).toArray(x$0 -> new IVar[x$0][]);
            Kit.control(IntStream.range(1, scopes.length).noneMatch(i -> scopes[i].length != scopes[0].length));
            IVar[][] lists = new IVar[][]{list};
            boolean circular = Stream.of(scopes[scopes.length - 1]).anyMatch(x -> x == lists[0][0]);
            int[] offsets = this.computeOffsets(lists, scopes[0], scopes[1]);
            int[] collects = this.computeCollects(lists, scopes[0]);
            return this.addCtr(CtrRaw.RawSlide.buildFrom(this, list, circular, lists, offsets, collects, cas), new Types.TypeClass[0]);
        }
        return this.manageLoop(() -> {
            CtrHard[] cfr_ignored_0 = (CtrHard[])IntStream.range(0, range.endExclusive).filter(i -> i % range.step == 0).mapToObj(i -> (CtrHard)((CtrEntities.CtrAlone)template.apply((int)i)).ctr).toArray(CtrHard[]::new);
        });
    }

    public final CtrEntities.CtrEntity ifThen(CtrEntities.CtrEntity c1, CtrEntities.CtrEntity c2) {
        Utilities.control((c1 instanceof CtrEntities.CtrAlone && c2 instanceof CtrEntities.CtrAlone ? 1 : 0) != 0, (String)"unimplemented for the moment");
        if (this.rs.cp.export) {
            for (CtrEntities.CtrEntity c : new CtrEntities.CtrEntity[]{c2, c1}) {
                this.removeCtr((Constraint)((CtrEntities.CtrAlone)c).ctr);
            }
            return this.addCtr(CtrRaw.RawIfThen.buildFrom(this, this.scope(new Object[]{((CtrEntities.CtrAlone)c1).ctr.scope(), ((CtrEntities.CtrAlone)c2).ctr.scope()}), (CtrEntities.CtrAlone)c1, (CtrEntities.CtrAlone)c2), new Types.TypeClass[0]);
        }
        return (CtrEntities.CtrEntity)Kit.exit("unimplemented case for ifThen");
    }

    public final CtrEntities.CtrEntity ifThenElse(CtrEntities.CtrEntity c1, CtrEntities.CtrEntity c2, CtrEntities.CtrEntity c3) {
        Utilities.control((c1 instanceof CtrEntities.CtrAlone && c2 instanceof CtrEntities.CtrAlone && c3 instanceof CtrEntities.CtrAlone ? 1 : 0) != 0, (String)"unimplemented for the moment");
        if (this.rs.cp.export) {
            for (CtrEntities.CtrEntity c : new CtrEntities.CtrEntity[]{c3, c2, c1}) {
                this.removeCtr((Constraint)((CtrEntities.CtrAlone)c).ctr);
            }
            return this.addCtr(CtrRaw.RawIfThenElse.buildFrom(this, this.scope(new Object[]{((CtrEntities.CtrAlone)c1).ctr.scope(), ((CtrEntities.CtrAlone)c2).ctr.scope(), ((CtrEntities.CtrAlone)c3).ctr.scope()}), (CtrEntities.CtrAlone)c1, (CtrEntities.CtrAlone)c2, (CtrEntities.CtrAlone)c3), new Types.TypeClass[0]);
        }
        return (CtrEntities.CtrEntity)Kit.exit("unimplemented case for ifThenElse");
    }

    public final CtrEntities.CtrAlone smart(IVar[] scp, SmartTuple ... smartTuples) {
        return this.addCtr(new CtrExtensionSmart(this, this.translate(scp), smartTuples), new Types.TypeClass[0]);
    }

    public CtrEntities.CtrEntity tupleProximityGE(IVar[] scope, int[] tuple, int k, boolean noModidictaion) {
        Kit.control(scope.length != 0);
        if (noModidictaion) {
            return this.addCtr(new HammingProximityConstant.HammingProximityConstantGE(this, (Variable[])scope, tuple, k), new Types.TypeClass[0]);
        }
        ArrayList<IVar> newScope = new ArrayList<IVar>();
        ArrayList<Integer> newTuple = new ArrayList<Integer>();
        int newK = k;
        for (int i2 = 0; i2 < scope.length; ++i2) {
            if (!((Variable)scope[i2]).dom.isPresentValue(tuple[i2])) continue;
            if (((Variable)scope[i2]).dom.size() > 1) {
                newScope.add(scope[i2]);
                newTuple.add(tuple[i2]);
                continue;
            }
            --newK;
        }
        if (newK <= 0) {
            CtrEntities ctrEntities = this.ctrEntities;
            ctrEntities.getClass();
            return new CtrEntities.CtrAloneDummy(ctrEntities, "Removed constraint due to newk <= 0", new Types.TypeClass[0]);
        }
        if (newK == newScope.size()) {
            return this.forall(this.range(scope.length), i -> this.equal(new Object[]{scope[i], tuple[i]}));
        }
        Kit.control(newK < newScope.size(), () -> "Instance is UNSAT, constraint with scope " + Kit.join((Object)scope, new String[0]) + " cannot have more than " + k + " variables equal to their corresponding value in " + Kit.join((Object)tuple, new String[0]));
        return this.addCtr(new HammingProximityConstant.HammingProximityConstantGE(this, newScope.toArray(new Variable[newScope.size()]), Kit.intArray(newTuple), newK), new Types.TypeClass[0]);
    }

    public CtrEntities.CtrEntity tupleProximityDistanceSum(IVar[] scope, int[] tuple, int maxDist) {
        return this.addCtr(new HammingProximityConstant.HammingProximityConstantSumLE(this, this.translate(scope), tuple, maxDist), new Types.TypeClass[0]);
    }

    public final CtrEntities.CtrAlone ctrSoft(IVar[] scope, int[][] tuples, long[] costs, long defaultCost) {
        return this.addCtr(CtrSoftExtension.build(this, this.translate(scope), tuples, costs, defaultCost), new Types.TypeClass[0]);
    }

    public final CtrEntities.CtrAlone ctrSoft(IVar[] scope, int[][] tuples, int[] costs, int defaultCost) {
        return this.addCtr(CtrSoftExtension.build(this, this.translate(scope), tuples, costs, defaultCost), new Types.TypeClass[0]);
    }

    private OptimizationPilot buildOptimizationPilot(Types.TypeOptimization opt, OptimizationCompatible ctr) {
        Kit.control(this.optimizationPilot == null, () -> "Only mono-objective currently supported");
        this.framework = Types.TypeFramework.COP;
        this.rs.cp.toCOP();
        String suffix = Kit.camelCaseOf(this.rs.cp.optimizing.optimizationStrategy.name());
        return Reflector.buildObject(OptimizationPilot.class.getSimpleName() + suffix, OptimizationPilot.class, this, opt, ctr);
    }

    public ObjEntities.ObjEntity postObj(IObj o) {
        ObjEntities objEntities = this.objEntities;
        objEntities.getClass();
        return new ObjEntities.ObjEntity(objEntities, o, new Types.TypeClass[0]);
    }

    private void switchToSatsfaction() {
        this.framework = Types.TypeFramework.CSP;
        this.rs.cp.framework = Types.TypeFramework.CSP;
        this.rs.cp.general.nSearchedSolutions = 1L;
    }

    public final ObjEntities.ObjEntity minimize(IVar x) {
        if (this.rs.cp.general.limitForSatisfaction != Long.MAX_VALUE) {
            this.switchToSatsfaction();
            this.lessEqual(x, this.rs.cp.general.limitForSatisfaction);
            return null;
        }
        CtrEntities.CtrAlone ctrAlone = this.addCtr(new ObjVar.ObjVarLE(this, (VariableInteger)x, (int)Math.min(this.rs.cp.optimizing.upperBound, Integer.MAX_VALUE)), new Types.TypeClass[0]);
        this.optimizationPilot = this.buildOptimizationPilot(Types.TypeOptimization.MIN, (OptimizationCompatible)ctrAlone.ctr);
        return this.postObj((IObj)IObj.IObjFunctional.buildFrom((IVar[])this.scope(new Object[]{x}), (boolean)true, (XNode)new XNodeLeaf(Types.TypeExpr.VAR, (Object)x)));
    }

    public final ObjEntities.ObjEntity maximize(IVar x) {
        if (this.rs.cp.general.limitForSatisfaction != Long.MAX_VALUE) {
            this.switchToSatsfaction();
            this.greaterEqual(x, this.rs.cp.general.limitForSatisfaction);
            return null;
        }
        CtrEntities.CtrAlone ctrAlone = this.addCtr(new ObjVar.ObjVarGE(this, (VariableInteger)x, (int)Math.max(this.rs.cp.optimizing.lowerBound, Integer.MIN_VALUE)), new Types.TypeClass[0]);
        this.optimizationPilot = this.buildOptimizationPilot(Types.TypeOptimization.MAX, (OptimizationCompatible)ctrAlone.ctr);
        return this.postObj((IObj)IObj.IObjFunctional.buildFrom((IVar[])this.scope(new Object[]{x}), (boolean)false, (XNode)new XNodeLeaf(Types.TypeExpr.VAR, (Object)x)));
    }

    public final ObjEntities.ObjEntity minimize(XNode<IVar> tree) {
        return this.minimize((IVar)this.replaceByAuxiliaryVariable(tree));
    }

    public final ObjEntities.ObjEntity maximize(XNode<IVar> tree) {
        return this.maximize((IVar)this.replaceByAuxiliaryVariable(tree));
    }

    private OptimizationPilot optimizationPilotFor(Types.TypeObjective type, IVar[] list, boolean minimization) {
        Variable[] scp = this.translate(list);
        CtrEntities.CtrAlone ctrAlone = null;
        if (minimization) {
            int limit = (int)Math.min(this.rs.cp.optimizing.upperBound, type == Types.TypeObjective.NVALUES ? (long)list.length : Integer.MAX_VALUE);
            if (type == Types.TypeObjective.SUM) {
                ctrAlone = this.addCtr(new SumSimple.SumSimpleLE(this, scp, limit), new Types.TypeClass[0]);
            } else if (type == Types.TypeObjective.MINIMUM) {
                ctrAlone = this.addCtr(new ObjMinimum.ObjMinimumLE(this, scp, limit), new Types.TypeClass[0]);
            } else if (type == Types.TypeObjective.MAXIMUM) {
                ctrAlone = this.addCtr(new ObjMaximum.ObjMaximumLE(this, scp, limit), new Types.TypeClass[0]);
            } else {
                Kit.control(type == Types.TypeObjective.NVALUES);
                ctrAlone = this.addCtr(new NValues.NValuesLE(this, scp, limit), new Types.TypeClass[0]);
            }
        } else {
            int limit = (int)Math.max(this.rs.cp.optimizing.lowerBound, type == Types.TypeObjective.NVALUES ? 1L : Integer.MIN_VALUE);
            if (type == Types.TypeObjective.SUM) {
                ctrAlone = this.addCtr(new SumSimple.SumSimpleGE(this, scp, limit), new Types.TypeClass[0]);
            } else if (type == Types.TypeObjective.MINIMUM) {
                ctrAlone = this.addCtr(new ObjMinimum.ObjMinimumGE(this, scp, limit), new Types.TypeClass[0]);
            } else if (type == Types.TypeObjective.MAXIMUM) {
                ctrAlone = this.addCtr(new ObjMaximum.ObjMaximumGE(this, scp, limit), new Types.TypeClass[0]);
            } else {
                Kit.control(type == Types.TypeObjective.NVALUES);
                ctrAlone = this.addCtr(new NValues.NValuesGE(this, scp, limit), new Types.TypeClass[0]);
            }
        }
        return this.buildOptimizationPilot(minimization ? Types.TypeOptimization.MIN : Types.TypeOptimization.MAX, (OptimizationCompatible)ctrAlone.ctr);
    }

    public final ObjEntities.ObjEntity minimize(Types.TypeObjective type, IVar[] list) {
        Kit.control(type != Types.TypeObjective.EXPRESSION, () -> "Value EXPRESSION irrelevant here");
        if (this.rs.cp.general.limitForSatisfaction != Long.MAX_VALUE) {
            this.switchToSatsfaction();
            if (type == Types.TypeObjective.SUM) {
                this.addCtr(new SumSimple.SumSimpleLE(this, this.translate(list), this.rs.cp.general.limitForSatisfaction), new Types.TypeClass[0]);
            } else if (type == Types.TypeObjective.MINIMUM) {
                Kit.exit("Kind of optimization not currently implemented " + type);
            } else if (type == Types.TypeObjective.MAXIMUM) {
                Stream.of(list).forEach(x -> this.lessEqual(x, this.rs.cp.general.limitForSatisfaction));
            } else if (type == Types.TypeObjective.NVALUES) {
                this.addCtr(new NValues.NValuesLE(this, this.translate(list), (int)this.rs.cp.general.limitForSatisfaction), new Types.TypeClass[0]);
            } else {
                Kit.exit("Kind of optimization not currently implemented " + type);
            }
            return null;
        }
        this.optimizationPilot = this.optimizationPilotFor(type, list, true);
        return this.postObj((IObj)IObj.IObjSpecialized.buildFrom((IVar[])list, (boolean)true, (Types.TypeObjective)type, (String)this.varEntities.compactOrdered(list), null));
    }

    public final ObjEntities.ObjEntity maximize(Types.TypeObjective type, IVar[] list) {
        Kit.control(type != Types.TypeObjective.EXPRESSION, () -> "Value EXPRESSION irrelevant here");
        if (this.rs.cp.general.limitForSatisfaction != Long.MAX_VALUE) {
            this.switchToSatsfaction();
            if (type == Types.TypeObjective.SUM) {
                this.addCtr(new SumSimple.SumSimpleGE(this, this.translate(list), this.rs.cp.general.limitForSatisfaction), new Types.TypeClass[0]);
            } else if (type == Types.TypeObjective.MINIMUM) {
                Stream.of(list).forEach(x -> this.greaterEqual(x, this.rs.cp.general.limitForSatisfaction));
            } else if (type == Types.TypeObjective.MAXIMUM) {
                Kit.exit("Kind of optimization not currently implemented " + type);
            } else {
                Kit.exit("Kind of optimization not currently implemented " + type);
            }
            return null;
        }
        this.optimizationPilot = this.optimizationPilotFor(type, list, false);
        return this.postObj((IObj)IObj.IObjSpecialized.buildFrom((IVar[])list, (boolean)false, (Types.TypeObjective)type, (String)this.varEntities.compactOrdered(list), null));
    }

    public final ObjEntities.ObjEntity minimize(Types.TypeObjective type, IVar[] list, int[] coeffs) {
        Kit.control(type != Types.TypeObjective.EXPRESSION, () -> "Value EXPRESSION irrelevant here");
        if (this.rs.cp.general.limitForSatisfaction != Long.MAX_VALUE) {
            this.switchToSatsfaction();
            if (type == Types.TypeObjective.SUM) {
                this.sum1((VariableInteger[])list, coeffs, Types.TypeConditionOperatorRel.LE, this.rs.cp.general.limitForSatisfaction, false);
            } else {
                Kit.exit("Kind of optimization not currently implemented " + type);
            }
            return null;
        }
        CtrEntities.CtrAlone ctrAlone = null;
        if (type == Types.TypeObjective.SUM) {
            ctrAlone = (CtrEntities.CtrAlone)this.sum1(this.translate(list), coeffs, Types.TypeConditionOperatorRel.LE, this.rs.cp.optimizing.upperBound, false);
            this.optimizationPilot = this.buildOptimizationPilot(Types.TypeOptimization.MIN, (OptimizationCompatible)ctrAlone.ctr);
        } else {
            Kit.exit("Kind of optimization not currently implemented " + type);
        }
        return this.postObj((IObj)IObj.IObjSpecialized.buildFrom((IVar[])list, (boolean)true, (Types.TypeObjective)type, (String)this.varEntities.compactOrdered(list), (String)Kit.join((Object)coeffs, new String[0])));
    }

    public final ObjEntities.ObjEntity maximize(Types.TypeObjective type, IVar[] list, int[] coeffs) {
        Kit.control(type != Types.TypeObjective.EXPRESSION, () -> "Value EXPRESSION irrelevant here");
        if (this.rs.cp.general.limitForSatisfaction != Long.MAX_VALUE) {
            this.switchToSatsfaction();
            if (type == Types.TypeObjective.SUM) {
                this.sum1((VariableInteger[])list, coeffs, Types.TypeConditionOperatorRel.GE, this.rs.cp.general.limitForSatisfaction, false);
            } else {
                Kit.exit("Kind of optimization not currently implemented " + type);
            }
            return null;
        }
        CtrEntities.CtrAlone ctrAlone = null;
        if (type == Types.TypeObjective.SUM) {
            ctrAlone = (CtrEntities.CtrAlone)this.sum1(this.translate(list), coeffs, Types.TypeConditionOperatorRel.GE, this.rs.cp.optimizing.lowerBound, false);
            this.optimizationPilot = this.buildOptimizationPilot(Types.TypeOptimization.MAX, (OptimizationCompatible)ctrAlone.ctr);
        } else {
            Kit.exit("Kind of optimization not currently implemented " + type);
        }
        return this.postObj((IObj)IObj.IObjSpecialized.buildFrom((IVar[])list, (boolean)false, (Types.TypeObjective)type, (String)this.varEntities.compactOrdered(list), (String)Kit.join((Object)coeffs, new String[0])));
    }

    private ObjEntities.ObjEntity optimizeTreeBasedObjective(boolean minimization, Types.TypeObjective type, XNode<IVar>[] trees, int[] coeffs) {
        Kit.control(type.generalizable(), () -> "Kind of optimization not currently generalizable " + type);
        IVar.Var[] tmp = this.replaceByAuxiliaryVariables(trees);
        if (coeffs == null) {
            return minimization ? this.minimize(type, (IVar[])tmp) : this.maximize(type, (IVar[])tmp);
        }
        CtrEntities.CtrAlone ctrAlone = (CtrEntities.CtrAlone)this.sum1(this.translate((IVar[])tmp), coeffs == null ? Kit.repeat(1, trees.length) : coeffs, minimization ? Types.TypeConditionOperatorRel.LE : Types.TypeConditionOperatorRel.GE, minimization ? this.rs.cp.optimizing.upperBound : this.rs.cp.optimizing.lowerBound, false);
        this.optimizationPilot = this.buildOptimizationPilot(minimization ? Types.TypeOptimization.MIN : Types.TypeOptimization.MAX, (OptimizationCompatible)ctrAlone.ctr);
        return this.postObj((IObj)IObj.IObjSpecialized.buildFrom((IVar[])tmp, (boolean)false, (Types.TypeObjective)type, (String)this.varEntities.compactOrdered((IVar[])tmp), coeffs == null ? null : Kit.join((Object)coeffs, new String[0])));
    }

    public ObjEntities.ObjEntity minimize(Types.TypeObjective type, XNode<IVar>[] trees) {
        return this.optimizeTreeBasedObjective(true, type, trees, null);
    }

    public ObjEntities.ObjEntity minimize(Types.TypeObjective type, XNode<IVar>[] trees, int[] coeffs) {
        return this.optimizeTreeBasedObjective(true, type, trees, coeffs);
    }

    public ObjEntities.ObjEntity maximize(Types.TypeObjective type, XNode<IVar>[] trees) {
        return this.optimizeTreeBasedObjective(false, type, trees, null);
    }

    public ObjEntities.ObjEntity maximize(Types.TypeObjective type, XNode<IVar>[] trees, int[] coeffs) {
        return this.optimizeTreeBasedObjective(false, type, trees, coeffs);
    }

    public void decisionVariables(IVar[] list) {
        if (this.rs.cp.general.enableAnnotations) {
            super.decisionVariables(list);
        }
    }

    private /* synthetic */ void lambda$extremum$135(Variable y, Variable[] vars, boolean minimum, int i) {
        if (y != vars[i]) {
            if (minimum) {
                this.lessEqual(y, vars[i]);
            } else {
                this.greaterEqual(y, vars[i]);
            }
        }
    }

    private static class Term
    implements Comparable<Term> {
        int coeff;
        Variable var;

        private Term(int coeff, Variable var) {
            this.coeff = coeff;
            this.var = var;
        }

        @Override
        public int compareTo(Term term) {
            return this.coeff - term.coeff;
        }

        public String toString() {
            return this.coeff + "*" + this.var;
        }
    }
}

