/*
 * Decompiled with CFR 0.152.
 */
package problem;

import constraints.Constraint;
import constraints.CtrHard;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.xcsp.common.IVar;
import problem.Problem;
import utility.Kit;
import variables.Variable;
import variables.VariableInteger;

public final class IdentificationAllDifferent {
    private Problem pb;
    private int[][] irreflexives;
    private int[] degrees;
    private int[] levels;
    public int nBuiltCliques;

    private int[][] computeIrreflexives() {
        Set[] neighbours = (Set[])IntStream.range(0, this.pb.variables.length).mapToObj(i -> new TreeSet()).toArray(TreeSet[]::new);
        for (Constraint c : this.pb.stuff.collectedCtrsAtInit) {
            if (c.scp.length != 2 || !((CtrHard)c).isIrreflexive()) continue;
            int num0 = c.scp[0].num;
            int num1 = c.scp[1].num;
            neighbours[num0].add(num1);
            neighbours[num1].add(num0);
        }
        return Kit.intArray2D(neighbours);
    }

    private int countNeighboursFromAtLevel(int vnum, int level) {
        return (int)IntStream.of(this.irreflexives[vnum]).filter(nghNum -> this.levels[nghNum] == level).count();
    }

    private int buildClique(int cliqueId) {
        int level = 0;
        int varNum = -1;
        for (int i2 = 0; i2 < this.levels.length; ++i2) {
            if (this.levels[i2] != 0 || varNum != -1 && this.degrees[i2] <= this.degrees[varNum]) continue;
            varNum = i2;
        }
        while (varNum != -1) {
            int[] nghs;
            this.levels[varNum] = level + 1;
            for (int nghNum : nghs = this.irreflexives[varNum]) {
                if (this.levels[nghNum] != level) continue;
                this.levels[nghNum] = level + 2;
            }
            for (int nghNum : nghs) {
                if (this.levels[nghNum] != level + 2) continue;
                this.degrees[nghNum] = this.countNeighboursFromAtLevel(nghNum, level + 2);
            }
            level += 2;
            varNum = -1;
            for (int i3 : nghs) {
                if (this.levels[i3] != level || varNum != -1 && this.degrees[i3] <= this.degrees[varNum]) continue;
                varNum = i3;
            }
        }
        int cliqueSize = 0;
        for (int i4 = 0; i4 < this.levels.length; ++i4) {
            if (this.levels[i4] < 0) continue;
            if (this.levels[i4] % 2 != 0) {
                this.levels[i4] = -cliqueId;
                ++cliqueSize;
                continue;
            }
            this.levels[i4] = 0;
        }
        if (cliqueSize > this.pb.rs.cp.constraints.inferAllDifferentSize) {
            Object[] scp = (VariableInteger[])IntStream.range(0, this.levels.length).filter(i -> this.levels[i] == -cliqueId).mapToObj(i -> this.pb.variables[i]).toArray(VariableInteger[]::new);
            Arrays.sort(scp);
            this.pb.allDifferent((IVar.Var[])scp);
            ++this.nBuiltCliques;
            this.display(cliqueId, cliqueSize);
            assert (this.controlClique((Variable[])scp));
            for (int i5 = 0; i5 < this.degrees.length; ++i5) {
                this.degrees[i5] = this.countNeighboursFromAtLevel(i5, 0);
            }
        }
        return cliqueSize;
    }

    public IdentificationAllDifferent(Problem pb) {
        this.pb = pb;
        this.irreflexives = this.computeIrreflexives();
        this.degrees = IntStream.range(0, pb.variables.length).map(i -> this.irreflexives[i].length).toArray();
        this.levels = new int[pb.variables.length];
        for (int i2 = 1; i2 <= pb.rs.cp.constraints.inferAllDifferentNb && this.buildClique(i2) > pb.rs.cp.constraints.inferAllDifferentSize; ++i2) {
        }
    }

    private boolean controlClique(Variable[] vars) {
        for (int i = 0; i < vars.length; ++i) {
            for (int j = i + 1; j < vars.length; ++j) {
                Variable x = vars[i];
                Variable y = vars[j];
                Kit.control(this.pb.stuff.collectedCtrsAtInit.stream().anyMatch(c -> c.scp.length == 2 && ((CtrHard)c).isIrreflexive() && c.involves(x, y)), () -> "not a clique with " + x + " " + y);
            }
        }
        return true;
    }

    private void display(int cliqueId, int cliqueSize) {
        Kit.log.fine(" clique " + cliqueId + " of size " + cliqueSize + " {" + IntStream.range(0, this.levels.length).filter(i -> this.levels[i] == -cliqueId).mapToObj(i -> i + "").collect(Collectors.joining(" ")) + "}");
    }
}

