/*
 * Decompiled with CFR 0.152.
 */
package objectives;

import objectives.ObjMaximum;
import org.xcsp.common.Types;
import problem.Problem;
import utility.Kit;
import variables.Variable;

public final class ObjMaximumGE
extends ObjMaximum {
    private int sentinel1 = 0;
    private int sentinel2;

    public ObjMaximumGE(Problem pb, Variable[] scp, int limit) {
        super(pb, scp, limit);
        this.sentinel2 = scp.length - 1;
        Kit.control(scp[this.sentinel1].dom.lastValue() >= limit && scp[this.sentinel2].dom.lastValue() >= limit, () -> "unsound sentinels");
    }

    @Override
    public boolean runPropagator(Variable x) {
        int i;
        if (this.scp[this.sentinel1].dom.lastValue() < this.limit) {
            for (i = 0; i < this.scp.length && (i == this.sentinel2 || this.scp[i].dom.lastValue() < this.limit); ++i) {
            }
            if (i < this.scp.length) {
                this.sentinel1 = i;
            } else {
                if (this.scp[this.sentinel2].dom.lastValue() < this.limit) {
                    return x.dom.fail();
                }
                return this.scp[this.sentinel2].dom.removeValues(Types.TypeOperatorRel.LT, this.limit);
            }
        }
        if (this.scp[this.sentinel2].dom.lastValue() < this.limit) {
            for (i = 0; i < this.scp.length && (i == this.sentinel1 || this.scp[i].dom.lastValue() < this.limit); ++i) {
            }
            if (i < this.scp.length) {
                this.sentinel2 = i;
            } else {
                assert (this.scp[this.sentinel1].dom.lastValue() >= this.limit);
                return this.scp[this.sentinel2].dom.removeValues(Types.TypeOperatorRel.LT, this.limit);
            }
        }
        return true;
    }
}

