/*
 * Decompiled with CFR 0.152.
 */
package learning;

import java.util.HashMap;
import java.util.Map;
import java.util.zip.Deflater;
import learning.LearnerStates;
import search.backtrack.SolverBacktrack;
import utility.Enums;
import utility.Kit;
import utility.operations.Bit;
import variables.Variable;
import variables.domains.Domain;

public final class LearnerStatesEquivalence
extends LearnerStates {
    private static final Integer zero = new Integer(0);
    private Map<Kit.ByteArrayHashKey, Integer> mapOfHashKeys = new HashMap<Kit.ByteArrayHashKey, Integer>(2000);
    private Kit.ByteArrayHashKey[] currentOpenNodesKeys;
    private int[] currentOpenNodesNbFoundSolutions;
    private Kit.ByteArrayHashKey currentHashKey;
    private boolean moreThanOneSolution;
    private int nbBytesPerVariableId;
    private Deflater compressor;
    private byte[] tmpInput = new byte[50000];
    private byte[] tmpOutput = new byte[20000];
    public int nbTooLargeKeys;
    public int nbInferredSolutions;

    public int getMapSize() {
        return this.mapOfHashKeys.size();
    }

    @Override
    public void clear() {
        this.mapOfHashKeys.clear();
    }

    public LearnerStatesEquivalence(SolverBacktrack solver) {
        super(solver);
        if (solver.pb.variables.length > 1500) {
            this.stop = true;
        }
        this.currentOpenNodesKeys = new Kit.ByteArrayHashKey[this.variables.length];
        this.currentOpenNodesNbFoundSolutions = new int[this.variables.length];
        boolean bl = this.moreThanOneSolution = solver.solManager.nSolutionsLimit > 1L;
        int n = (double)this.variables.length <= Math.pow(2.0, 8.0) ? 1 : ((double)this.variables.length <= Math.pow(2.0, 16.0) ? 2 : (this.nbBytesPerVariableId = (double)this.variables.length <= Math.pow(2.0, 24.0) ? 3 : 4));
        if (solver.rs.cp.learning.compressionLevelForStateEquivalence != 0) {
            this.compressor = new Deflater(solver.rs.cp.learning.compressionLevelForStateEquivalence);
        }
    }

    @Override
    protected boolean mustStop() {
        if (super.mustStop()) {
            return true;
        }
        int nbGlobalKeys = this.mapOfHashKeys.size() + this.nbTooLargeKeys;
        return nbGlobalKeys > 1000 && nbGlobalKeys > 1000 * this.nbInferences;
    }

    private byte[] compress(int limit) {
        assert (limit >= this.solver.rs.cp.learning.compressionLimitForStateEquivalence);
        this.compressor.reset();
        this.compressor.setInput(this.tmpInput, 0, limit);
        this.compressor.finish();
        int count = this.compressor.deflate(this.tmpOutput);
        if (!this.compressor.finished()) {
            byte[] t = new byte[limit];
            System.arraycopy(this.tmpInput, 0, t, 0, limit);
            return t;
        }
        byte[] t = new byte[count];
        System.arraycopy(this.tmpOutput, 0, t, 0, count);
        return t;
    }

    private void buildHashKey() {
        int[] ids = this.moreThanOneSolution ? this.reductionOperator.extractForAllSolutions() : this.reductionOperator.extract();
        int keySize = 0;
        for (int i = 0; i < ids.length; ++i) {
            Variable var = this.solver.pb.variables[ids[i]];
            Domain dom = var.dom;
            if (keySize + this.nbBytesPerVariableId + dom.initSize() / 8 >= this.tmpInput.length) {
                keySize = -1;
                break;
            }
            keySize = Bit.convert(var.num, this.nbBytesPerVariableId, this.tmpInput, keySize);
            keySize = Bit.convert(dom.binaryRepresentation(), dom.initSize(), this.tmpInput, keySize);
        }
        if (this.currentHashKey == null) {
            this.currentHashKey = new Kit.ByteArrayHashKey();
        }
        if (keySize == -1) {
            this.currentHashKey.t = null;
            ++this.nbTooLargeKeys;
        } else {
            byte[] t = null;
            if (this.compressor == null || keySize < this.solver.rs.cp.learning.compressionLimitForStateEquivalence) {
                t = new byte[keySize];
                System.arraycopy(this.tmpInput, 0, t, 0, keySize);
            } else {
                t = this.compress(keySize);
            }
            this.currentHashKey.t = t;
        }
    }

    @Override
    public boolean dealWhenOpeningNode() {
        if (this.stop) {
            return true;
        }
        int level = this.solver.depth();
        if (level == this.variables.length) {
            return true;
        }
        this.buildHashKey();
        if (this.currentHashKey.t == null) {
            this.currentOpenNodesKeys[level] = null;
            return true;
        }
        Integer value = this.mapOfHashKeys.get(this.currentHashKey);
        if (value != null) {
            ++this.nbInferences;
            if (value > 0) {
                this.nbInferredSolutions += value.intValue();
                this.solver.solManager.nSolutionsFound += (long)value.intValue();
            }
            return false;
        }
        this.currentOpenNodesKeys[level] = this.currentHashKey;
        this.currentHashKey = null;
        this.currentOpenNodesNbFoundSolutions[level] = (int)this.solver.solManager.nSolutionsFound;
        return true;
    }

    @Override
    public void dealWhenClosingNode() {
        int nbSolutions;
        if (this.stop) {
            return;
        }
        if (this.mustStop()) {
            Kit.log.info("Stopping use of transposition table (mapSize=" + this.mapOfHashKeys.size() + ", nbTooLargekeys=" + this.nbTooLargeKeys + ", mem=" + Kit.getFormattedUsedMemorySize() + ")");
            this.mapOfHashKeys.clear();
            this.stop = true;
            return;
        }
        Kit.ByteArrayHashKey hashKey = this.currentOpenNodesKeys[this.solver.depth()];
        if (hashKey == null) {
            return;
        }
        if (hashKey.t.length == 0) {
            this.solver.stoppingType = Enums.EStopping.FULL_EXPLORATION;
        }
        this.mapOfHashKeys.put(hashKey, (nbSolutions = (int)this.solver.solManager.nSolutionsFound - this.currentOpenNodesNbFoundSolutions[this.solver.depth()]) == 0 ? zero : nbSolutions);
    }

    @Override
    public void displayStats() {
        if (!this.stop) {
            Kit.log.finer("  mapSize=" + this.mapOfHashKeys.size() + "  nbInferences=" + this.nbInferences + "  nbInferredSolutions=" + this.nbInferredSolutions + "  usedMem=" + Kit.getFormattedUsedMemorySize() + "  nbTooLargeKeys=" + this.nbTooLargeKeys);
        }
    }
}

