/*
 * Decompiled with CFR 0.152.
 */
package learning;

import constraints.Constraint;
import learning.LearnerStates;
import search.Solver;
import utility.Enums;
import utility.observers.ObserverDomainReduction;
import variables.Variable;
import variables.domains.Domain;

public final class Justifier
implements ObserverDomainReduction {
    public final Constraint[][] justifications;
    private final Solver solver;

    public Justifier(LearnerStates learner) {
        this.solver = learner.solver;
        if (this.solver.rs.cp.learning.state != Enums.ELearningState.NO) {
            Variable[] vars = learner.solver.pb.variables;
            this.justifications = new Constraint[vars.length][];
            for (int i = 0; i < this.justifications.length; ++i) {
                Domain dom = vars[i].dom;
                this.justifications[i] = new Constraint[dom.initSize()];
                for (int idx = 0; idx < this.justifications[i].length; ++idx) {
                    if (dom.isPresent(idx)) continue;
                    this.justifications[i][idx] = Constraint.TAG;
                }
            }
            this.solver.pb.observersDomainReduction.add(this);
        } else {
            this.justifications = null;
        }
    }

    @Override
    public void actAfterRemoval(Variable x, int a) {
        this.justifications[x.num][a] = this.solver.depth() == 0 ? Constraint.TAG : this.solver.propagation.currFilteringCtr;
    }

    @Override
    public void actAfterRemovals(Variable x, int nbRemovals) {
        Constraint c = this.solver.depth() == 0 ? Constraint.TAG : this.solver.propagation.currFilteringCtr;
        int a = x.dom.lastRemoved();
        for (int cnt = 0; cnt < nbRemovals; ++cnt) {
            this.justifications[x.num][a] = c;
            a = x.dom.prevRemoved(a);
        }
    }
}

