/*
 * Decompiled with CFR 0.152.
 */
package heuristics.variables.fixed;

import heuristics.variables.HeuristicVariablesFixed;
import search.backtrack.SolverBacktrack;
import utility.interfaces.TagExperimental;
import variables.Variable;

public class CrossCID
extends HeuristicVariablesFixed
implements TagExperimental {
    private int nRows;
    private int nCols;

    public CrossCID(SolverBacktrack solver, boolean antiHeuristic) {
        super(solver, antiHeuristic);
        this.nRows = solver.pb.stuff.minCtrArity();
        this.nCols = solver.pb.stuff.maxCtrArity();
    }

    @Override
    public double scoreOf(Variable x) {
        int rowDistance = this.nRows - (x.num / this.nCols + 1);
        int colDistance = this.nCols - (x.num % this.nCols + 1);
        return Math.sqrt(rowDistance * rowDistance + colDistance * colDistance);
    }

    @Override
    protected Variable bestUnpriorityVar() {
        Variable x;
        assert (this.solver.futVars.size() > 0);
        if (this.solver.rs.cp.varh.lastConflictSize > 0 && (x = this.solver.lcReasoner.lastConflictPriorityVar()) != null) {
            return x;
        }
        return super.bestUnpriorityVar();
    }
}

