/*
 * Decompiled with CFR 0.152.
 */
package heuristics.variables;

import heuristics.variables.HeuristicVariables;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import search.backtrack.SolverBacktrack;
import utility.Kit;
import utility.exceptions.UnreachableCodeException;
import utility.observers.ObserverRuns;
import variables.Variable;

public abstract class HeuristicVariablesFixed
extends HeuristicVariables
implements ObserverRuns {
    private int nbRunsBeforeReinitializing = Integer.MAX_VALUE;
    private Variable[] orderedVars;

    @Override
    public final void beforeRun() {
        if (this.solver.restarter.numRun != 0 && this.solver.restarter.numRun % this.nbRunsBeforeReinitializing == 0) {
            this.buildOrder();
        }
    }

    @Override
    public final void afterRun() {
    }

    private void buildOrder() {
        Map<Variable, Double> map = Stream.of(this.solver.pb.variables).collect(Collectors.toMap(x -> x, x -> this.scoreOf((Variable)x) * (double)this.scoreCoeff));
        map = Kit.sort(map, (e1, e2) -> (Double)e1.getValue() > (Double)e2.getValue() ? -1 : ((Double)e1.getValue() < (Double)e2.getValue() ? 1 : ((Variable)e1.getKey()).num - ((Variable)e2.getKey()).num));
        this.orderedVars = (Variable[])map.entrySet().stream().map(e -> (Variable)e.getKey()).toArray(Variable[]::new);
        Kit.log.info("Static order of variables : " + Kit.join((Object)this.orderedVars, new String[0]));
    }

    public HeuristicVariablesFixed(SolverBacktrack solver, boolean antiHeuristic) {
        super(solver, antiHeuristic);
        this.buildOrder();
    }

    @Override
    protected Variable bestUnpriorityVar() {
        int i;
        assert (this.solver.pb.priorityVars.length == 0);
        int n = i = this.solver.propagation.performingProperSearch ? 0 : this.solver.futVars.nDiscarded();
        while (i < this.orderedVars.length) {
            if (this.orderedVars[i].isFuture()) {
                return this.orderedVars[i];
            }
            ++i;
        }
        throw new UnreachableCodeException();
    }
}

