/*
 * Decompiled with CFR 0.152.
 */
package heuristics.values.direct;

import heuristics.values.HeuristicValuesDirect;
import propagation.soft.pfc.PFC;
import propagation.soft.sac.SoftAC;
import utility.Kit;
import utility.exceptions.UnreachableCodeException;
import utility.interfaces.TagExperimental;
import variables.Variable;

public final class MinCost
extends HeuristicValuesDirect
implements TagExperimental {
    private long[] unaryCosts;
    private int[] argMinSumMinCosts;

    public MinCost(Variable x, boolean dummy) {
        super(x, dummy);
        Kit.control(x.pb.solver.propagation instanceof SoftAC || x.pb.solver.propagation instanceof PFC);
        if (x.pb.solver.propagation instanceof SoftAC) {
            this.unaryCosts = ((SoftAC)x.pb.solver.propagation).c1s[x.num];
        } else {
            this.argMinSumMinCosts = ((PFC)x.pb.solver.propagation).argMinSumMinCosts;
        }
    }

    @Override
    public int bestValueIndex() {
        if (this.unaryCosts != null) {
            int a = this.dx.first();
            while (a != -1) {
                if (this.unaryCosts[a] == 0L) {
                    return a;
                }
                a = this.dx.next(a);
            }
            throw new UnreachableCodeException("Necessarily, one value with unary cost at 0");
        }
        assert (this.dx.isPresent(this.argMinSumMinCosts[this.x.num]));
        return this.argMinSumMinCosts[this.x.num];
    }
}

