/*
 * Decompiled with CFR 0.152.
 */
package heuristics.values;

import heuristics.values.HeuristicValues;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import utility.Kit;
import utility.exceptions.UnreachableCodeException;
import variables.Variable;

public abstract class HeuristicValuesFixed
extends HeuristicValues {
    private final int[] orderedIdxs;

    public HeuristicValuesFixed(Variable x, boolean antiHeuristic) {
        super(x, antiHeuristic);
        Map<Integer, Double> map = IntStream.range(0, this.dx.initSize()).filter(a -> this.dx.isPresent(a)).boxed().collect(Collectors.toMap(a -> a, a -> this.scoreOf((int)a) * (double)this.scoreCoeff));
        map = Kit.sort(map, (e1, e2) -> (Double)e1.getValue() > (Double)e2.getValue() ? -1 : ((Double)e1.getValue() < (Double)e2.getValue() ? 1 : (Integer)e1.getKey() - (Integer)e2.getKey()));
        this.orderedIdxs = map.entrySet().stream().mapToInt(e -> (Integer)e.getKey()).toArray();
    }

    @Override
    public final int bestValueIndex() {
        assert (this.dx.size() > 0) : "The domain is empty";
        for (int a : this.orderedIdxs) {
            if (!this.dx.isPresent(a)) continue;
            return a;
        }
        throw new UnreachableCodeException();
    }
}

