/*
 * Decompiled with CFR 0.152.
 */
package constraints.soft.extension.structures;

import constraints.Constraint;
import constraints.soft.extension.structures.ExtensionStructureSoft;
import utility.Kit;
import utility.exceptions.UnreachableCodeException;
import variables.domains.Domain;

public class SoftMatrix4D
extends ExtensionStructureSoft {
    protected long[][][][] costsMatrix;

    @Override
    public void projectAndStack(int vap, int idx, long cost) {
        throw new UnreachableCodeException();
    }

    @Override
    public void storeTuplesAndCosts(int[][] tuples, long[] costs, long defaultCost) {
        int i;
        super.storeTuplesAndCosts(tuples, costs, defaultCost);
        assert (this.registeredCtrs().size() == 1 && tuples.length == costs.length);
        Constraint ctr = this.firstRegisteredCtr();
        Domain dom0 = ctr.scp[0].dom;
        Domain dom1 = ctr.scp[1].dom;
        Domain dom2 = ctr.scp[2].dom;
        Domain dom3 = ctr.scp[3].dom;
        this.costsMatrix = new long[dom0.initSize()][dom1.initSize()][dom2.initSize()][dom3.initSize()];
        for (i = 0; i < this.costsMatrix.length; ++i) {
            for (int j = 0; j < this.costsMatrix[i].length; ++j) {
                for (int k = 0; k < this.costsMatrix[i][j].length; ++k) {
                    for (int l = 0; l < this.costsMatrix[i][j][k].length; ++l) {
                        this.costsMatrix[i][j][k][l] = defaultCost;
                    }
                }
            }
        }
        if (ctr.indexesMatchValues) {
            for (i = 0; i < tuples.length; ++i) {
                this.costsMatrix[tuples[i][0]][tuples[i][1]][tuples[i][2]][tuples[i][3]] = costs[i];
            }
        } else {
            for (i = 0; i < tuples.length; ++i) {
                this.costsMatrix[dom0.toIdx((int)tuples[i][0])][dom1.toIdx((int)tuples[i][1])][dom2.toIdx((int)tuples[i][2])][dom3.toIdx((int)tuples[i][3])] = costs[i];
            }
        }
    }

    public SoftMatrix4D(Constraint ctr) {
        super(ctr);
        Kit.control(ctr.scp.length == 4);
    }

    @Override
    public long getCostOfIdxs(int[] tuple) {
        return this.costsMatrix[tuple[0]][tuple[1]][tuple[2]][tuple[3]];
    }

    @Override
    public String getStringListOfTuples() {
        return null;
    }
}

