/*
 * Decompiled with CFR 0.152.
 */
package constraints.soft.extension.structures;

import constraints.Constraint;
import constraints.soft.extension.structures.SoftMatrix3DTransfert;
import utility.operations.Calculator;
import utility.sets.SetSparseMapLong;

public class SoftMatrix3DTransfertDelta
extends SoftMatrix3DTransfert {
    private long[] deltas0;
    private long[] deltas1;
    private long[] deltas2;

    @Override
    protected void project(int vap, int idx, long cost) {
        assert (cost != 0L);
        if (vap == 0) {
            Calculator.add(this.deltas0, idx, cost);
        } else if (vap == 1) {
            Calculator.add(this.deltas1, idx, cost);
        } else {
            Calculator.add(this.deltas2, idx, cost);
        }
        Calculator.add(this.scopeC1s[vap], idx, cost);
    }

    @Override
    public void projectAndStack(int vap, int idx, long cost) {
        int index;
        if (this.solver.depth() != this.lastModificationDepth()) {
            this.solver.observerCtrsSoft.push(this);
            ++this.top;
            this.stackedLevels[this.top] = this.solver.depth();
            if (this.sparseMaps[this.top] == null) {
                this.sparseMaps[this.top] = new SetSparseMapLong(this.sparseMaps[this.top - 1].capacity(), false);
            } else {
                this.sparseMaps[this.top].clear();
            }
        }
        if (!this.sparseMaps[this.top].isPresent(index = this.cumulatedSizes[vap] + idx)) {
            this.sparseMaps[this.top].add(index, vap == 0 ? this.deltas0[idx] : (vap == 1 ? this.deltas1[idx] : this.deltas2[idx]));
        }
        this.project(vap, idx, cost);
    }

    public SoftMatrix3DTransfertDelta(Constraint ctr) {
        super(ctr);
        this.deltas0 = new long[ctr.scp[0].dom.initSize()];
        this.deltas1 = new long[ctr.scp[1].dom.initSize()];
        this.deltas2 = new long[ctr.scp[2].dom.initSize()];
    }

    @Override
    public long getCostOfIdxs(int[] tuple) {
        long l1 = Calculator.add(this.costsMatrix[tuple[0]][tuple[1]][tuple[2]], -this.deltas0[tuple[0]]);
        long l2 = Calculator.add(l1, -this.deltas1[tuple[1]]);
        long c = Calculator.add(l2, -this.deltas2[tuple[2]]);
        return c;
    }

    @Override
    public void restoreAtDepthBefore(int depthBeforeBacktrack) {
        assert (this.stackedLevels[this.top] == depthBeforeBacktrack);
        int[] dense = this.sparseMaps[this.top].dense;
        for (int i = this.sparseMaps[this.top].limit; i >= 0; --i) {
            long gap;
            int idx = dense[i];
            long delta = this.sparseMaps[this.top].values[idx];
            if (idx < this.cumulatedSizes[1]) {
                long gap2 = Calculator.add(this.deltas0[idx], -delta);
                Calculator.add(this.scopeC1s[0], idx, -gap2);
                this.deltas0[idx] = delta;
                continue;
            }
            if (idx < this.cumulatedSizes[2]) {
                int index = idx - this.cumulatedSizes[1];
                gap = Calculator.add(this.deltas1[index], -delta);
                Calculator.add(this.scopeC1s[1], index, -gap);
                this.deltas1[index] = delta;
                continue;
            }
            int index = idx - this.cumulatedSizes[2];
            gap = Calculator.add(this.deltas2[index], -delta);
            Calculator.add(this.scopeC1s[2], index, -gap);
            this.deltas2[index] = delta;
        }
        --this.top;
    }
}

