/*
 * Decompiled with CFR 0.152.
 */
package constraints.soft.extension.structures;

import constraints.Constraint;
import constraints.soft.extension.structures.ExtensionStructureSoft;
import org.xcsp.common.Types;
import utility.Kit;
import utility.exceptions.MissingImplementationException;
import variables.domains.Domain;

public class SoftMatrix3D
extends ExtensionStructureSoft {
    protected long[][][] costsMatrix;

    @Override
    public void projectAndStack(int vap, int idx, long cost) {
        throw new MissingImplementationException();
    }

    @Override
    public void storeTuplesAndCosts(int[][] tuples, long[] costs, long defaultCost) {
        int i;
        super.storeTuplesAndCosts(tuples, costs, defaultCost);
        assert (this.registeredCtrs().size() == 1 && tuples.length == costs.length);
        Constraint ctr = this.firstRegisteredCtr();
        Domain dom0 = ctr.scp[0].dom;
        Domain dom1 = ctr.scp[1].dom;
        Domain dom2 = ctr.scp[2].dom;
        this.costsMatrix = new long[dom0.initSize()][dom1.initSize()][dom2.initSize()];
        for (i = 0; i < this.costsMatrix.length; ++i) {
            for (int j = 0; j < this.costsMatrix[i].length; ++j) {
                for (int k = 0; k < this.costsMatrix[i][j].length; ++k) {
                    this.costsMatrix[i][j][k] = defaultCost;
                }
            }
        }
        if (ctr.indexesMatchValues) {
            for (i = 0; i < tuples.length; ++i) {
                this.costsMatrix[tuples[i][0]][tuples[i][1]][tuples[i][2]] = costs[i];
            }
        } else {
            for (i = 0; i < tuples.length; ++i) {
                this.costsMatrix[dom0.toIdx((int)tuples[i][0])][dom1.toIdx((int)tuples[i][1])][dom2.toIdx((int)tuples[i][2])] = costs[i];
            }
        }
    }

    public SoftMatrix3D(Constraint ctr) {
        super(ctr);
        Kit.control(ctr.scp.length == 3);
    }

    @Override
    public long getCostOfIdxs(int[] tuple) {
        return this.costsMatrix[tuple[0]][tuple[1]][tuple[2]];
    }

    @Override
    public String getStringListOfTuples() {
        Constraint ctr = this.firstRegisteredCtr();
        Domain dom0 = ctr.scp[0].dom;
        Domain dom1 = ctr.scp[1].dom;
        Domain dom2 = ctr.scp[2].dom;
        StringBuilder sb = new StringBuilder();
        long currentCost = -1L;
        int[] t = new int[3];
        int cnt = 0;
        for (int i = 0; i < this.costsMatrix.length; ++i) {
            t[0] = dom0.toVal(i);
            for (int j = 0; j < this.costsMatrix[i].length; ++j) {
                t[1] = dom1.toVal(j);
                for (int k = 0; k < this.costsMatrix[i][j].length; ++k) {
                    t[2] = dom2.toVal(k);
                    if (this.costsMatrix[i][j][k] == this.defaultCost) continue;
                    ++cnt;
                    if (this.costsMatrix[i][j][k] != currentCost) {
                        currentCost = this.costsMatrix[i][j][k];
                        sb.append(currentCost).append(":");
                    }
                    Kit.join(sb, (Object)t, new String[0]).append('|');
                }
            }
        }
        return sb.append("#").append("soft").append(cnt).append(Types.TypeAtt.defaultCost.name()).append(this.defaultCost).toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("matrix3D ");
        for (int i = 0; i < this.costsMatrix.length; ++i) {
            sb.append(i + " :: " + Kit.join((Object)this.costsMatrix[i], new String[0]) + "\n");
        }
        return sb.toString();
    }
}

