/*
 * Decompiled with CFR 0.152.
 */
package constraints.soft.extension.structures;

import constraints.Constraint;
import constraints.soft.extension.structures.SoftMatrix2DTransfert;
import utility.operations.Calculator;
import utility.sets.SetSparseMapLong;

public class SoftMatrix2DTransfertDelta
extends SoftMatrix2DTransfert {
    private long[] deltas0;
    private long[] deltas1;

    @Override
    protected void project(int vap, int idx, long cost) {
        assert (cost != 0L);
        if (vap == 0) {
            Calculator.add(this.deltas0, idx, cost);
        } else {
            assert (vap == 1);
            Calculator.add(this.deltas1, idx, cost);
        }
        Calculator.add(this.scopeC1s[vap], idx, cost);
    }

    @Override
    public void projectAndStack(int vap, int idx, long cost) {
        int index;
        if (this.solver.depth() != this.lastModificationDepth()) {
            this.solver.observerCtrsSoft.push(this);
            ++this.top;
            this.stackedLevels[this.top] = this.solver.depth();
            if (this.sparseMaps[this.top] == null) {
                this.sparseMaps[this.top] = new SetSparseMapLong(this.sparseMaps[this.top - 1].capacity(), false);
            } else {
                this.sparseMaps[this.top].clear();
            }
        }
        if (!this.sparseMaps[this.top].isPresent(index = this.cumulatedSizes[vap] + idx)) {
            this.sparseMaps[this.top].add(index, vap == 0 ? this.deltas0[idx] : this.deltas1[idx]);
        }
        this.project(vap, idx, cost);
    }

    public SoftMatrix2DTransfertDelta(Constraint ctr) {
        super(ctr);
        this.deltas0 = new long[ctr.scp[0].dom.initSize()];
        this.deltas1 = new long[ctr.scp[1].dom.initSize()];
    }

    @Override
    public long getCostOfIdxs(int[] tuple) {
        return Calculator.add(Calculator.add(this.costsMatrix[tuple[0]][tuple[1]], -this.deltas0[tuple[0]]), -this.deltas1[tuple[1]]);
    }

    @Override
    public void restoreAtDepthBefore(int depthBeforeBacktrack) {
        assert (this.stackedLevels[this.top] == depthBeforeBacktrack);
        int[] dense = this.sparseMaps[this.top].dense;
        for (int i = this.sparseMaps[this.top].limit; i >= 0; --i) {
            long gap;
            int idx = dense[i];
            long delta = this.sparseMaps[this.top].values[idx];
            if (idx < this.cumulatedSizes[1]) {
                gap = Calculator.add(this.deltas0[idx], -delta);
                Calculator.add(this.scopeC1s[0], idx, -gap);
                this.deltas0[idx] = delta;
                continue;
            }
            gap = Calculator.add(this.deltas1[idx - this.cumulatedSizes[1]], -delta);
            Calculator.add(this.scopeC1s[1], idx - this.cumulatedSizes[1], -gap);
            this.deltas1[idx - this.cumulatedSizes[1]] = delta;
        }
        --this.top;
    }
}

