/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.primitive;

import constraints.hard.primitive.CtrPrimitiveBinary;
import problem.Problem;
import utility.Kit;
import variables.Variable;
import variables.domains.Domain;

public class Disjonctive
extends CtrPrimitiveBinary {
    private final int kx;
    private final int ky;

    @Override
    public boolean checkValues(int[] t) {
        return t[0] + this.kx <= t[1] || t[1] + this.ky <= t[0];
    }

    @Override
    public int[] defineSymmetryMatching() {
        return new int[]{1, this.kx == this.ky ? 1 : 2};
    }

    public Disjonctive(Problem pb, Variable x, int kx, Variable y, int ky) {
        super(pb, x, y);
        Kit.control(x.dom.typeIdentifier() == y.dom.typeIdentifier());
        this.kx = kx;
        this.ky = ky;
        this.defineKey(kx, ky);
    }

    private boolean filterDomain(Domain dom, int lbValue, int ubValue) {
        int a;
        if (lbValue > ubValue) {
            return true;
        }
        if (dom.size() == 1) {
            int v = dom.firstValue();
            return lbValue <= v && v <= ubValue ? dom.fail() : true;
        }
        int lb = dom.toIdx(lbValue);
        int ub = dom.toIdx(ubValue);
        int sizeBefore = dom.size();
        int n = a = dom.isPresent(lb) ? lb : dom.next(lb);
        while (a != -1 && a <= ub) {
            dom.removeElementary(a);
            a = dom.next(a);
        }
        return dom.afterElementaryCalls(sizeBefore);
    }

    @Override
    public boolean runPropagator(Variable dummy) {
        int maxy;
        int miny;
        int maxx;
        int minx;
        do {
            minx = this.dx.firstValue();
            maxx = this.dx.lastValue();
            miny = this.dy.firstValue();
            maxy = this.dy.lastValue();
            if (!this.filterDomain(this.dx, Math.max(minx, Math.min(maxx, maxy - this.kx) + 1), Math.min(maxx, Math.max(minx, miny + this.ky) - 1))) {
                return false;
            }
            if (this.filterDomain(this.dy, Math.max(miny, Math.min(maxy, maxx - this.ky) + 1), Math.min(maxy, Math.max(miny, minx + this.kx) - 1))) continue;
            return false;
        } while (minx != this.dx.firstValue() || maxx != this.dx.lastValue() || miny != this.dy.firstValue() || maxy != this.dy.lastValue());
        return true;
    }
}

