/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.intension;

import constraints.CtrHard;
import java.security.MessageDigest;
import java.util.Arrays;
import problem.Problem;
import utility.interfaces.TagUnsymmetric;
import variables.Variable;

public final class CtrHardRandomImplicit
extends CtrHard
implements TagUnsymmetric {
    private RandomGenerationImplicit implicitRandomList;
    private final byte tightness;
    private final int[] requiredSupport;

    @Override
    public final boolean checkValues(int[] t) {
        return Arrays.equals(this.requiredSupport, t) ? true : this.implicitRandomList.randomByteFor(t) >= this.tightness;
    }

    public CtrHardRandomImplicit(Problem pb, Variable[] scp, byte tightness, int instanceNumber, String algorithm, int[] requiredSupport) {
        super(pb, scp);
        this.tightness = tightness;
        this.requiredSupport = requiredSupport != null ? (int[])requiredSupport.clone() : null;
        this.implicitRandomList = new RandomGenerationImplicit(pb.stuff.collectedCtrsAtInit.size(), instanceNumber, scp.length, algorithm);
    }

    public CtrHardRandomImplicit(Problem pb, Variable[] scp, byte tightness, int instanceNumber, String algorithm) {
        this(pb, scp, tightness, instanceNumber, algorithm, null);
    }

    public static class RandomGenerationImplicit {
        private final MessageDigest md;
        private final byte[] bytes;

        public RandomGenerationImplicit(int prefix1, int prefix2, int arity, String algorithm) {
            this.bytes = new byte[arity + 3];
            short s = (short)prefix1;
            this.bytes[arity + 1] = (byte)(s & 0xFF);
            this.bytes[arity] = (byte)(s >> 8);
            s = (short)prefix2;
            this.bytes[arity + 2] = (byte)(s & 0xFF);
            try {
                this.md = MessageDigest.getInstance(algorithm);
            }
            catch (Exception e) {
                throw new IllegalArgumentException();
            }
        }

        public final byte randomByteFor(int[] tuple) {
            assert (tuple.length + 3 == this.bytes.length);
            for (int i = 0; i < tuple.length; ++i) {
                this.bytes[i] = (byte)(tuple[i] & 0xFF);
            }
            byte[] digest = this.md.digest(this.bytes);
            byte resultat = digest[0];
            for (int i = 1; i < digest.length; ++i) {
                resultat = (byte)(resultat ^ digest[i]);
            }
            return resultat;
        }
    }
}

