/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.intension;

import java.util.Arrays;
import java.util.Stack;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.predicates.EvaluationManager;
import org.xcsp.common.predicates.XNodeParent;
import utility.Kit;

public class CanonicalExpressionParser {
    private static final String SUB_ABS = "subabs";
    private XNodeParent<IVar> tree;
    public Node root;

    public String key() {
        return this.root.toString();
    }

    private Node buildInitialTree() {
        Stack<Node> stack = new Stack<Node>();
        for (String token : this.tree.toPostfixExpression(this.tree.vars()).split("\\s+")) {
            int arity = EvaluationManager.arityOf((String)token);
            if (arity == 0 || arity == -1) {
                stack.push(new Node(token));
                continue;
            }
            if (arity == 1) {
                Node child = (Node)stack.pop();
                if (token.equals(Types.TypeExpr.ABS.lcname) && child.label.equals(Types.TypeExpr.SUB.lcname)) {
                    child.label = SUB_ABS;
                    stack.push(child);
                    continue;
                }
                stack.push(new Node(token, child));
                continue;
            }
            if (arity == 2) {
                Node child2 = (Node)stack.pop();
                Node child1 = (Node)stack.pop();
                if (EvaluationManager.isSymmetric((String)token) && Utilities.isInteger((String)child1.label) && !Utilities.isInteger((String)child2.label)) {
                    Node tmp = child1;
                    child1 = child2;
                    child2 = tmp;
                }
                if (EvaluationManager.isAssociative((String)token) && (child2.label.equals(token) || child1.label.equals(token))) {
                    Node[] childs = new Node[(child2.label.equals(token) ? child2.childs.length : 1) + (child1.label.equals(token) ? child1.childs.length : 1)];
                    int cnt = 0;
                    if (child2.label.equals(token)) {
                        for (Node child : child2.childs) {
                            childs[cnt++] = child;
                        }
                    } else {
                        childs[cnt++] = child2;
                    }
                    if (child1.label.equals(token)) {
                        for (Node child : child1.childs) {
                            childs[cnt++] = child;
                        }
                    } else {
                        childs[cnt++] = child1;
                    }
                    stack.push(new Node(token, childs));
                    continue;
                }
                stack.push(new Node(token, new Node[]{child1, child2}));
                continue;
            }
            Node[] childs = new Node[arity];
            for (int j = arity - 1; j >= 0; --j) {
                childs[j] = (Node)stack.pop();
            }
            stack.push(new Node(token, childs));
        }
        assert (stack.size() == 1);
        return (Node)stack.pop();
    }

    public CanonicalExpressionParser(XNodeParent<IVar> tree) {
        this.tree = tree;
        this.root = this.buildInitialTree();
        this.root.renderCanonical();
    }

    public int[] computeSymmetryMatching() {
        int[] permutation = new int[this.tree.vars().length];
        int color = 1;
        for (int i = 0; i < permutation.length; ++i) {
            if (permutation[i] != 0) continue;
            for (int j = i + 1; j < permutation.length; ++j) {
                if (permutation[j] != 0) continue;
                Node node = this.root.cloneUnderPermutation("%" + i, "%" + j);
                node.renderCanonical();
                if (node.compareTo(this.root) != 0) continue;
                permutation[j] = color;
            }
            permutation[i] = color++;
        }
        return permutation;
    }

    public class Node
    implements Comparable<Node> {
        private String label;
        private Node[] childs;

        public String getLabel() {
            return this.label;
        }

        public Node getChild(int i) {
            return this.childs[i];
        }

        private Node(String label) {
            this.label = label;
            this.childs = new Node[0];
        }

        private Node(String label, Node child) {
            this.label = label;
            this.childs = new Node[]{child};
        }

        private Node(String label, Node[] childs) {
            this.label = label;
            this.childs = childs;
        }

        private Node cloneUnderPermutation(String label1, String label2) {
            if (this.childs.length == 0) {
                return this.label.equals(label1) ? new Node(label2) : (this.label.equals(label2) ? new Node(label1) : new Node(this.label));
            }
            Node[] newChilds = new Node[this.childs.length];
            for (int i = 0; i < this.childs.length; ++i) {
                newChilds[i] = this.childs[i].cloneUnderPermutation(label1, label2);
            }
            return new Node(this.label, newChilds);
        }

        @Override
        public int compareTo(Node node) {
            if (this.childs.length > node.childs.length) {
                return -1;
            }
            if (this.childs.length < node.childs.length) {
                return 1;
            }
            if (this.childs.length == 0) {
                int i2;
                if (this.label.startsWith("%")) {
                    return Utilities.isInteger((String)node.label) ? -1 : this.label.compareTo(node.label);
                }
                if (node.label.startsWith("%")) {
                    return 1;
                }
                int i1 = Integer.parseInt(this.label);
                return i1 < (i2 = Integer.parseInt(node.label)) ? -1 : (i1 == i2 ? 0 : 1);
            }
            if (!this.label.equals(node.label)) {
                return this.label.compareTo(node.label);
            }
            for (int i = 0; i < this.childs.length; ++i) {
                int res = this.childs[i].compareTo(node.childs[i]);
                if (res == 0) continue;
                return res;
            }
            return 0;
        }

        private void renderCanonical() {
            if (this.childs.length != 0) {
                for (Node child : this.childs) {
                    child.renderCanonical();
                }
                if (this.label.equals(CanonicalExpressionParser.SUB_ABS) || EvaluationManager.isSymmetric((String)this.label)) {
                    Arrays.sort(this.childs);
                } else if (this.childs.length == 2) {
                    Types.TypeConditionOperatorRel operator;
                    Types.TypeConditionOperatorRel typeConditionOperatorRel = operator = this.label == null ? null : (Types.TypeConditionOperatorRel)Types.valueOf(Types.TypeConditionOperatorRel.class, (String)this.label);
                    if (operator != null && Utilities.isInteger((String)this.childs[0].label) && !Utilities.isInteger((String)this.childs[1].label)) {
                        this.label = operator.arithmeticInversion().toString().toLowerCase();
                        Node tmp = this.childs[0];
                        this.childs[0] = this.childs[1];
                        this.childs[1] = tmp;
                    }
                }
            }
        }

        private boolean isProductTerm(int[] t) {
            if (this.label.startsWith("%")) {
                t[Integer.parseInt((String)this.label.substring((int)1))] = 1;
                return true;
            }
            if (this.label.equals(Types.TypeExpr.NEG.lcname)) {
                Kit.control(this.childs.length == 1 && this.childs[0].label.startsWith("%"));
                t[Integer.parseInt((String)this.childs[0].label.substring((int)1))] = -1;
                return true;
            }
            if (!this.label.equals(Types.TypeExpr.MUL.lcname)) {
                return false;
            }
            if (this.childs.length != 2) {
                return false;
            }
            if (!Utilities.isInteger((String)this.childs[1].label)) {
                return false;
            }
            if (!this.childs[0].label.startsWith("%")) {
                return false;
            }
            t[Integer.parseInt((String)this.childs[0].label.substring((int)1))] = Integer.parseInt(this.childs[1].label);
            return true;
        }

        public int[] isSumWeighted(int size) {
            Types.TypeConditionOperatorRel operator;
            Types.TypeConditionOperatorRel typeConditionOperatorRel = operator = this.label == null ? null : (Types.TypeConditionOperatorRel)Types.valueOf(Types.TypeConditionOperatorRel.class, (String)this.label);
            if (operator == null) {
                return null;
            }
            if (this.childs.length != 2) {
                return null;
            }
            if (!Utilities.isInteger((String)this.childs[1].label)) {
                return null;
            }
            Node leftChild = this.childs[0];
            if (!leftChild.label.equals(Types.TypeExpr.ADD.lcname)) {
                return null;
            }
            int[] t = new int[size];
            for (int i = 0; i < leftChild.childs.length; ++i) {
                if (leftChild.childs[i].isProductTerm(t)) continue;
                return null;
            }
            return t;
        }

        public Integer isPrecedence(boolean order) {
            if (!this.label.equals(Types.TypeExpr.LE.lcname)) {
                return null;
            }
            if (!this.childs[1].label.equals("%" + (order ? 1 : 0))) {
                return null;
            }
            Node leftChild = this.childs[0];
            if (!leftChild.label.equals(Types.TypeExpr.ADD.lcname)) {
                return null;
            }
            if (leftChild.childs.length != 2) {
                return null;
            }
            if (!leftChild.childs[0].label.equals("%" + (order ? 0 : 1))) {
                return null;
            }
            return Kit.parseInteger(leftChild.childs[1].label);
        }

        public int[] isDisjonctive() {
            if (!this.label.equals(Types.TypeExpr.OR.lcname)) {
                return null;
            }
            if (this.childs.length != 2) {
                return null;
            }
            Integer i1 = this.childs[0].isPrecedence(true);
            if (i1 == null) {
                return null;
            }
            Integer i2 = this.childs[1].isPrecedence(false);
            if (i2 == null) {
                return null;
            }
            return new int[]{i1, i2};
        }

        private StringBuilder toStringBuilder(StringBuilder sb) {
            for (int i = 0; i < this.childs.length; ++i) {
                this.childs[i].toStringBuilder(sb).append(' ');
            }
            return sb.append(this.label);
        }

        public String toString() {
            return this.toStringBuilder(new StringBuilder()).toString();
        }
    }
}

