/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.global;

import constraints.hard.global.SumAbstract;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import objectives.OptimizationCompatible;
import org.xcsp.common.Types;
import org.xcsp.modeler.definitions.DefXCSP;
import problem.Problem;
import utility.Kit;
import utility.exceptions.UnreachableCodeException;
import utility.interfaces.TagGuaranteedGAC;
import variables.Variable;
import variables.domains.Domain;

public abstract class SumWeighted
extends SumAbstract {
    public final int[] coeffs;

    @Override
    public final boolean checkValues(int[] t) {
        long sum = Kit.weightedSum(t, this.coeffs);
        switch (this.op) {
            case LE: {
                return sum <= this.limit;
            }
            case GE: {
                return sum >= this.limit;
            }
            case EQ: {
                return sum == this.limit;
            }
            case NE: {
                return sum != this.limit;
            }
        }
        throw new UnreachableCodeException();
    }

    public long minComputableObjectiveValue() {
        BigInteger sum = BigInteger.valueOf(0L);
        for (int i = 0; i < this.scp.length; ++i) {
            sum = sum.add(BigInteger.valueOf(this.coeffs[i]).multiply(BigInteger.valueOf(this.coeffs[i] >= 0 ? (long)this.scp[i].dom.toVal(0) : (long)this.scp[i].dom.toVal(this.scp[i].dom.initSize() - 1))));
        }
        return sum.longValueExact();
    }

    public long maxComputableObjectiveValue() {
        BigInteger sum = BigInteger.valueOf(0L);
        for (int i = 0; i < this.scp.length; ++i) {
            sum = sum.add(BigInteger.valueOf(this.coeffs[i]).multiply(BigInteger.valueOf(this.coeffs[i] >= 0 ? (long)this.scp[i].dom.toVal(this.scp[i].dom.initSize() - 1) : (long)this.scp[i].dom.toVal(0))));
        }
        return sum.longValueExact();
    }

    public SumWeighted(Problem pb, Variable[] scp, int[] coeffs, Types.TypeConditionOperatorRel op, long limit) {
        super(pb, scp, op, limit);
        this.coeffs = coeffs;
        this.defineKey(Kit.join((Object)coeffs, new String[0]), op, limit);
        Kit.control(IntStream.range(0, coeffs.length).allMatch(i -> coeffs[i] != 0 && (i == 0 || coeffs[i - 1] <= coeffs[i])));
        Kit.control(this.minComputableObjectiveValue() <= this.maxComputableObjectiveValue());
    }

    @Override
    public int[] defineSymmetryMatching() {
        int[] symmetryMatching = new int[this.scp.length];
        int color = 1;
        for (int i = 0; i < symmetryMatching.length; ++i) {
            if (symmetryMatching[i] != 0) continue;
            for (int j = i + 1; j < symmetryMatching.length; ++j) {
                if (symmetryMatching[j] != 0 || this.coeffs[i] != this.coeffs[j]) continue;
                symmetryMatching[j] = color;
            }
            symmetryMatching[i] = color++;
        }
        return symmetryMatching;
    }

    protected void recomputeBounds() {
        this.max = 0L;
        this.min = 0L;
        for (int i = 0; i < this.scp.length; ++i) {
            int coeff;
            Domain dom = this.scp[i].dom;
            this.min += (long)(coeff * ((coeff = this.coeffs[i]) >= 0 ? dom.firstValue() : dom.lastValue()));
            this.max += (long)(coeff * (coeff >= 0 ? dom.lastValue() : dom.firstValue()));
        }
    }

    protected long currWeightedSum() {
        long sum = 0L;
        for (int i = 0; i < this.scp.length; ++i) {
            sum += (long)(this.scp[i].dom.uniqueValue() * this.coeffs[i]);
        }
        return sum;
    }

    public DefXCSP defXCSP() {
        return new DefXCSP(SUM).addSon(LIST, (Object)this.compactOrdered(this.scp)).addSon(COEFFS, (Object)Kit.join((Object)this.coeffs, new String[0])).addSon(CONDITION, (Object)("(" + this.getClass().getSimpleName().substring(11).toLowerCase() + "," + this.limit + ")"));
    }

    public static final class SumWeightedNE
    extends SumWeighted
    implements TagGuaranteedGAC {
        private Variable sentinel1;
        private Variable sentinel2;

        public SumWeightedNE(Problem pb, Variable[] scp, int[] coeffs, long limit) {
            super(pb, scp, coeffs, Types.TypeConditionOperatorRel.NE, limit);
            Kit.control(scp.length >= 2 && !Arrays.stream(scp).anyMatch(x -> x.dom.size() == 1));
            this.sentinel1 = scp[0];
            this.sentinel2 = scp[scp.length - 1];
        }

        private Variable findAnotherSentinel() {
            for (Variable x : this.scp) {
                if (x == this.sentinel1 || x == this.sentinel2 || x.dom.size() <= 1) continue;
                return x;
            }
            return null;
        }

        private boolean filterDomainOf(Variable sentinel) {
            assert (sentinel.dom.size() > 1 && Stream.of(this.scp).filter(x -> x != sentinel).allMatch(x -> x.dom.size() == 1));
            int p = -1;
            long sum = 0L;
            for (int i = 0; i < this.scp.length; ++i) {
                if (this.scp[i] != sentinel) {
                    sum += (long)(this.scp[i].dom.uniqueValue() * this.coeffs[i]);
                    continue;
                }
                p = i;
            }
            long v = (this.limit - sum) / (long)this.coeffs[p];
            Kit.control(v * (long)this.coeffs[p] + sum == this.limit);
            if ((this.limit - sum) % (long)this.coeffs[p] == 0L && Integer.MIN_VALUE <= v && v <= Integer.MAX_VALUE) {
                sentinel.dom.removeValue((int)v, false);
            }
            return true;
        }

        @Override
        public boolean runPropagator(Variable x) {
            Variable y;
            if (this.sentinel1.dom.size() == 1) {
                y = this.findAnotherSentinel();
                if (y == null) {
                    return this.sentinel2.dom.size() == 1 ? this.currWeightedSum() != this.limit || x.dom.fail() : this.filterDomainOf(this.sentinel2);
                }
                this.sentinel1 = y;
            }
            if (this.sentinel2.dom.size() == 1) {
                y = this.findAnotherSentinel();
                if (y == null) {
                    return this.filterDomainOf(this.sentinel1);
                }
                this.sentinel2 = y;
            }
            return true;
        }
    }

    public static final class SumWeightedEQ
    extends SumWeighted {
        private boolean guaranteedGAC;

        public SumWeightedEQ(Problem pb, Variable[] scp, int[] coeffs, long limit) {
            super(pb, scp, coeffs, Types.TypeConditionOperatorRel.EQ, limit);
            this.guaranteedGAC = Stream.of(scp).allMatch(x -> x.dom.initSize() <= 2);
        }

        @Override
        public boolean isGuaranteedGAC() {
            return this.guaranteedGAC;
        }

        @Override
        public boolean runPropagator(Variable x) {
            this.recomputeBounds();
            if (this.min > this.limit || this.max < this.limit) {
                return x.dom.fail();
            }
            if (this.futvars.size() > 0) {
                int lastModified = this.futvars.limit;
                int i = this.futvars.limit;
                do {
                    int coeff;
                    Domain dom;
                    int sizeBefore;
                    if ((sizeBefore = (dom = this.scp[this.futvars.dense[i]].dom).size()) <= 1) continue;
                    this.min -= (long)(coeff * ((coeff = this.coeffs[this.futvars.dense[i]]) >= 0 ? dom.firstValue() : dom.lastValue()));
                    this.max -= (long)(coeff * (coeff >= 0 ? dom.lastValue() : dom.firstValue()));
                    if (!dom.removeValues(Types.TypeOperatorRel.LT, this.limit - this.max, coeff) || !dom.removeValues(Types.TypeOperatorRel.GT, this.limit - this.min, coeff)) {
                        return false;
                    }
                    if (sizeBefore != dom.size()) {
                        lastModified = i;
                    }
                    this.min += (long)(coeff * (coeff >= 0 ? dom.firstValue() : dom.lastValue()));
                    this.max += (long)(coeff * (coeff >= 0 ? dom.lastValue() : dom.firstValue()));
                } while (lastModified != (i = i > 0 ? i - 1 : this.futvars.limit));
            }
            assert (this.controlFCLevel());
            return true;
        }
    }

    public static class SumWeightedGE
    extends SumWeighted
    implements TagGuaranteedGAC,
    OptimizationCompatible {
        @Override
        public long objectiveValue() {
            return this.currWeightedSum();
        }

        public SumWeightedGE(Problem pb, Variable[] scp, int[] coeffs, long limit) {
            super(pb, scp, coeffs, Types.TypeConditionOperatorRel.GE, limit);
        }

        @Override
        public boolean runPropagator(Variable x) {
            this.recomputeBounds();
            if (this.min >= this.limit) {
                return true;
            }
            if (this.max < this.limit) {
                return x.dom.fail();
            }
            for (int i = this.futvars.limit; i >= 0; --i) {
                Domain dom = this.scp[this.futvars.dense[i]].dom;
                if (dom.size() == 1) continue;
                int coeff = this.coeffs[this.futvars.dense[i]];
                if (coeff >= 0) {
                    this.min -= (long)(dom.firstValue() * coeff);
                    dom.removeValues(Types.TypeOperatorRel.LT, this.limit - (this.max - (long)(dom.lastValue() * coeff)), coeff);
                    assert (dom.size() > 0);
                    this.min += (long)(dom.firstValue() * coeff);
                } else {
                    this.min -= (long)(dom.lastValue() * coeff);
                    dom.removeValues(Types.TypeOperatorRel.LT, this.limit - (this.max - (long)(dom.firstValue() * coeff)), coeff);
                    assert (dom.size() > 0);
                    this.min += (long)(dom.lastValue() * coeff);
                }
                if (this.min < this.limit) continue;
                return true;
            }
            return true;
        }
    }

    public static final class SumWeightedLE
    extends SumWeighted
    implements TagGuaranteedGAC,
    OptimizationCompatible {
        @Override
        public long objectiveValue() {
            return this.currWeightedSum();
        }

        public SumWeightedLE(Problem pb, Variable[] scp, int[] coeffs, long limit) {
            super(pb, scp, coeffs, Types.TypeConditionOperatorRel.LE, limit);
        }

        @Override
        public boolean runPropagator(Variable x) {
            this.recomputeBounds();
            if (this.max <= this.limit) {
                return true;
            }
            if (this.min > this.limit) {
                return x.dom.fail();
            }
            for (int i = this.futvars.limit; i >= 0; --i) {
                Domain dom = this.scp[this.futvars.dense[i]].dom;
                if (dom.size() == 1) continue;
                int coeff = this.coeffs[this.futvars.dense[i]];
                if (coeff >= 0) {
                    this.max -= (long)(dom.lastValue() * coeff);
                    dom.removeValues(Types.TypeOperatorRel.GT, this.limit - (this.min - (long)(dom.firstValue() * coeff)), coeff);
                    assert (dom.size() > 0);
                    this.max += (long)(dom.lastValue() * coeff);
                } else {
                    this.max -= (long)(dom.firstValue() * coeff);
                    dom.removeValues(Types.TypeOperatorRel.GT, this.limit - (this.min - (long)(dom.lastValue() * coeff)), coeff);
                    assert (dom.size() > 0);
                    this.max += (long)(dom.firstValue() * coeff);
                }
                if (this.max > this.limit) continue;
                return true;
            }
            return true;
        }
    }
}

