/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.global;

import constraints.hard.CtrGlobal;
import java.util.stream.IntStream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import problem.Problem;
import utility.Kit;
import utility.interfaces.TagCompleteFilteringAtEachCall;
import utility.interfaces.TagGuaranteedGAC;
import utility.sets.SetDense;
import variables.Variable;
import variables.domains.Domain;

public abstract class SumScalarBoolean
extends CtrGlobal {
    protected final Variable[] list;
    protected final Variable[] coeffs;
    protected final Types.TypeConditionOperatorRel op;
    protected final int half;
    protected final SetDense set01vs1;
    protected long min;
    protected long max;

    public SumScalarBoolean(Problem pb, Variable[] list, Variable[] coeffs, Types.TypeConditionOperatorRel op, Variable limit) {
        super(pb, (Variable[])pb.api.vars((Object)list, new Object[]{coeffs, limit}));
        this.list = list;
        this.coeffs = coeffs;
        this.op = op;
        this.half = list.length;
        this.set01vs1 = new SetDense(this.half);
        Kit.control(list.length == coeffs.length && Variable.areInitiallyBoolean((Variable[])pb.api.vars((Object)list, (IVar[])coeffs)));
    }

    public static final class SumScalarBooleanLEVar
    extends SumScalarBoolean
    implements TagGuaranteedGAC,
    TagCompleteFilteringAtEachCall {
        private final Variable limit;

        @Override
        public boolean checkValues(int[] t) {
            return IntStream.range(0, this.half).map(i -> t[i] * t[this.half + i]).sum() <= t[t.length - 1];
        }

        public SumScalarBooleanLEVar(Problem pb, Variable[] list, Variable[] coeffs, Variable limit) {
            super(pb, list, coeffs, Types.TypeConditionOperatorRel.LE, limit);
            this.limit = limit;
        }

        protected void recomputeBounds() {
            this.max = 0L;
            this.min = 0L;
            this.set01vs1.clear();
            for (int i = 0; i < this.half; ++i) {
                Domain dom1 = this.scp[i].dom;
                Domain dom2 = this.scp[i + this.half].dom;
                if (!dom1.isPresent(1) || !dom2.isPresent(1)) continue;
                ++this.max;
                if (!dom1.isPresent(0) && !dom2.isPresent(0)) {
                    ++this.min;
                    continue;
                }
                if (dom1.size() != 1 && dom2.size() != 1) continue;
                this.set01vs1.add(i);
            }
        }

        @Override
        public boolean runPropagator(Variable x) {
            this.recomputeBounds();
            if (!this.limit.dom.removeValues(Types.TypeOperatorRel.LT, this.min)) {
                return false;
            }
            int vlimit = this.limit.dom.lastValue();
            if (this.max <= (long)vlimit) {
                return true;
            }
            if (this.min == (long)vlimit) {
                for (int i = this.set01vs1.size() - 1; i >= 0; --i) {
                    int j = this.set01vs1.dense[i];
                    assert (this.scp[j].dom.size() == 2 && this.scp[this.half + j].dom.onlyContains(1) || this.scp[this.half + j].dom.size() == 2 && this.scp[j].dom.onlyContains(1));
                    if (this.scp[j].dom.size() == 2) {
                        this.scp[j].dom.remove(1);
                        continue;
                    }
                    this.scp[this.half + j].dom.remove(1);
                }
            }
            return true;
        }
    }

    public static final class SumScalarBooleanEQ
    extends SumScalarBoolean
    implements TagGuaranteedGAC,
    TagCompleteFilteringAtEachCall {
        protected int limit;
        private SetDense set01vs01;

        @Override
        public boolean checkValues(int[] t) {
            return IntStream.range(0, this.half).map(i -> t[i] * t[this.half + i]).sum() == this.limit;
        }

        public SumScalarBooleanEQ(Problem pb, Variable[] list, Variable[] coeffs, int limit) {
            super(pb, list, coeffs, Types.TypeConditionOperatorRel.EQ, null);
            this.limit = limit;
            this.set01vs01 = new SetDense(this.half);
        }

        protected void recomputeBounds() {
            this.max = 0L;
            this.min = 0L;
            this.set01vs1.clear();
            this.set01vs01.clear();
            for (int i = 0; i < this.half; ++i) {
                Domain dom1 = this.scp[i].dom;
                Domain dom2 = this.scp[i + this.half].dom;
                if (!dom1.isPresent(1) || !dom2.isPresent(1)) continue;
                ++this.max;
                if (!dom1.isPresent(0) && !dom2.isPresent(0)) {
                    ++this.min;
                    continue;
                }
                if (dom1.size() == 1 || dom2.size() == 1) {
                    this.set01vs1.add(i);
                    continue;
                }
                this.set01vs01.add(i);
            }
        }

        @Override
        public boolean runPropagator(Variable x) {
            block11: {
                int j;
                int i;
                block10: {
                    this.recomputeBounds();
                    if (this.min > (long)this.limit || this.max < (long)this.limit) {
                        return x.dom.fail();
                    }
                    if (this.min == this.max || this.min < (long)this.limit && (long)this.limit < this.max) {
                        return true;
                    }
                    if (this.min != (long)this.limit) break block10;
                    for (int i2 = this.set01vs1.size() - 1; i2 >= 0; --i2) {
                        int j2 = this.set01vs1.dense[i2];
                        assert (this.scp[j2].dom.size() == 2 && this.scp[this.half + j2].dom.onlyContains(1) || this.scp[this.half + j2].dom.size() == 2 && this.scp[j2].dom.onlyContains(1));
                        if (this.scp[j2].dom.size() == 2) {
                            this.scp[j2].dom.remove(1);
                            continue;
                        }
                        this.scp[this.half + j2].dom.remove(1);
                    }
                    break block11;
                }
                if (this.max != (long)this.limit) break block11;
                for (i = this.set01vs1.size() - 1; i >= 0; --i) {
                    j = this.set01vs1.dense[i];
                    assert (this.scp[j].dom.size() == 2 && this.scp[this.half + j].dom.onlyContains(1) || this.scp[this.half + j].dom.size() == 2 && this.scp[j].dom.onlyContains(1));
                    if (this.scp[j].dom.size() == 2) {
                        this.scp[j].dom.remove(0);
                        continue;
                    }
                    this.scp[this.half + j].dom.remove(0);
                }
                for (i = this.set01vs01.size() - 1; i >= 0; --i) {
                    j = this.set01vs01.dense[i];
                    assert (this.scp[j].dom.size() == 2 && this.scp[this.half + j].dom.size() == 2);
                    this.scp[j].dom.remove(0);
                    this.scp[this.half + j].dom.remove(0);
                }
            }
            return true;
        }
    }

    public static final class SumScalarBooleanLE
    extends SumScalarBoolean
    implements TagGuaranteedGAC,
    TagCompleteFilteringAtEachCall {
        protected int limit;

        @Override
        public boolean checkValues(int[] t) {
            return IntStream.range(0, this.half).map(i -> t[i] * t[this.half + i]).sum() <= this.limit;
        }

        public SumScalarBooleanLE(Problem pb, Variable[] list, Variable[] coeffs, int limit) {
            super(pb, list, coeffs, Types.TypeConditionOperatorRel.LE, null);
            this.limit = limit;
        }

        protected void recomputeBounds() {
            this.max = 0L;
            this.min = 0L;
            this.set01vs1.clear();
            for (int i = 0; i < this.half; ++i) {
                Domain dom1 = this.scp[i].dom;
                Domain dom2 = this.scp[i + this.half].dom;
                if (!dom1.isPresent(1) || !dom2.isPresent(1)) continue;
                ++this.max;
                if (!dom1.isPresent(0) && !dom2.isPresent(0)) {
                    ++this.min;
                    continue;
                }
                if (dom1.size() != 1 && dom2.size() != 1) continue;
                this.set01vs1.add(i);
            }
        }

        @Override
        public boolean runPropagator(Variable x) {
            this.recomputeBounds();
            if (this.max <= (long)this.limit) {
                return true;
            }
            if (this.min > (long)this.limit) {
                return x.dom.fail();
            }
            if (this.min == (long)this.limit) {
                for (int i = this.set01vs1.size() - 1; i >= 0; --i) {
                    int j = this.set01vs1.dense[i];
                    assert (this.scp[j].dom.size() == 2 && this.scp[this.half + j].dom.onlyContains(1) || this.scp[this.half + j].dom.size() == 2 && this.scp[j].dom.onlyContains(1));
                    if (this.scp[j].dom.size() == 2) {
                        this.scp[j].dom.remove(1);
                        continue;
                    }
                    this.scp[this.half + j].dom.remove(1);
                }
            }
            return true;
        }
    }
}

